/*
 * Decompiled with CFR 0.152.
 */
package nc.ird.cantharella.data.model.search;

import nc.ird.cantharella.data.model.Extrait;
import nc.ird.cantharella.data.model.Fraction;
import nc.ird.cantharella.data.model.Lot;
import nc.ird.cantharella.data.model.Produit;
import org.apache.commons.lang3.StringUtils;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.Fieldable;
import org.hibernate.search.bridge.FieldBridge;
import org.hibernate.search.bridge.LuceneOptions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProduitBridge
implements FieldBridge {
    private static final Logger LOG = LoggerFactory.getLogger(ProduitBridge.class);

    public void set(String name, Object value, Document document, LuceneOptions luceneOptions) {
        Produit produit = (Produit)value;
        if (LOG.isTraceEnabled()) {
            LOG.trace("Custom indexing of Produit entity : " + produit);
        }
        Lot lot = null;
        if (produit instanceof Extrait) {
            if (LOG.isTraceEnabled()) {
                LOG.trace("Custom indexing of Extrait entity");
            }
            Extrait extrait = (Extrait)produit;
            lot = extrait.getExtraction().getLot();
        } else if (produit instanceof Fraction) {
            if (LOG.isTraceEnabled()) {
                LOG.trace("Custom indexing of Fraction entity");
            }
            Fraction fraction = (Fraction)produit;
            lot = fraction.getPurification().getLotSource();
        }
        document.add((Fieldable)new Field(name + ".lot.ref", lot.getRef(), luceneOptions.getStore(), luceneOptions.getIndex(), luceneOptions.getTermVector()));
        if (StringUtils.isNotBlank((CharSequence)lot.getSpecimenRef().getEmbranchement())) {
            document.add((Fieldable)new Field(name + ".lot.specimen.embranchement", lot.getSpecimenRef().getEmbranchement(), luceneOptions.getStore(), luceneOptions.getIndex(), luceneOptions.getTermVector()));
        }
        if (StringUtils.isNotBlank((CharSequence)lot.getSpecimenRef().getFamille())) {
            document.add((Fieldable)new Field(name + ".lot.specimen.famille", lot.getSpecimenRef().getFamille(), luceneOptions.getStore(), luceneOptions.getIndex(), luceneOptions.getTermVector()));
        }
        if (StringUtils.isNotBlank((CharSequence)lot.getSpecimenRef().getGenre())) {
            document.add((Fieldable)new Field(name + ".lot.specimen.genre", lot.getSpecimenRef().getGenre(), luceneOptions.getStore(), luceneOptions.getIndex(), luceneOptions.getTermVector()));
        }
        if (StringUtils.isNotBlank((CharSequence)lot.getSpecimenRef().getEspece())) {
            document.add((Fieldable)new Field(name + ".lot.specimen.espece", lot.getSpecimenRef().getEspece(), luceneOptions.getStore(), luceneOptions.getIndex(), luceneOptions.getTermVector()));
        }
        document.add((Fieldable)new Field(name + ".lot.campagne.nom", lot.getCampagne().getNom(), luceneOptions.getStore(), luceneOptions.getIndex(), luceneOptions.getTermVector()));
        document.add((Fieldable)new Field(name + ".lot.campagne.codePays", lot.getCampagne().getCodePays(), luceneOptions.getStore(), luceneOptions.getIndex(), luceneOptions.getTermVector()));
    }
}

