/*
 * Decompiled with CFR 0.152.
 */
package nc.ird.cantharella.data.model;

import java.util.ArrayList;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.Embeddable;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.Lob;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import nc.ird.cantharella.data.model.Campagne;
import nc.ird.cantharella.data.model.Document;
import nc.ird.cantharella.data.model.Lot;
import nc.ird.cantharella.data.model.Personne;
import nc.ird.cantharella.data.model.Specimen;
import nc.ird.cantharella.data.model.utils.AbstractModel;
import nc.ird.cantharella.data.model.utils.DocumentAttachable;
import nc.ird.cantharella.data.validation.CountryCode;
import nc.ird.cantharella.data.validation.Latitude;
import nc.ird.cantharella.data.validation.Longitude;
import nc.ird.cantharella.data.validation.Referentiel;
import org.apache.commons.beanutils.BeanComparator;
import org.hibernate.annotations.AccessType;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.CascadeType;
import org.hibernate.annotations.Fetch;
import org.hibernate.annotations.FetchMode;
import org.hibernate.annotations.Type;
import org.hibernate.search.annotations.ContainedIn;
import org.hibernate.search.annotations.Field;
import org.hibernate.search.annotations.Indexed;
import org.hibernate.search.annotations.IndexedEmbedded;
import org.hibernate.validator.constraints.Length;
import org.hibernate.validator.constraints.NotEmpty;

@Entity
@Table
@AccessType(value="field")
@Indexed
@Embeddable
public class Station
extends AbstractModel
implements Cloneable,
Comparable<Station>,
DocumentAttachable {
    @Id
    @GeneratedValue
    private Integer idStation;
    @Column(unique=true)
    @NotEmpty
    @Length(max=60)
    @Field
    private String nom;
    @NotNull
    @Length(min=2, max=2)
    @CountryCode
    @Field
    private String codePays;
    @Lob
    @Type(type="org.hibernate.type.StringClobType")
    private String complement;
    @NotNull
    @ManyToOne(fetch=FetchType.LAZY, optional=false)
    private Personne createur;
    @Length(max=60)
    @Field
    private String localite;
    @Latitude
    private String latitude;
    @Longitude
    private String longitude;
    @Referentiel
    private Integer referentiel;
    @NotNull
    @OneToMany(mappedBy="station", fetch=FetchType.LAZY)
    @ContainedIn
    private List<Lot> lots = new ArrayList<Lot>();
    @NotNull
    @ManyToMany(mappedBy="stations", fetch=FetchType.EAGER)
    @Fetch(value=FetchMode.SUBSELECT)
    @IndexedEmbedded
    private List<Campagne> campagnes = new ArrayList<Campagne>();
    @OneToMany(mappedBy="station", fetch=FetchType.LAZY)
    @ContainedIn
    private List<Specimen> specimensRattaches;
    @OneToMany(fetch=FetchType.EAGER, orphanRemoval=true)
    @JoinColumn(name="station")
    @Cascade(value={CascadeType.SAVE_UPDATE})
    @Fetch(value=FetchMode.SUBSELECT)
    private List<Document> documents = new ArrayList<Document>();

    public Station clone() throws CloneNotSupportedException {
        Station clone = (Station)super.clone();
        clone.idStation = this.idStation;
        clone.nom = this.nom;
        clone.codePays = this.codePays;
        clone.complement = this.complement;
        clone.createur = this.createur;
        clone.localite = this.localite;
        clone.latitude = this.latitude;
        clone.longitude = this.longitude;
        clone.referentiel = this.referentiel;
        return clone;
    }

    public String toString() {
        return this.nom;
    }

    @Override
    public int compareTo(Station station) {
        return new BeanComparator("nom").compare((Object)this, (Object)station);
    }

    public Integer getIdStation() {
        return this.idStation;
    }

    public void setIdStation(Integer idStation) {
        this.idStation = idStation;
    }

    public String getNom() {
        return this.nom;
    }

    public void setNom(String nom) {
        this.nom = nom;
    }

    public String getCodePays() {
        return this.codePays;
    }

    public void setCodePays(String codePays) {
        this.codePays = codePays;
    }

    public String getComplement() {
        return this.complement;
    }

    public void setComplement(String complement) {
        this.complement = complement;
    }

    public Personne getCreateur() {
        return this.createur;
    }

    public void setCreateur(Personne createur) {
        this.createur = createur;
    }

    public String getLocalite() {
        return this.localite;
    }

    public void setLocalite(String localite) {
        this.localite = localite;
    }

    public String getLatitude() {
        return this.latitude;
    }

    public void setLatitude(String latitude) {
        this.latitude = latitude;
    }

    public String getLongitude() {
        return this.longitude;
    }

    public void setLongitude(String longitude) {
        this.longitude = longitude;
    }

    public Integer getReferentiel() {
        return this.referentiel;
    }

    public void setReferentiel(Integer referentiel) {
        this.referentiel = referentiel;
    }

    public List<Lot> getLots() {
        return this.lots;
    }

    public void setLots(List<Lot> lots) {
        this.lots = lots;
    }

    public List<Campagne> getCampagnes() {
        return this.campagnes;
    }

    public void setCampagnes(List<Campagne> campagnes) {
        this.campagnes = campagnes;
    }

    public List<Specimen> getSpecimensRattaches() {
        return this.specimensRattaches;
    }

    public void setSpecimensRattaches(List<Specimen> specimensRattaches) {
        this.specimensRattaches = specimensRattaches;
    }

    @Override
    public List<Document> getDocuments() {
        return this.documents;
    }

    public void setDocuments(List<Document> documents) {
        this.documents = documents;
    }

    @Override
    public void addDocument(Document document) {
        this.documents.add(document);
    }

    @Override
    public void removeDocument(Document document) {
        this.documents.remove(document);
    }
}

