/*
 * Decompiled with CFR 0.152.
 */
package nc.ird.cantharella.data.model;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.Embeddable;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.Lob;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.validation.constraints.NotNull;
import nc.ird.cantharella.data.model.Document;
import nc.ird.cantharella.data.model.Personne;
import nc.ird.cantharella.data.model.Station;
import nc.ird.cantharella.data.model.utils.AbstractModel;
import nc.ird.cantharella.data.model.utils.DocumentAttachable;
import org.apache.commons.beanutils.BeanComparator;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.CascadeType;
import org.hibernate.annotations.Fetch;
import org.hibernate.annotations.FetchMode;
import org.hibernate.annotations.Type;
import org.hibernate.search.annotations.Field;
import org.hibernate.search.annotations.Indexed;
import org.hibernate.search.annotations.IndexedEmbedded;
import org.hibernate.search.annotations.Store;
import org.hibernate.validator.constraints.Length;
import org.hibernate.validator.constraints.NotEmpty;

@Entity
@Table
@Indexed
@Embeddable
public class Specimen
extends AbstractModel
implements Comparable<Specimen>,
DocumentAttachable {
    @Id
    @GeneratedValue
    private Integer idSpecimen;
    @Column(unique=true)
    @NotEmpty
    @Length(max=10)
    @Field(store=Store.YES)
    private String ref;
    @Length(max=60)
    @NotEmpty
    @Field
    private String embranchement;
    @Length(max=60)
    @Field
    private String famille;
    @Length(max=60)
    @Field
    private String genre;
    @Length(max=60)
    @Field
    private String espece;
    @Length(max=60)
    private String sousEspece;
    @Length(max=60)
    private String variete;
    @NotNull
    @Enumerated(value=EnumType.ORDINAL)
    private TypeOrganisme typeOrganisme;
    @ManyToOne(fetch=FetchType.EAGER)
    private Personne identificateur;
    @Temporal(value=TemporalType.DATE)
    private Date dateDepot;
    @Length(max=10)
    private String numDepot;
    @Length(max=60)
    private String lieuDepot;
    @ManyToOne(fetch=FetchType.EAGER)
    @IndexedEmbedded
    private Station station;
    @Lob
    @Type(type="org.hibernate.type.StringClobType")
    private String complement;
    @NotNull
    @ManyToOne(fetch=FetchType.LAZY, optional=false)
    private Personne createur;
    @OneToMany(fetch=FetchType.EAGER, orphanRemoval=true)
    @JoinColumn(name="specimen")
    @Cascade(value={CascadeType.SAVE_UPDATE})
    @Fetch(value=FetchMode.SUBSELECT)
    private List<Document> documents = new ArrayList<Document>();

    public String toString() {
        return this.ref;
    }

    @Override
    public int compareTo(Specimen specimen) {
        return new BeanComparator("ref").compare((Object)this, (Object)specimen);
    }

    public Integer getIdSpecimen() {
        return this.idSpecimen;
    }

    public void setIdSpecimen(Integer idSpecimen) {
        this.idSpecimen = idSpecimen;
    }

    public String getRef() {
        return this.ref;
    }

    public void setRef(String ref) {
        this.ref = ref;
    }

    public String getEmbranchement() {
        return this.embranchement;
    }

    public void setEmbranchement(String embranchement) {
        this.embranchement = embranchement;
    }

    public String getFamille() {
        return this.famille;
    }

    public void setFamille(String famille) {
        this.famille = famille;
    }

    public String getGenre() {
        return this.genre;
    }

    public void setGenre(String genre) {
        this.genre = genre;
    }

    public String getEspece() {
        return this.espece;
    }

    public void setEspece(String espece) {
        this.espece = espece;
    }

    public String getSousEspece() {
        return this.sousEspece;
    }

    public void setSousEspece(String sousEspece) {
        this.sousEspece = sousEspece;
    }

    public String getVariete() {
        return this.variete;
    }

    public void setVariete(String variete) {
        this.variete = variete;
    }

    public TypeOrganisme getTypeOrganisme() {
        return this.typeOrganisme;
    }

    public void setTypeOrganisme(TypeOrganisme typeOrganisme) {
        this.typeOrganisme = typeOrganisme;
    }

    public Personne getIdentificateur() {
        return this.identificateur;
    }

    public void setIdentificateur(Personne identificateur) {
        this.identificateur = identificateur;
    }

    public Date getDateDepot() {
        return this.dateDepot;
    }

    public void setDateDepot(Date dateDepot) {
        this.dateDepot = dateDepot;
    }

    public String getNumDepot() {
        return this.numDepot;
    }

    public void setNumDepot(String numDepot) {
        this.numDepot = numDepot;
    }

    public String getLieuDepot() {
        return this.lieuDepot;
    }

    public void setLieuDepot(String lieuDepot) {
        this.lieuDepot = lieuDepot;
    }

    public Station getStation() {
        return this.station;
    }

    public void setStation(Station station) {
        this.station = station;
    }

    public String getComplement() {
        return this.complement;
    }

    public void setComplement(String complement) {
        this.complement = complement;
    }

    public Personne getCreateur() {
        return this.createur;
    }

    public void setCreateur(Personne createur) {
        this.createur = createur;
    }

    @Override
    public List<Document> getDocuments() {
        return this.documents;
    }

    public void setDocuments(List<Document> documents) {
        this.documents = documents;
    }

    @Override
    public void addDocument(Document document) {
        this.documents.add(document);
    }

    @Override
    public void removeDocument(Document document) {
        this.documents.remove(document);
    }

    public static enum TypeOrganisme implements Comparable<TypeOrganisme>
    {
        PLANTE,
        ORGANISME_MARIN,
        MICROORGANISME,
        INSECTE,
        CHAMPIGNON,
        LICHEN,
        AUTRE;

    }
}

