/*
 * Decompiled with CFR 0.152.
 */
package nc.ird.cantharella.data.model;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.Lob;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.validation.constraints.Future;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import nc.ird.cantharella.data.model.Document;
import nc.ird.cantharella.data.model.Extrait;
import nc.ird.cantharella.data.model.Fraction;
import nc.ird.cantharella.data.model.Lot;
import nc.ird.cantharella.data.model.MethodePurification;
import nc.ird.cantharella.data.model.ParamMethoPuriEffectif;
import nc.ird.cantharella.data.model.Personne;
import nc.ird.cantharella.data.model.Produit;
import nc.ird.cantharella.data.model.comparators.FractionsOfPurificationComp;
import nc.ird.cantharella.data.model.utils.AbstractModel;
import nc.ird.cantharella.data.model.utils.DocumentAttachable;
import nc.ird.cantharella.utils.AssertTools;
import org.apache.commons.beanutils.BeanComparator;
import org.apache.commons.collections.comparators.ComparatorChain;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.CascadeType;
import org.hibernate.annotations.Fetch;
import org.hibernate.annotations.FetchMode;
import org.hibernate.annotations.Type;
import org.hibernate.search.annotations.ContainedIn;
import org.hibernate.search.annotations.Field;
import org.hibernate.search.annotations.Indexed;
import org.hibernate.search.annotations.IndexedEmbedded;
import org.hibernate.search.annotations.Store;
import org.hibernate.validator.constraints.Length;
import org.hibernate.validator.constraints.NotEmpty;

@Entity
@Indexed
public class Purification
extends AbstractModel
implements Comparable<Purification>,
DocumentAttachable {
    @Id
    @GeneratedValue
    private Integer idPurification;
    @Length(max=60)
    @Column(unique=true)
    @NotEmpty
    @Field(store=Store.YES)
    private String ref;
    @NotNull
    @ManyToOne(fetch=FetchType.LAZY, optional=false)
    private Personne manipulateur;
    @NotNull
    @Temporal(value=TemporalType.DATE)
    private Date date;
    @NotNull
    @ManyToOne(fetch=FetchType.EAGER, optional=false)
    @IndexedEmbedded
    private MethodePurification methode;
    @NotNull
    @OneToMany(mappedBy="purification", fetch=FetchType.LAZY, orphanRemoval=true)
    @Cascade(value={CascadeType.SAVE_UPDATE})
    private List<ParamMethoPuriEffectif> paramsMetho;
    @NotNull
    @ManyToOne(fetch=FetchType.EAGER, optional=false)
    @IndexedEmbedded
    private Produit produit;
    @Min(value=0L)
    @Max(value=99999L)
    @Column(precision=9, scale=4)
    private BigDecimal masseDepart;
    @Lob
    @Type(type="org.hibernate.type.StringClobType")
    private String complement;
    private boolean confidentiel;
    @Future
    @Temporal(value=TemporalType.DATE)
    private Date dateConfidentialite;
    @NotNull
    @ManyToOne(fetch=FetchType.LAZY, optional=false)
    private Personne createur;
    @NotNull
    @OneToMany(mappedBy="purification", fetch=FetchType.LAZY, orphanRemoval=true)
    @Cascade(value={CascadeType.REFRESH, CascadeType.SAVE_UPDATE})
    @ContainedIn
    private List<Fraction> fractions = new ArrayList<Fraction>();
    @ManyToOne(fetch=FetchType.EAGER, optional=false)
    @IndexedEmbedded
    private Lot lotSource;
    @OneToMany(fetch=FetchType.EAGER, orphanRemoval=true)
    @JoinColumn(name="purification")
    @Cascade(value={CascadeType.SAVE_UPDATE})
    @Fetch(value=FetchMode.SUBSELECT)
    private List<Document> documents;

    public Purification() {
        this.paramsMetho = new ArrayList<ParamMethoPuriEffectif>();
        this.documents = new ArrayList<Document>();
    }

    public String toString() {
        return this.ref;
    }

    @Override
    public int compareTo(Purification purification) {
        ComparatorChain comparatorChain = new ComparatorChain();
        comparatorChain.addComparator((Comparator)new BeanComparator("produit"));
        comparatorChain.addComparator((Comparator)new BeanComparator("ref"));
        return comparatorChain.compare((Object)this, (Object)purification);
    }

    public void setProduit(Produit produit) {
        this.lotSource = this.findLotSourceFromProduit(produit);
        this.produit = produit;
    }

    public List<Fraction> getSortedFractions() {
        Collections.sort(this.fractions, new FractionsOfPurificationComp());
        return this.fractions;
    }

    public List<ParamMethoPuriEffectif> getSortedParamsMetho() {
        Collections.sort(this.paramsMetho, new BeanComparator("param.index"));
        return this.paramsMetho;
    }

    public Integer getIdPurification() {
        return this.idPurification;
    }

    public void setIdPurification(Integer idPurification) {
        this.idPurification = idPurification;
    }

    public String getRef() {
        return this.ref;
    }

    public void setRef(String ref) {
        this.ref = ref;
    }

    public Personne getManipulateur() {
        return this.manipulateur;
    }

    public void setManipulateur(Personne manipulateur) {
        this.manipulateur = manipulateur;
    }

    public Date getDate() {
        return this.date;
    }

    public void setDate(Date date) {
        this.date = date;
    }

    public MethodePurification getMethode() {
        return this.methode;
    }

    public void setMethode(MethodePurification methode) {
        this.methode = methode;
    }

    public List<ParamMethoPuriEffectif> getParamsMetho() {
        return this.paramsMetho;
    }

    public void setParamsMetho(List<ParamMethoPuriEffectif> paramsMetho) {
        this.paramsMetho = paramsMetho;
    }

    public BigDecimal getMasseDepart() {
        return this.masseDepart;
    }

    public void setMasseDepart(BigDecimal masseDepart) {
        this.masseDepart = masseDepart;
    }

    public String getComplement() {
        return this.complement;
    }

    public void setComplement(String complement) {
        this.complement = complement;
    }

    public boolean isConfidentiel() {
        return this.confidentiel;
    }

    public void setConfidentiel(boolean confidentiel) {
        this.confidentiel = confidentiel;
    }

    public Date getDateConfidentialite() {
        return this.dateConfidentialite;
    }

    public void setDateConfidentialite(Date dateConfidentialite) {
        this.dateConfidentialite = dateConfidentialite;
    }

    public Personne getCreateur() {
        return this.createur;
    }

    public void setCreateur(Personne createur) {
        this.createur = createur;
    }

    public Lot getLotSource() {
        return this.lotSource;
    }

    public List<Fraction> getFractions() {
        return this.fractions;
    }

    public void setFractions(List<Fraction> fractions) {
        this.fractions = fractions;
    }

    public void setLotSource(Lot lotSource) {
        this.lotSource = lotSource;
    }

    public Produit getProduit() {
        return this.produit;
    }

    public Lot findLotSourceFromProduit(Produit produit) {
        Produit curProd = produit;
        while (curProd.isFraction()) {
            Fraction curFraction = (Fraction)curProd;
            curProd = curFraction.getPurification().getProduit();
        }
        AssertTools.assertClassOrInterface((Object)curProd, Extrait.class);
        Extrait extrait = (Extrait)curProd;
        return extrait.getExtraction().getLot();
    }

    @Override
    public List<Document> getDocuments() {
        return this.documents;
    }

    public void setDocuments(List<Document> documents) {
        this.documents = documents;
    }

    @Override
    public void addDocument(Document document) {
        this.documents.add(document);
    }

    @Override
    public void removeDocument(Document document) {
        this.documents.remove(document);
    }
}

