/*
 * Decompiled with CFR 0.152.
 */
package nc.ird.cantharella.data.model;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.OneToMany;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import nc.ird.cantharella.data.model.Purification;
import nc.ird.cantharella.data.model.ResultatTestBio;
import nc.ird.cantharella.data.model.search.ProduitBridge;
import nc.ird.cantharella.data.model.utils.AbstractModel;
import org.apache.commons.beanutils.BeanComparator;
import org.hibernate.search.annotations.ClassBridge;
import org.hibernate.search.annotations.ContainedIn;
import org.hibernate.search.annotations.Field;
import org.hibernate.search.annotations.Index;
import org.hibernate.search.annotations.Store;
import org.hibernate.validator.constraints.Length;
import org.hibernate.validator.constraints.NotEmpty;

@Entity
@Inheritance(strategy=InheritanceType.JOINED)
@ClassBridge(name="produit", index=Index.YES, store=Store.YES, impl=ProduitBridge.class)
public abstract class Produit
extends AbstractModel
implements Cloneable,
Comparable<Produit> {
    @Id
    @GeneratedValue
    private Integer id;
    @Length(max=60)
    @NotEmpty
    @Column(unique=true)
    @Field(store=Store.YES)
    private String ref;
    @Min(value=0L)
    @Max(value=99999L)
    @Column(precision=9, scale=4)
    private BigDecimal masseObtenue;
    @NotNull
    @OneToMany(mappedBy="produit", fetch=FetchType.LAZY)
    @ContainedIn
    private List<Purification> purificationsSuivantes = new ArrayList<Purification>();
    @NotNull
    @OneToMany(mappedBy="produit", fetch=FetchType.LAZY)
    @ContainedIn
    private List<ResultatTestBio> resultatsTestsBioSuivants = new ArrayList<ResultatTestBio>();

    public abstract boolean isExtrait();

    public abstract boolean isFraction();

    public Produit clone() throws CloneNotSupportedException {
        Produit clone = (Produit)super.clone();
        clone.id = this.id;
        clone.ref = this.ref;
        return clone;
    }

    public String toString() {
        return this.ref;
    }

    @Override
    public int compareTo(Produit produit) {
        return new BeanComparator("ref").compare((Object)this, (Object)produit);
    }

    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public String getRef() {
        return this.ref;
    }

    public void setRef(String ref) {
        this.ref = ref;
    }

    public BigDecimal getMasseObtenue() {
        return this.masseObtenue;
    }

    public void setMasseObtenue(BigDecimal masseObtenue) {
        this.masseObtenue = masseObtenue;
    }

    public List<Purification> getPurificationsSuivantes() {
        return this.purificationsSuivantes;
    }

    public void setPurificationsSuivantes(List<Purification> purificationsSuivantes) {
        this.purificationsSuivantes = purificationsSuivantes;
    }

    public List<ResultatTestBio> getResultatsTestsBioSuivants() {
        return this.resultatsTestsBioSuivants;
    }

    public void setResultatsTestsBioSuivants(List<ResultatTestBio> resultatsTestsBioSuivants) {
        this.resultatsTestsBioSuivants = resultatsTestsBioSuivants;
    }
}

