/*
 * Decompiled with CFR 0.152.
 */
package nc.ird.cantharella.data.model;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.Embeddable;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.Lob;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Past;
import nc.ird.cantharella.data.model.Campagne;
import nc.ird.cantharella.data.model.Document;
import nc.ird.cantharella.data.model.Extraction;
import nc.ird.cantharella.data.model.LotGroupeDroits;
import nc.ird.cantharella.data.model.LotPersonneDroits;
import nc.ird.cantharella.data.model.Partie;
import nc.ird.cantharella.data.model.Personne;
import nc.ird.cantharella.data.model.Specimen;
import nc.ird.cantharella.data.model.Station;
import nc.ird.cantharella.data.model.utils.AbstractModel;
import nc.ird.cantharella.data.model.utils.DocumentAttachable;
import org.apache.commons.beanutils.BeanComparator;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.CascadeType;
import org.hibernate.annotations.Fetch;
import org.hibernate.annotations.FetchMode;
import org.hibernate.annotations.Type;
import org.hibernate.search.annotations.ContainedIn;
import org.hibernate.search.annotations.Field;
import org.hibernate.search.annotations.Indexed;
import org.hibernate.search.annotations.IndexedEmbedded;
import org.hibernate.search.annotations.Store;
import org.hibernate.validator.constraints.Length;
import org.hibernate.validator.constraints.NotEmpty;

@Entity
@Table
@Indexed
@Embeddable
public class Lot
extends AbstractModel
implements Comparable<Lot>,
DocumentAttachable {
    @Id
    @GeneratedValue
    private Integer idLot;
    @Column(unique=true)
    @NotEmpty
    @Length(max=60)
    @Field(store=Store.YES)
    private String ref;
    @NotNull
    @ManyToOne(fetch=FetchType.EAGER, optional=false)
    @IndexedEmbedded
    private Campagne campagne;
    @Lob
    @Type(type="org.hibernate.type.StringClobType")
    private String complement;
    @NotNull
    @ManyToOne(fetch=FetchType.LAZY, optional=false)
    private Personne createur;
    @Past
    @Temporal(value=TemporalType.DATE)
    @NotNull
    private Date dateRecolte;
    @NotNull
    private Boolean echantillonColl;
    @NotNull
    private Boolean echantillonIdent;
    @NotNull
    private Boolean echantillonPhylo;
    @OneToMany(mappedBy="id.pk1", fetch=FetchType.LAZY)
    @NotNull
    private List<LotGroupeDroits> groupesDroits;
    @Min(value=0L)
    @Max(value=99999L)
    @Column(precision=9, scale=4)
    private BigDecimal masseFraiche;
    @Min(value=0L)
    @Max(value=99999L)
    @Column(precision=9, scale=4)
    private BigDecimal masseSeche;
    @ManyToOne(fetch=FetchType.EAGER, optional=true)
    @IndexedEmbedded
    private Partie partie;
    @OneToMany(mappedBy="id.pk1", fetch=FetchType.LAZY)
    @NotNull
    private List<LotPersonneDroits> personnesDroits = new ArrayList<LotPersonneDroits>();
    @NotNull
    @ManyToOne(fetch=FetchType.EAGER, optional=false)
    @IndexedEmbedded(depth=1)
    private Specimen specimenRef;
    @NotNull
    @ManyToOne(fetch=FetchType.EAGER, optional=false)
    @IndexedEmbedded
    private Station station;
    @OneToMany(mappedBy="lot", fetch=FetchType.LAZY)
    @NotNull
    @ContainedIn
    private List<Extraction> extractions;
    @OneToMany(fetch=FetchType.EAGER, orphanRemoval=true)
    @JoinColumn(name="lot")
    @Cascade(value={CascadeType.SAVE_UPDATE})
    @Fetch(value=FetchMode.SUBSELECT)
    private List<Document> documents;

    public Lot() {
        this.groupesDroits = new ArrayList<LotGroupeDroits>();
        this.extractions = new ArrayList<Extraction>();
        this.documents = new ArrayList<Document>();
    }

    public String toString() {
        return this.ref;
    }

    @Override
    public int compareTo(Lot lot) {
        return new BeanComparator("ref").compare((Object)this, (Object)lot);
    }

    public Campagne getCampagne() {
        return this.campagne;
    }

    public void setCampagne(Campagne campagne) {
        this.campagne = campagne;
    }

    public String getComplement() {
        return this.complement;
    }

    public void setComplement(String complement) {
        this.complement = complement;
    }

    public Personne getCreateur() {
        return this.createur;
    }

    public void setCreateur(Personne createur) {
        this.createur = createur;
    }

    public Date getDateRecolte() {
        return this.dateRecolte;
    }

    public void setDateRecolte(Date dateRecolte) {
        this.dateRecolte = dateRecolte;
    }

    public Boolean getEchantillonColl() {
        return this.echantillonColl;
    }

    public void setEchantillonColl(Boolean echantillonColl) {
        this.echantillonColl = echantillonColl;
    }

    public Boolean getEchantillonIdent() {
        return this.echantillonIdent;
    }

    public void setEchantillonIdent(Boolean echantillonIdent) {
        this.echantillonIdent = echantillonIdent;
    }

    public Boolean getEchantillonPhylo() {
        return this.echantillonPhylo;
    }

    public void setEchantillonPhylo(Boolean echantillonPhylo) {
        this.echantillonPhylo = echantillonPhylo;
    }

    public List<LotGroupeDroits> getGroupesDroits() {
        return this.groupesDroits;
    }

    public void setGroupesDroits(List<LotGroupeDroits> groupesDroits) {
        this.groupesDroits = groupesDroits;
    }

    public Integer getIdLot() {
        return this.idLot;
    }

    public void setIdLot(Integer idLot) {
        this.idLot = idLot;
    }

    public BigDecimal getMasseFraiche() {
        return this.masseFraiche;
    }

    public void setMasseFraiche(BigDecimal masseFraiche) {
        this.masseFraiche = masseFraiche;
    }

    public BigDecimal getMasseSeche() {
        return this.masseSeche;
    }

    public void setMasseSeche(BigDecimal masseSeche) {
        this.masseSeche = masseSeche;
    }

    public Partie getPartie() {
        return this.partie;
    }

    public void setPartie(Partie partie) {
        this.partie = partie;
    }

    public List<LotPersonneDroits> getPersonnesDroits() {
        return this.personnesDroits;
    }

    public void setPersonnesDroits(List<LotPersonneDroits> personnesDroits) {
        this.personnesDroits = personnesDroits;
    }

    public String getRef() {
        return this.ref;
    }

    public void setRef(String ref) {
        this.ref = ref;
    }

    public Specimen getSpecimenRef() {
        return this.specimenRef;
    }

    public void setSpecimenRef(Specimen specimenRef) {
        this.specimenRef = specimenRef;
    }

    public Station getStation() {
        return this.station;
    }

    public void setStation(Station station) {
        this.station = station;
    }

    public List<Extraction> getExtractions() {
        return this.extractions;
    }

    public void setExtractions(List<Extraction> extractions) {
        this.extractions = extractions;
    }

    @Override
    public List<Document> getDocuments() {
        return this.documents;
    }

    public void setDocuments(List<Document> documents) {
        this.documents = documents;
    }

    @Override
    public void addDocument(Document document) {
        this.documents.add(document);
    }

    @Override
    public void removeDocument(Document document) {
        this.documents.remove(document);
    }
}

