/*
 * Decompiled with CFR 0.152.
 */
package nc.ird.cantharella.data.model;

import javax.persistence.Embeddable;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ManyToOne;
import javax.validation.constraints.NotNull;
import nc.ird.cantharella.data.model.Produit;
import nc.ird.cantharella.data.model.Purification;
import nc.ird.cantharella.data.validation.CollectionUniqueField;
import org.hibernate.search.annotations.IndexedEmbedded;
import org.hibernate.validator.constraints.Length;
import org.hibernate.validator.constraints.NotEmpty;

@Entity
@CollectionUniqueField(fieldName="ref", pathToCollection="purification.fractions")
@Embeddable
public class Fraction
extends Produit {
    @Length(max=5)
    @NotEmpty
    private String indice;
    @NotNull
    @ManyToOne(fetch=FetchType.EAGER, optional=false)
    @IndexedEmbedded
    private Purification purification;

    public Float getRendement() {
        Float rendement;
        if (this.getPurification() != null && this.getPurification().getMasseDepart() != null && this.getPurification().getMasseDepart().floatValue() != 0.0f && this.getMasseObtenue() != null && (rendement = Float.valueOf(this.getMasseObtenue().floatValue() / this.getPurification().getMasseDepart().floatValue())).floatValue() <= 1.0f && rendement.floatValue() >= 0.0f) {
            return rendement;
        }
        return null;
    }

    @Override
    public boolean isExtrait() {
        return false;
    }

    @Override
    public boolean isFraction() {
        return true;
    }

    @Override
    public Fraction clone() throws CloneNotSupportedException {
        Fraction clone = (Fraction)super.clone();
        clone.indice = this.indice;
        clone.purification = this.purification;
        return clone;
    }

    public String getIndice() {
        return this.indice;
    }

    public void setIndice(String indice) {
        this.indice = indice;
    }

    public Purification getPurification() {
        return this.purification;
    }

    public void setPurification(Purification purification) {
        this.purification = purification;
    }
}

