/*
 * Decompiled with CFR 0.152.
 */
package nc.ird.cantharella.data.validation.utils;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.MessageInterpolator;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import javax.validation.metadata.ConstraintDescriptor;
import nc.ird.cantharella.data.model.utils.AbstractModel;
import nc.ird.cantharella.data.validation.utils.ModelValidator;
import nc.ird.module.utils.AssertTools;
import nc.ird.module.utils.LogTools;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.springframework.context.NoSuchMessageException;
import org.springframework.context.support.MessageSourceAccessor;

public final class ModelValidatorImpl
implements ModelValidator {
    static final Log LOG = LogTools.getLog();
    private static final String PATTERN_ERROR_MESSAGE = "%s - %s";
    private static final String PATTERN_ERROR_PROPERTY = "%s.%s";
    private final MessageInterpolator messageInterpolator;
    private MessageSourceAccessor[] messageSources;
    private final Validator validator;

    public ModelValidatorImpl(ValidatorFactory validatorFactory, MessageSourceAccessor ... messageSourceAccessorArray) {
        AssertTools.assertNotNull((Object)validatorFactory);
        this.messageInterpolator = validatorFactory.getMessageInterpolator();
        this.validator = validatorFactory.getValidator();
        this.messageSources = messageSourceAccessorArray;
    }

    @Override
    public <M extends AbstractModel> void debug(Class<M> clazz, M m) {
        if (LOG.isDebugEnabled()) {
            for (ConstraintViolation constraintViolation : this.validator.validate(m, new Class[0])) {
                LOG.debug((Object)constraintViolation.getMessage());
            }
        }
    }

    @Override
    public <M> List<String> validate(M m, Locale locale, String ... stringArray) {
        Set<ConstraintViolation<M>> set = this.validate(m, stringArray);
        ArrayList<String> arrayList = new ArrayList<String>(set.size());
        for (final ConstraintViolation<M> constraintViolation : set) {
            Class clazz = constraintViolation.getRootBeanClass();
            String string = null;
            String string2 = StringUtils.isEmpty((String)constraintViolation.getPropertyPath().toString()) ? this.getMessage(clazz.getSimpleName(), locale) : String.format(PATTERN_ERROR_PROPERTY, clazz.getSimpleName(), constraintViolation.getPropertyPath());
            try {
                string = this.getMessage(string2, locale);
            }
            catch (NoSuchMessageException noSuchMessageException) {
                // empty catch block
            }
            while (string == null && !Object.class.equals((Object)clazz)) {
                clazz = clazz.getSuperclass();
                try {
                    if (StringUtils.isEmpty((String)constraintViolation.getPropertyPath().toString())) {
                        this.getMessage(clazz.getSimpleName(), locale);
                        continue;
                    }
                    this.getMessage(String.format(PATTERN_ERROR_PROPERTY, clazz.getSimpleName(), constraintViolation.getPropertyPath()), locale);
                }
                catch (NoSuchMessageException noSuchMessageException) {}
            }
            if (string == null) {
                string = string2;
            }
            arrayList.add(String.format(PATTERN_ERROR_MESSAGE, string, this.messageInterpolator.interpolate(constraintViolation.getMessageTemplate(), new MessageInterpolator.Context(){

                public ConstraintDescriptor<?> getConstraintDescriptor() {
                    return constraintViolation.getConstraintDescriptor();
                }

                public Object getValidatedValue() {
                    return constraintViolation.getInvalidValue();
                }
            }, locale)));
        }
        return arrayList;
    }

    private <M> Set<ConstraintViolation<M>> validate(M m, String ... stringArray) {
        if (stringArray == null || stringArray.length == 0) {
            return this.validator.validate(m, new Class[0]);
        }
        HashSet<ConstraintViolation<M>> hashSet = new HashSet<ConstraintViolation<M>>();
        for (String string : stringArray) {
            hashSet.addAll(this.validator.validateProperty(m, string, new Class[0]));
        }
        return hashSet;
    }

    private String getMessage(String string, Locale locale) {
        String string2 = null;
        for (int i = 0; string2 == null && i < this.messageSources.length; ++i) {
            MessageSourceAccessor messageSourceAccessor = this.messageSources[i];
            string2 = messageSourceAccessor.getMessage(string, null, null, locale);
        }
        return string2;
    }
}

