/*
 * Decompiled with CFR 0.152.
 */
package nc.ird.cantharella.data.validation.utils;

import java.util.HashSet;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.ConstraintViolationException;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import nc.ird.module.utils.AssertTools;
import nc.ird.module.utils.LogTools;
import org.apache.commons.logging.Log;
import org.hibernate.EntityMode;
import org.hibernate.event.AbstractPreDatabaseOperationEvent;
import org.hibernate.event.PreInsertEvent;
import org.hibernate.event.PreInsertEventListener;
import org.hibernate.event.PreUpdateEvent;
import org.hibernate.event.PreUpdateEventListener;

public final class ModelValidatorEventListener
implements PreInsertEventListener,
PreUpdateEventListener {
    private static final Log LOG = LogTools.getLog();
    private final Validator validator;

    public ModelValidatorEventListener(ValidatorFactory validatorFactory) {
        AssertTools.assertNotNull((Object)validatorFactory);
        this.validator = validatorFactory.getValidator();
    }

    public boolean onPreInsert(PreInsertEvent preInsertEvent) {
        this.validate((AbstractPreDatabaseOperationEvent)preInsertEvent, Operation.INSERT);
        return false;
    }

    public boolean onPreUpdate(PreUpdateEvent preUpdateEvent) {
        this.validate((AbstractPreDatabaseOperationEvent)preUpdateEvent, Operation.UPDATE);
        return false;
    }

    private void validate(AbstractPreDatabaseOperationEvent abstractPreDatabaseOperationEvent, Operation operation) {
        Set set;
        Object object = abstractPreDatabaseOperationEvent.getEntity();
        if (abstractPreDatabaseOperationEvent.getEntity() != null && abstractPreDatabaseOperationEvent.getSession().getEntityMode() == EntityMode.POJO && !(set = this.validator.validate(object, new Class[0])).isEmpty()) {
            LOG.error((Object)("Validation before " + operation.name() + " " + object.getClass().getName() + ":"));
            for (ConstraintViolation constraintViolation : set) {
                LOG.error((Object)("- " + constraintViolation.getPropertyPath() + ": " + constraintViolation.getMessage()));
            }
            throw new ConstraintViolationException("Validation failed before " + operation.name() + " " + object.getClass().getName(), new HashSet(set));
        }
    }

    private static enum Operation {
        INSERT,
        UPDATE;

    }
}

