/*
 * Decompiled with CFR 0.152.
 */
package nc.ird.cantharella.data.validation;

import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import nc.ird.cantharella.data.validation.QueryConstraint;
import nc.ird.module.utils.LogTools;
import org.apache.commons.logging.Log;
import org.hibernate.Query;
import org.hibernate.SessionFactory;
import org.hibernate.Transaction;
import org.hibernate.classic.Session;
import org.springframework.beans.BeanWrapperImpl;
import org.springframework.beans.factory.annotation.Autowired;

public class QueryConstraintValidator
implements ConstraintValidator<QueryConstraint, String> {
    private static final Log LOG = LogTools.getLog();
    private String hql;
    private String[] params;
    @Autowired
    private SessionFactory sessionFactory;

    public void initialize(QueryConstraint queryConstraint) {
        this.hql = queryConstraint.hql();
        this.params = this.createParameterList(this.hql);
    }

    public boolean isValid(String string, ConstraintValidatorContext constraintValidatorContext) {
        BeanWrapperImpl beanWrapperImpl = new BeanWrapperImpl((Object)string);
        if (this.sessionFactory != null) {
            LOG.debug((Object)"Enabled - Validating constraint with: ");
            LOG.debug((Object)this.hql);
            Session session = this.sessionFactory.openSession();
            Transaction transaction = session.beginTransaction();
            Query query = session.createQuery(this.hql);
            for (String string2 : this.params) {
                query.setParameter(string2, beanWrapperImpl.getPropertyValue(string2));
            }
            boolean bl = (Long)query.uniqueResult() == 0L;
            transaction.commit();
            session.close();
            return bl;
        }
        return true;
    }

    private String[] createParameterList(String string) {
        Matcher matcher = Pattern.compile(":[^\\s]*").matcher(string);
        ArrayList<String> arrayList = new ArrayList<String>();
        while (matcher.find()) {
            arrayList.add(this.hql.substring(matcher.start() + 1, matcher.end()));
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }
}

