/*
 * Decompiled with CFR 0.152.
 */
package nc.ird.cantharella.data.model.utils;

import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.Collections;
import java.util.Map;
import java.util.TreeMap;
import javax.persistence.EmbeddedId;
import javax.persistence.Id;
import nc.ird.cantharella.data.exceptions.UnexpectedException;
import nc.ird.module.utils.AssertTools;
import nc.ird.module.utils.BeanTools;
import nc.ird.module.utils.LogTools;
import org.apache.commons.logging.Log;

public abstract class AbstractModel
implements Serializable {
    private static final Map<String, Field> ID_FIELDS = Collections.synchronizedMap(new TreeMap());
    protected static final int LENGTH_LONG_TEXT = 100;
    protected static final int LENGTH_MEDIUM_TEXT = 60;
    protected static final int LENGTH_TINY_TEXT = 10;
    private static final Log LOG = LogTools.getLog();

    public final Field getIdField() {
        return AbstractModel.getIdField(this.getClass());
    }

    public static final Field getIdField(Class<? extends AbstractModel> clazz) {
        AssertTools.assertNotNull(clazz);
        Field field = null;
        String string = clazz.getName();
        field = ID_FIELDS.get(string);
        if (field == null) {
            try {
                field = BeanTools.getAnnotatedPrivateField(clazz, (Class[])new Class[]{Id.class, EmbeddedId.class});
            }
            catch (NoSuchFieldException noSuchFieldException) {
                LOG.error((Object)noSuchFieldException.getMessage(), (Throwable)noSuchFieldException);
                throw new UnexpectedException(noSuchFieldException);
            }
            ID_FIELDS.put(string, field);
        }
        return field;
    }

    public final Serializable getIdValue() {
        return (Serializable)BeanTools.getValue((Object)this, (BeanTools.AccessType)BeanTools.AccessType.GETTER, (String)this.getIdField().getName());
    }
}

