/*
 * Decompiled with CFR 0.152.
 */
package nc.ird.cantharella.data.model;

import java.util.Date;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.validation.constraints.NotNull;
import nc.ird.cantharella.data.model.Groupe;
import nc.ird.cantharella.data.model.Personne;
import org.hibernate.annotations.Index;
import org.hibernate.validator.constraints.Length;

@Entity
@Table
public class Utilisateur
extends Personne {
    @Temporal(value=TemporalType.DATE)
    private Date dateValiditeCompte;
    @NotNull
    @Index(name="estValide")
    private Boolean estValide;
    @ManyToOne(fetch=FetchType.LAZY, optional=true)
    private Groupe groupe;
    @Length(min=40, max=40)
    @NotNull
    private String passwordHash;
    @NotNull
    @Enumerated(value=EnumType.ORDINAL)
    @Index(name="typeDroit")
    private TypeDroit typeDroit;

    public Date getDateValiditeCompte() {
        return this.dateValiditeCompte;
    }

    public void setDateValiditeCompte(Date date) {
        this.dateValiditeCompte = date;
    }

    public Boolean isValide() {
        return this.estValide;
    }

    public void setValide(Boolean bl) {
        this.estValide = bl;
    }

    public Groupe getGroupe() {
        return this.groupe;
    }

    public void setGroupe(Groupe groupe) {
        this.groupe = groupe;
    }

    public String getPasswordHash() {
        return this.passwordHash;
    }

    public void setPasswordHash(String string) {
        this.passwordHash = string;
    }

    public TypeDroit getTypeDroit() {
        return this.typeDroit;
    }

    public void setTypeDroit(TypeDroit typeDroit) {
        this.typeDroit = typeDroit;
    }

    public static enum TypeDroit implements Comparable<TypeDroit>
    {
        ADMINISTRATEUR,
        UTILISATEUR;

    }
}

