/*
 * Decompiled with CFR 0.152.
 */
package nc.ird.cantharella.data.model;

import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Lob;
import javax.persistence.ManyToOne;
import javax.validation.constraints.NotNull;
import nc.ird.cantharella.data.model.MethodeExtraction;
import nc.ird.cantharella.data.model.utils.AbstractModel;
import nc.ird.cantharella.data.validation.CollectionUniqueField;
import org.apache.commons.beanutils.BeanComparator;
import org.hibernate.validator.constraints.Length;
import org.hibernate.validator.constraints.NotEmpty;

@Entity
@CollectionUniqueField(fieldName="initiales", pathToCollection="methodeExtraction.typesEnSortie")
public class TypeExtrait
extends AbstractModel
implements Cloneable,
Comparable<TypeExtrait> {
    @Id
    @GeneratedValue
    private Integer idTypeExtrait;
    @Length(max=10)
    @NotEmpty
    private String initiales;
    @NotEmpty
    @Lob
    private String description;
    @NotNull
    @ManyToOne(fetch=FetchType.LAZY, optional=false)
    private MethodeExtraction methodeExtraction;

    public TypeExtrait clone() throws CloneNotSupportedException {
        TypeExtrait typeExtrait = (TypeExtrait)super.clone();
        typeExtrait.idTypeExtrait = this.idTypeExtrait;
        typeExtrait.initiales = this.initiales;
        typeExtrait.description = this.description;
        typeExtrait.methodeExtraction = this.methodeExtraction;
        return typeExtrait;
    }

    public String toString() {
        return this.initiales;
    }

    @Override
    public int compareTo(TypeExtrait typeExtrait) {
        return new BeanComparator("initiales").compare((Object)this, (Object)typeExtrait);
    }

    public Integer getIdTypeExtrait() {
        return this.idTypeExtrait;
    }

    public void setIdTypeExtrait(Integer n) {
        this.idTypeExtrait = n;
    }

    public String getInitiales() {
        return this.initiales;
    }

    public void setInitiales(String string) {
        this.initiales = string;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String string) {
        this.description = string;
    }

    public MethodeExtraction getMethodeExtraction() {
        return this.methodeExtraction;
    }

    public void setMethodeExtraction(MethodeExtraction methodeExtraction) {
        this.methodeExtraction = methodeExtraction;
    }
}

