/*
 * Decompiled with CFR 0.152.
 */
package nc.ird.cantharella.data.model;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Lob;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.validation.constraints.Future;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import nc.ird.cantharella.data.model.MethodeTestBio;
import nc.ird.cantharella.data.model.Personne;
import nc.ird.cantharella.data.model.ResultatTestBio;
import nc.ird.cantharella.data.model.comparators.ResultatsOfTestBioComp;
import nc.ird.cantharella.data.model.utils.AbstractModel;
import org.apache.commons.beanutils.BeanComparator;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.CascadeType;
import org.hibernate.validator.constraints.Length;
import org.hibernate.validator.constraints.NotEmpty;

@Entity
public class TestBio
extends AbstractModel
implements Comparable<TestBio> {
    @Id
    @GeneratedValue
    private Integer idTestBio;
    @Length(max=60)
    @Column(unique=true)
    @NotEmpty
    private String ref;
    @NotNull
    @ManyToOne(fetch=FetchType.LAZY, optional=false)
    private Personne manipulateur;
    @NotNull
    @Length(max=60)
    private String organismeTesteur;
    @NotNull
    @Temporal(value=TemporalType.DATE)
    private Date date;
    @NotNull
    @ManyToOne(fetch=FetchType.LAZY, optional=false)
    private MethodeTestBio methode;
    @Min(value=0L)
    @Max(value=99999L)
    @Column(precision=9, scale=4)
    private BigDecimal concMasseDefaut;
    @Enumerated(value=EnumType.ORDINAL)
    private ResultatTestBio.UniteConcMasse uniteConcMasseDefaut;
    private ResultatTestBio.Stade stadeDefaut;
    @Lob
    private String complement;
    private boolean confidentiel;
    @Future
    @Temporal(value=TemporalType.DATE)
    private Date dateConfidentialite;
    @NotNull
    @ManyToOne(fetch=FetchType.LAZY, optional=false)
    private Personne createur;
    @NotNull
    @OneToMany(mappedBy="testBio", fetch=FetchType.LAZY, orphanRemoval=true)
    @Cascade(value={CascadeType.SAVE_UPDATE})
    private List<ResultatTestBio> resultats = new ArrayList<ResultatTestBio>();

    public String toString() {
        return this.ref;
    }

    @Override
    public int compareTo(TestBio testBio) {
        return new BeanComparator("ref").compare((Object)this, (Object)testBio);
    }

    public List<ResultatTestBio> getSortedResultats() {
        Collections.sort(this.resultats, new ResultatsOfTestBioComp());
        return this.resultats;
    }

    public Integer getIdTestBio() {
        return this.idTestBio;
    }

    public void setIdTestBio(Integer n) {
        this.idTestBio = n;
    }

    public String getRef() {
        return this.ref;
    }

    public void setRef(String string) {
        this.ref = string;
    }

    public Personne getManipulateur() {
        return this.manipulateur;
    }

    public void setManipulateur(Personne personne) {
        this.manipulateur = personne;
    }

    public String getOrganismeTesteur() {
        return this.organismeTesteur;
    }

    public void setOrganismeTesteur(String string) {
        this.organismeTesteur = string;
    }

    public Date getDate() {
        return this.date;
    }

    public void setDate(Date date) {
        this.date = date;
    }

    public MethodeTestBio getMethode() {
        return this.methode;
    }

    public void setMethode(MethodeTestBio methodeTestBio) {
        this.methode = methodeTestBio;
    }

    public BigDecimal getConcMasseDefaut() {
        return this.concMasseDefaut;
    }

    public void setConcMasseDefaut(BigDecimal bigDecimal) {
        this.concMasseDefaut = bigDecimal;
    }

    public ResultatTestBio.UniteConcMasse getUniteConcMasseDefaut() {
        return this.uniteConcMasseDefaut;
    }

    public void setUniteConcMasseDefaut(ResultatTestBio.UniteConcMasse uniteConcMasse) {
        this.uniteConcMasseDefaut = uniteConcMasse;
    }

    public ResultatTestBio.Stade getStadeDefaut() {
        return this.stadeDefaut;
    }

    public void setStadeDefaut(ResultatTestBio.Stade stade) {
        this.stadeDefaut = stade;
    }

    public String getComplement() {
        return this.complement;
    }

    public void setComplement(String string) {
        this.complement = string;
    }

    public boolean isConfidentiel() {
        return this.confidentiel;
    }

    public void setConfidentiel(boolean bl) {
        this.confidentiel = bl;
    }

    public Date getDateConfidentialite() {
        return this.dateConfidentialite;
    }

    public void setDateConfidentialite(Date date) {
        this.dateConfidentialite = date;
    }

    public Personne getCreateur() {
        return this.createur;
    }

    public void setCreateur(Personne personne) {
        this.createur = personne;
    }

    public List<ResultatTestBio> getResultats() {
        return this.resultats;
    }

    public void setResultats(List<ResultatTestBio> list) {
        this.resultats = list;
    }
}

