/*
 * Decompiled with CFR 0.152.
 */
package nc.ird.cantharella.data.model;

import java.util.ArrayList;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Lob;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import nc.ird.cantharella.data.model.Campagne;
import nc.ird.cantharella.data.model.Lot;
import nc.ird.cantharella.data.model.Personne;
import nc.ird.cantharella.data.model.Specimen;
import nc.ird.cantharella.data.model.utils.AbstractModel;
import nc.ird.cantharella.data.validation.CountryCode;
import nc.ird.cantharella.data.validation.Latitude;
import nc.ird.cantharella.data.validation.Longitude;
import nc.ird.cantharella.data.validation.Referentiel;
import org.apache.commons.beanutils.BeanComparator;
import org.hibernate.annotations.AccessType;
import org.hibernate.validator.constraints.Length;
import org.hibernate.validator.constraints.NotEmpty;

@Entity
@Table
@AccessType(value="field")
public class Station
extends AbstractModel
implements Cloneable,
Comparable<Station> {
    @Id
    @GeneratedValue
    private Integer idStation;
    @Column(unique=true)
    @NotEmpty
    @Length(max=60)
    private String nom;
    @NotNull
    @Length(min=2, max=2)
    @CountryCode
    private String codePays;
    @Lob
    private String complement;
    @NotNull
    @ManyToOne(fetch=FetchType.LAZY, optional=false)
    private Personne createur;
    @Length(max=60)
    private String localite;
    @Latitude
    private String latitude;
    @Longitude
    private String longitude;
    @Referentiel
    private Integer referentiel;
    @NotNull
    @OneToMany(mappedBy="station", fetch=FetchType.LAZY)
    private List<Lot> lots = new ArrayList<Lot>();
    @NotNull
    @ManyToMany(mappedBy="stations", fetch=FetchType.LAZY)
    private List<Campagne> campagnes = new ArrayList<Campagne>();
    @OneToMany(mappedBy="station", fetch=FetchType.LAZY)
    private List<Specimen> specimensRattaches;

    public Station clone() throws CloneNotSupportedException {
        Station station = (Station)super.clone();
        station.idStation = this.idStation;
        station.nom = this.nom;
        station.codePays = this.codePays;
        station.complement = this.complement;
        station.createur = this.createur;
        station.localite = this.localite;
        station.latitude = this.latitude;
        station.longitude = this.longitude;
        station.referentiel = this.referentiel;
        return station;
    }

    public String toString() {
        return this.nom;
    }

    @Override
    public int compareTo(Station station) {
        return new BeanComparator("nom").compare((Object)this, (Object)station);
    }

    public Integer getIdStation() {
        return this.idStation;
    }

    public void setIdStation(Integer n) {
        this.idStation = n;
    }

    public String getNom() {
        return this.nom;
    }

    public void setNom(String string) {
        this.nom = string;
    }

    public String getCodePays() {
        return this.codePays;
    }

    public void setCodePays(String string) {
        this.codePays = string;
    }

    public String getComplement() {
        return this.complement;
    }

    public void setComplement(String string) {
        this.complement = string;
    }

    public Personne getCreateur() {
        return this.createur;
    }

    public void setCreateur(Personne personne) {
        this.createur = personne;
    }

    public String getLocalite() {
        return this.localite;
    }

    public void setLocalite(String string) {
        this.localite = string;
    }

    public String getLatitude() {
        return this.latitude;
    }

    public void setLatitude(String string) {
        this.latitude = string;
    }

    public String getLongitude() {
        return this.longitude;
    }

    public void setLongitude(String string) {
        this.longitude = string;
    }

    public Integer getReferentiel() {
        return this.referentiel;
    }

    public void setReferentiel(Integer n) {
        this.referentiel = n;
    }

    public List<Lot> getLots() {
        return this.lots;
    }

    public void setLots(List<Lot> list) {
        this.lots = list;
    }

    public List<Campagne> getCampagnes() {
        return this.campagnes;
    }

    public void setCampagnes(List<Campagne> list) {
        this.campagnes = list;
    }

    public List<Specimen> getSpecimensRattaches() {
        return this.specimensRattaches;
    }

    public void setSpecimensRattaches(List<Specimen> list) {
        this.specimensRattaches = list;
    }
}

