/*
 * Decompiled with CFR 0.152.
 */
package nc.ird.cantharella.data.model;

import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Lob;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.validation.constraints.NotNull;
import nc.ird.cantharella.data.model.Personne;
import nc.ird.cantharella.data.model.Station;
import nc.ird.cantharella.data.model.utils.AbstractModel;
import org.apache.commons.beanutils.BeanComparator;
import org.hibernate.validator.constraints.Length;
import org.hibernate.validator.constraints.NotEmpty;

@Entity
@Table
public class Specimen
extends AbstractModel
implements Comparable<Specimen> {
    @Id
    @GeneratedValue
    private Integer idSpecimen;
    @Column(unique=true)
    @NotEmpty
    @Length(max=10)
    private String ref;
    @Length(max=60)
    @NotEmpty
    private String embranchement;
    @Length(max=60)
    private String famille;
    @Length(max=60)
    private String genre;
    @Length(max=60)
    private String espece;
    @Length(max=60)
    private String sousEspece;
    @Length(max=60)
    private String variete;
    @NotNull
    @Enumerated(value=EnumType.ORDINAL)
    private TypeOrganisme typeOrganisme;
    @ManyToOne(fetch=FetchType.EAGER)
    private Personne identificateur;
    @Temporal(value=TemporalType.DATE)
    private Date dateDepot;
    @Length(max=10)
    private String numDepot;
    @Length(max=60)
    private String lieuDepot;
    @ManyToOne(fetch=FetchType.EAGER)
    private Station station;
    @Lob
    private String complement;
    @NotNull
    @ManyToOne(fetch=FetchType.LAZY, optional=false)
    private Personne createur;

    public String toString() {
        return this.ref;
    }

    @Override
    public int compareTo(Specimen specimen) {
        return new BeanComparator("ref").compare((Object)this, (Object)specimen);
    }

    public Integer getIdSpecimen() {
        return this.idSpecimen;
    }

    public void setIdSpecimen(Integer n) {
        this.idSpecimen = n;
    }

    public String getRef() {
        return this.ref;
    }

    public void setRef(String string) {
        this.ref = string;
    }

    public String getEmbranchement() {
        return this.embranchement;
    }

    public void setEmbranchement(String string) {
        this.embranchement = string;
    }

    public String getFamille() {
        return this.famille;
    }

    public void setFamille(String string) {
        this.famille = string;
    }

    public String getGenre() {
        return this.genre;
    }

    public void setGenre(String string) {
        this.genre = string;
    }

    public String getEspece() {
        return this.espece;
    }

    public void setEspece(String string) {
        this.espece = string;
    }

    public String getSousEspece() {
        return this.sousEspece;
    }

    public void setSousEspece(String string) {
        this.sousEspece = string;
    }

    public String getVariete() {
        return this.variete;
    }

    public void setVariete(String string) {
        this.variete = string;
    }

    public TypeOrganisme getTypeOrganisme() {
        return this.typeOrganisme;
    }

    public void setTypeOrganisme(TypeOrganisme typeOrganisme) {
        this.typeOrganisme = typeOrganisme;
    }

    public Personne getIdentificateur() {
        return this.identificateur;
    }

    public void setIdentificateur(Personne personne) {
        this.identificateur = personne;
    }

    public Date getDateDepot() {
        return this.dateDepot;
    }

    public void setDateDepot(Date date) {
        this.dateDepot = date;
    }

    public String getNumDepot() {
        return this.numDepot;
    }

    public void setNumDepot(String string) {
        this.numDepot = string;
    }

    public String getLieuDepot() {
        return this.lieuDepot;
    }

    public void setLieuDepot(String string) {
        this.lieuDepot = string;
    }

    public Station getStation() {
        return this.station;
    }

    public void setStation(Station station) {
        this.station = station;
    }

    public String getComplement() {
        return this.complement;
    }

    public void setComplement(String string) {
        this.complement = string;
    }

    public Personne getCreateur() {
        return this.createur;
    }

    public void setCreateur(Personne personne) {
        this.createur = personne;
    }

    public static enum TypeOrganisme implements Comparable<TypeOrganisme>
    {
        PLANTE,
        ORGANISME_MARIN,
        MICROORGANISME,
        INSECTE,
        CHAMPIGNON,
        LICHEN,
        AUTRE;

    }
}

