/*
 * Decompiled with CFR 0.152.
 */
package nc.ird.cantharella.data.model;

import java.math.BigDecimal;
import java.util.Comparator;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.ManyToOne;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import nc.ird.cantharella.data.model.ErreurTestBio;
import nc.ird.cantharella.data.model.Extrait;
import nc.ird.cantharella.data.model.Fraction;
import nc.ird.cantharella.data.model.Lot;
import nc.ird.cantharella.data.model.Produit;
import nc.ird.cantharella.data.model.TestBio;
import nc.ird.cantharella.data.model.TypeExtrait;
import nc.ird.cantharella.data.model.utils.AbstractModel;
import nc.ird.cantharella.data.validation.CollectionUniqueField;
import nc.ird.module.utils.AssertTools;
import org.apache.commons.beanutils.BeanComparator;
import org.apache.commons.collections.comparators.ComparatorChain;
import org.hibernate.annotations.Index;
import org.hibernate.validator.constraints.Length;
import org.hibernate.validator.constraints.NotEmpty;

@Entity
@CollectionUniqueField(fieldName="repere", pathToCollection="testBio.resultats")
public class ResultatTestBio
extends AbstractModel
implements Cloneable,
Comparable<ResultatTestBio> {
    @Id
    @GeneratedValue
    private Integer id;
    @Length(max=10)
    @NotEmpty
    private String repere;
    @NotNull
    @Enumerated(value=EnumType.ORDINAL)
    @Index(name="typeResultat")
    private TypeResultat typeResultat;
    @ManyToOne(fetch=FetchType.EAGER, optional=true)
    private Produit produit;
    @Length(max=60)
    private String produitTemoin;
    @Min(value=0L)
    @Max(value=99999L)
    @Column(precision=9, scale=4)
    private BigDecimal concMasse;
    @Enumerated(value=EnumType.ORDINAL)
    private UniteConcMasse uniteConcMasse;
    @Enumerated(value=EnumType.ORDINAL)
    private Stade stade;
    @Max(value=99999L)
    @Column(precision=9, scale=4)
    private BigDecimal valeur;
    private Boolean estActif;
    @ManyToOne(fetch=FetchType.EAGER, optional=true)
    private ErreurTestBio erreur;
    @NotNull
    @ManyToOne(fetch=FetchType.EAGER, optional=false)
    private TestBio testBio;
    @ManyToOne(fetch=FetchType.EAGER, optional=true)
    private TypeExtrait typeExtraitSource;

    public Lot getLotSource() {
        if (this.produit == null) {
            return null;
        }
        if (this.produit.isExtrait()) {
            Extrait extrait = (Extrait)this.produit;
            return extrait.getExtraction().getLot();
        }
        Fraction fraction = (Fraction)this.produit;
        return fraction.getPurification().getLotSource();
    }

    public ResultatTestBio clone() throws CloneNotSupportedException {
        ResultatTestBio resultatTestBio = (ResultatTestBio)super.clone();
        resultatTestBio.id = this.id;
        resultatTestBio.repere = this.repere;
        resultatTestBio.typeResultat = this.typeResultat;
        resultatTestBio.produit = this.produit;
        resultatTestBio.stade = this.stade;
        resultatTestBio.estActif = this.estActif;
        resultatTestBio.testBio = this.testBio;
        return resultatTestBio;
    }

    public String toString() {
        return "(" + this.getRepere() + ", " + this.getTypeResultat() + ", " + (TypeResultat.PRODUIT.equals(this.getTypeResultat()) ? this.getProduit() : this.getProduitTemoin()) + ")";
    }

    @Override
    public final int compareTo(ResultatTestBio resultatTestBio) {
        ComparatorChain comparatorChain = new ComparatorChain();
        comparatorChain.addComparator((Comparator)new BeanComparator("testBio.methode.cible"));
        comparatorChain.addComparator((Comparator)new BeanComparator("produit"));
        comparatorChain.addComparator((Comparator)new BeanComparator("repere"));
        return comparatorChain.compare((Object)this, (Object)resultatTestBio);
    }

    public void setProduit(Produit produit) {
        this.typeExtraitSource = produit == null ? null : this.findExtraitSourceFromProduit(produit).getTypeExtrait();
        this.produit = produit;
    }

    public Integer getId() {
        return this.id;
    }

    public void setId(Integer n) {
        this.id = n;
    }

    public String getRepere() {
        return this.repere;
    }

    public void setRepere(String string) {
        this.repere = string;
    }

    public TypeResultat getTypeResultat() {
        return this.typeResultat;
    }

    public void setTypeResultat(TypeResultat typeResultat) {
        this.typeResultat = typeResultat;
    }

    public Produit getProduit() {
        return this.produit;
    }

    public String getProduitTemoin() {
        return this.produitTemoin;
    }

    public void setProduitTemoin(String string) {
        this.produitTemoin = string;
    }

    public BigDecimal getConcMasse() {
        return this.concMasse;
    }

    public void setConcMasse(BigDecimal bigDecimal) {
        this.concMasse = bigDecimal;
    }

    public UniteConcMasse getUniteConcMasse() {
        return this.uniteConcMasse;
    }

    public void setUniteConcMasse(UniteConcMasse uniteConcMasse) {
        this.uniteConcMasse = uniteConcMasse;
    }

    public Stade getStade() {
        return this.stade;
    }

    public void setStade(Stade stade) {
        this.stade = stade;
    }

    public BigDecimal getValeur() {
        return this.valeur;
    }

    public void setValeur(BigDecimal bigDecimal) {
        this.valeur = bigDecimal;
    }

    public Boolean isActif() {
        return this.estActif;
    }

    public void setActif(Boolean bl) {
        this.estActif = bl;
    }

    public ErreurTestBio getErreur() {
        return this.erreur;
    }

    public void setErreur(ErreurTestBio erreurTestBio) {
        this.erreur = erreurTestBio;
    }

    public TestBio getTestBio() {
        return this.testBio;
    }

    public void setTestBio(TestBio testBio) {
        this.testBio = testBio;
    }

    public TypeExtrait getTypeExtraitSource() {
        return this.typeExtraitSource;
    }

    public void setTypeExtraitSource(TypeExtrait typeExtrait) {
        this.typeExtraitSource = typeExtrait;
    }

    public Extrait findExtraitSourceFromProduit(Produit produit) {
        if (produit.isExtrait()) {
            Extrait extrait = (Extrait)produit;
            return extrait;
        }
        Produit produit2 = produit;
        while (produit2.isFraction()) {
            Fraction fraction = (Fraction)produit2;
            produit2 = fraction.getPurification().getProduit();
        }
        AssertTools.assertClassOrInterface((Object)produit2, Extrait.class);
        return (Extrait)produit2;
    }

    public static enum UniteConcMasse implements Comparable<UniteConcMasse>
    {
        MG,
        MICROG,
        NG,
        MG_ML,
        MICROG_ML,
        NG_ML;

    }

    public static enum Stade implements Comparable<Stade>
    {
        DETECTION,
        CONFIRMATION,
        FRACTIONNEMENT;

    }

    public static enum TypeResultat implements Comparable<TypeResultat>
    {
        BLANC,
        TEMOIN,
        PRODUIT;

    }
}

