/*
 * Decompiled with CFR 0.152.
 */
package nc.ird.cantharella.data.model;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Lob;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.validation.constraints.Future;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import nc.ird.cantharella.data.model.Extrait;
import nc.ird.cantharella.data.model.Fraction;
import nc.ird.cantharella.data.model.Lot;
import nc.ird.cantharella.data.model.MethodePurification;
import nc.ird.cantharella.data.model.ParamMethoPuriEffectif;
import nc.ird.cantharella.data.model.Personne;
import nc.ird.cantharella.data.model.Produit;
import nc.ird.cantharella.data.model.comparators.FractionsOfPurificationComp;
import nc.ird.cantharella.data.model.utils.AbstractModel;
import nc.ird.module.utils.AssertTools;
import org.apache.commons.beanutils.BeanComparator;
import org.apache.commons.collections.comparators.ComparatorChain;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.CascadeType;
import org.hibernate.validator.constraints.Length;
import org.hibernate.validator.constraints.NotEmpty;

@Entity
public class Purification
extends AbstractModel
implements Comparable<Purification> {
    @Id
    @GeneratedValue
    private Integer idPurification;
    @Length(max=60)
    @Column(unique=true)
    @NotEmpty
    private String ref;
    @NotNull
    @ManyToOne(fetch=FetchType.LAZY, optional=false)
    private Personne manipulateur;
    @NotNull
    @Temporal(value=TemporalType.DATE)
    private Date date;
    @NotNull
    @ManyToOne(fetch=FetchType.EAGER, optional=false)
    private MethodePurification methode;
    @NotNull
    @OneToMany(mappedBy="purification", fetch=FetchType.LAZY, orphanRemoval=true)
    @Cascade(value={CascadeType.SAVE_UPDATE})
    private List<ParamMethoPuriEffectif> paramsMetho;
    @NotNull
    @ManyToOne(fetch=FetchType.EAGER, optional=false)
    private Produit produit;
    @Min(value=0L)
    @Max(value=99999L)
    @Column(precision=9, scale=4)
    private BigDecimal masseDepart;
    @Lob
    private String complement;
    private boolean confidentiel;
    @Future
    @Temporal(value=TemporalType.DATE)
    private Date dateConfidentialite;
    @NotNull
    @ManyToOne(fetch=FetchType.LAZY, optional=false)
    private Personne createur;
    @NotNull
    @OneToMany(mappedBy="purification", fetch=FetchType.LAZY, orphanRemoval=true)
    @Cascade(value={CascadeType.REFRESH, CascadeType.SAVE_UPDATE})
    private List<Fraction> fractions = new ArrayList<Fraction>();
    @ManyToOne(fetch=FetchType.EAGER, optional=false)
    private Lot lotSource;

    public Purification() {
        this.paramsMetho = new ArrayList<ParamMethoPuriEffectif>();
    }

    public String toString() {
        return this.ref;
    }

    @Override
    public int compareTo(Purification purification) {
        ComparatorChain comparatorChain = new ComparatorChain();
        comparatorChain.addComparator((Comparator)new BeanComparator("produit"));
        comparatorChain.addComparator((Comparator)new BeanComparator("ref"));
        return comparatorChain.compare((Object)this, (Object)purification);
    }

    public void setProduit(Produit produit) {
        this.lotSource = this.findLotSourceFromProduit(produit);
        this.produit = produit;
    }

    public List<Fraction> getSortedFractions() {
        Collections.sort(this.fractions, new FractionsOfPurificationComp());
        return this.fractions;
    }

    public List<ParamMethoPuriEffectif> getSortedParamsMetho() {
        Collections.sort(this.paramsMetho, new BeanComparator("param.index"));
        return this.paramsMetho;
    }

    public Integer getIdPurification() {
        return this.idPurification;
    }

    public void setIdPurification(Integer n) {
        this.idPurification = n;
    }

    public String getRef() {
        return this.ref;
    }

    public void setRef(String string) {
        this.ref = string;
    }

    public Personne getManipulateur() {
        return this.manipulateur;
    }

    public void setManipulateur(Personne personne) {
        this.manipulateur = personne;
    }

    public Date getDate() {
        return this.date;
    }

    public void setDate(Date date) {
        this.date = date;
    }

    public MethodePurification getMethode() {
        return this.methode;
    }

    public void setMethode(MethodePurification methodePurification) {
        this.methode = methodePurification;
    }

    public List<ParamMethoPuriEffectif> getParamsMetho() {
        return this.paramsMetho;
    }

    public void setParamsMetho(List<ParamMethoPuriEffectif> list) {
        this.paramsMetho = list;
    }

    public BigDecimal getMasseDepart() {
        return this.masseDepart;
    }

    public void setMasseDepart(BigDecimal bigDecimal) {
        this.masseDepart = bigDecimal;
    }

    public String getComplement() {
        return this.complement;
    }

    public void setComplement(String string) {
        this.complement = string;
    }

    public boolean isConfidentiel() {
        return this.confidentiel;
    }

    public void setConfidentiel(boolean bl) {
        this.confidentiel = bl;
    }

    public Date getDateConfidentialite() {
        return this.dateConfidentialite;
    }

    public void setDateConfidentialite(Date date) {
        this.dateConfidentialite = date;
    }

    public Personne getCreateur() {
        return this.createur;
    }

    public void setCreateur(Personne personne) {
        this.createur = personne;
    }

    public Lot getLotSource() {
        return this.lotSource;
    }

    public List<Fraction> getFractions() {
        return this.fractions;
    }

    public void setFractions(List<Fraction> list) {
        this.fractions = list;
    }

    public void setLotSource(Lot lot) {
        this.lotSource = lot;
    }

    public Produit getProduit() {
        return this.produit;
    }

    public Lot findLotSourceFromProduit(Produit produit) {
        Produit produit2;
        Produit produit3 = produit;
        while (produit3.isFraction()) {
            produit2 = (Fraction)produit3;
            produit3 = ((Fraction)produit2).getPurification().getProduit();
        }
        AssertTools.assertClassOrInterface((Object)produit3, Extrait.class);
        produit2 = (Extrait)produit3;
        return ((Extrait)produit2).getExtraction().getLot();
    }
}

