/*
 * Decompiled with CFR 0.152.
 */
package nc.ird.cantharella.data.model;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.OneToMany;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import nc.ird.cantharella.data.model.Purification;
import nc.ird.cantharella.data.model.ResultatTestBio;
import nc.ird.cantharella.data.model.utils.AbstractModel;
import org.apache.commons.beanutils.BeanComparator;
import org.hibernate.validator.constraints.Length;
import org.hibernate.validator.constraints.NotEmpty;

@Entity
@Inheritance(strategy=InheritanceType.JOINED)
public abstract class Produit
extends AbstractModel
implements Cloneable,
Comparable<Produit> {
    @Id
    @GeneratedValue
    private Integer id;
    @Length(max=60)
    @NotEmpty
    @Column(unique=true)
    private String ref;
    @Min(value=0L)
    @Max(value=99999L)
    @Column(precision=9, scale=4)
    private BigDecimal masseObtenue;
    @NotNull
    @OneToMany(mappedBy="produit", fetch=FetchType.LAZY)
    private List<Purification> purificationsSuivantes = new ArrayList<Purification>();
    @NotNull
    @OneToMany(mappedBy="produit", fetch=FetchType.LAZY)
    private List<ResultatTestBio> resultatsTestsBioSuivants = new ArrayList<ResultatTestBio>();

    public abstract boolean isExtrait();

    public abstract boolean isFraction();

    public Produit clone() throws CloneNotSupportedException {
        Produit produit = (Produit)super.clone();
        produit.id = this.id;
        produit.ref = this.ref;
        return produit;
    }

    public String toString() {
        return this.ref;
    }

    @Override
    public int compareTo(Produit produit) {
        return new BeanComparator("ref").compare((Object)this, (Object)produit);
    }

    public Integer getId() {
        return this.id;
    }

    public void setId(Integer n) {
        this.id = n;
    }

    public String getRef() {
        return this.ref;
    }

    public void setRef(String string) {
        this.ref = string;
    }

    public BigDecimal getMasseObtenue() {
        return this.masseObtenue;
    }

    public void setMasseObtenue(BigDecimal bigDecimal) {
        this.masseObtenue = bigDecimal;
    }

    public List<Purification> getPurificationsSuivantes() {
        return this.purificationsSuivantes;
    }

    public void setPurificationsSuivantes(List<Purification> list) {
        this.purificationsSuivantes = list;
    }

    public List<ResultatTestBio> getResultatsTestsBioSuivants() {
        return this.resultatsTestsBioSuivants;
    }

    public void setResultatsTestsBioSuivants(List<ResultatTestBio> list) {
        this.resultatsTestsBioSuivants = list;
    }
}

