/*
 * Decompiled with CFR 0.152.
 */
package nc.ird.cantharella.data.model;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.Lob;
import javax.persistence.MapKey;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.UniqueConstraint;
import javax.validation.constraints.NotNull;
import nc.ird.cantharella.data.model.Campagne;
import nc.ird.cantharella.data.model.CampagnePersonneDroits;
import nc.ird.cantharella.data.model.CampagnePersonneParticipant;
import nc.ird.cantharella.data.model.Extraction;
import nc.ird.cantharella.data.model.Lot;
import nc.ird.cantharella.data.model.LotPersonneDroits;
import nc.ird.cantharella.data.model.Purification;
import nc.ird.cantharella.data.model.Specimen;
import nc.ird.cantharella.data.model.Station;
import nc.ird.cantharella.data.model.TestBio;
import nc.ird.cantharella.data.model.utils.AbstractModel;
import nc.ird.cantharella.data.validation.CountryCode;
import org.apache.commons.beanutils.BeanComparator;
import org.apache.commons.collections.comparators.ComparatorChain;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.CascadeType;
import org.hibernate.annotations.Index;
import org.hibernate.validator.constraints.Email;
import org.hibernate.validator.constraints.Length;
import org.hibernate.validator.constraints.NotEmpty;

@Entity
@Table(uniqueConstraints={@UniqueConstraint(columnNames={"nom", "prenom"})})
@Inheritance(strategy=InheritanceType.JOINED)
public class Personne
extends AbstractModel
implements Comparable<Personne> {
    @Id
    @GeneratedValue
    private Integer idPersonne;
    @NotEmpty
    @Lob
    private String adressePostale;
    @OneToMany(mappedBy="createur", fetch=FetchType.LAZY)
    @NotNull
    private List<Campagne> campagnesCreees = new ArrayList<Campagne>();
    @NotNull
    @OneToMany(mappedBy="id.pk2", fetch=FetchType.LAZY, orphanRemoval=true)
    @MapKey(name="id.pk1")
    @Cascade(value={CascadeType.SAVE_UPDATE})
    private Map<Campagne, CampagnePersonneDroits> campagnesDroits;
    @OneToMany(mappedBy="id.pk2", fetch=FetchType.LAZY)
    @NotNull
    private List<CampagnePersonneParticipant> campagnesParticipees = new ArrayList<CampagnePersonneParticipant>();
    @NotEmpty
    @Length(min=2, max=2)
    @CountryCode
    private String codePays;
    @Length(max=10)
    @NotEmpty
    private String codePostal;
    @Column(unique=true)
    @Length(max=60)
    @Email
    @NotEmpty
    @Index(name="courriel")
    private String courriel;
    @Length(max=60)
    private String fax;
    @Length(max=60)
    private String fonction;
    @OneToMany(mappedBy="createur", fetch=FetchType.LAZY)
    @NotNull
    private List<Lot> lotsCrees;
    @NotNull
    @OneToMany(mappedBy="id.pk2", fetch=FetchType.LAZY, orphanRemoval=true)
    @MapKey(name="id.pk1")
    @Cascade(value={CascadeType.SAVE_UPDATE})
    private Map<Lot, LotPersonneDroits> lotsDroits;
    @Length(max=60)
    @NotEmpty
    private String nom;
    @Length(max=60)
    @NotEmpty
    private String organisme;
    @Length(max=60)
    @NotEmpty
    private String prenom;
    @Length(max=60)
    private String tel;
    @Length(max=60)
    @NotEmpty
    private String ville;
    @OneToMany(mappedBy="createur", fetch=FetchType.LAZY)
    @NotNull
    private List<Station> stationsCrees;
    @OneToMany(mappedBy="createur", fetch=FetchType.LAZY)
    @NotNull
    private List<Specimen> specimensCrees;
    @OneToMany(mappedBy="createur", fetch=FetchType.LAZY)
    @NotNull
    private List<Extraction> extractionsCrees;
    @OneToMany(mappedBy="createur", fetch=FetchType.LAZY)
    @NotNull
    private List<Purification> purificationsCrees;
    @OneToMany(mappedBy="createur", fetch=FetchType.LAZY)
    @NotNull
    private List<TestBio> testsBioCrees;

    public Personne() {
        this.campagnesDroits = new HashMap<Campagne, CampagnePersonneDroits>();
        this.lotsCrees = new ArrayList<Lot>();
        this.lotsDroits = new HashMap<Lot, LotPersonneDroits>();
        this.stationsCrees = new ArrayList<Station>();
        this.specimensCrees = new ArrayList<Specimen>();
        this.extractionsCrees = new ArrayList<Extraction>();
        this.purificationsCrees = new ArrayList<Purification>();
        this.testsBioCrees = new ArrayList<TestBio>();
    }

    public String toString() {
        return this.prenom + " " + this.nom;
    }

    @Override
    public int compareTo(Personne personne) {
        ComparatorChain comparatorChain = new ComparatorChain();
        comparatorChain.addComparator((Comparator)new BeanComparator("nom"));
        comparatorChain.addComparator((Comparator)new BeanComparator("prenom"));
        return comparatorChain.compare((Object)this, (Object)personne);
    }

    public Integer getIdPersonne() {
        return this.idPersonne;
    }

    public void setIdPersonne(Integer n) {
        this.idPersonne = n;
    }

    public String getAdressePostale() {
        return this.adressePostale;
    }

    public void setAdressePostale(String string) {
        this.adressePostale = string;
    }

    public List<Campagne> getCampagnesCreees() {
        return this.campagnesCreees;
    }

    public void setCampagnesCreees(List<Campagne> list) {
        this.campagnesCreees = list;
    }

    public Map<Campagne, CampagnePersonneDroits> getCampagnesDroits() {
        return this.campagnesDroits;
    }

    public void setCampagnesDroits(Map<Campagne, CampagnePersonneDroits> map) {
        this.campagnesDroits = map;
    }

    public List<CampagnePersonneParticipant> getCampagnesParticipees() {
        return this.campagnesParticipees;
    }

    public void setCampagnesParticipees(List<CampagnePersonneParticipant> list) {
        this.campagnesParticipees = list;
    }

    public String getCodePays() {
        return this.codePays;
    }

    public void setCodePays(String string) {
        this.codePays = string;
    }

    public String getCodePostal() {
        return this.codePostal;
    }

    public void setCodePostal(String string) {
        this.codePostal = string;
    }

    public String getCourriel() {
        return this.courriel;
    }

    public void setCourriel(String string) {
        this.courriel = string;
    }

    public String getFax() {
        return this.fax;
    }

    public void setFax(String string) {
        this.fax = string;
    }

    public String getFonction() {
        return this.fonction;
    }

    public void setFonction(String string) {
        this.fonction = string;
    }

    public List<Lot> getLotsCrees() {
        return this.lotsCrees;
    }

    public void setLotsCrees(List<Lot> list) {
        this.lotsCrees = list;
    }

    public Map<Lot, LotPersonneDroits> getLotsDroits() {
        return this.lotsDroits;
    }

    public void setLotsDroits(Map<Lot, LotPersonneDroits> map) {
        this.lotsDroits = map;
    }

    public String getNom() {
        return this.nom;
    }

    public void setNom(String string) {
        this.nom = string;
    }

    public String getOrganisme() {
        return this.organisme;
    }

    public void setOrganisme(String string) {
        this.organisme = string;
    }

    public String getPrenom() {
        return this.prenom;
    }

    public void setPrenom(String string) {
        this.prenom = string;
    }

    public String getTel() {
        return this.tel;
    }

    public void setTel(String string) {
        this.tel = string;
    }

    public String getVille() {
        return this.ville;
    }

    public void setVille(String string) {
        this.ville = string;
    }

    public List<Station> getStationsCrees() {
        return this.stationsCrees;
    }

    public void setStationsCrees(List<Station> list) {
        this.stationsCrees = list;
    }

    public List<Specimen> getSpecimensCrees() {
        return this.specimensCrees;
    }

    public void setSpecimensCrees(List<Specimen> list) {
        this.specimensCrees = list;
    }

    public List<Extraction> getExtractionsCrees() {
        return this.extractionsCrees;
    }

    public void setExtractionsCrees(List<Extraction> list) {
        this.extractionsCrees = list;
    }

    public List<Purification> getPurificationsCrees() {
        return this.purificationsCrees;
    }

    public void setPurificationsCrees(List<Purification> list) {
        this.purificationsCrees = list;
    }

    public List<TestBio> getTestsBioCrees() {
        return this.testsBioCrees;
    }

    public void setTestsBioCrees(List<TestBio> list) {
        this.testsBioCrees = list;
    }
}

