/*
 * Decompiled with CFR 0.152.
 */
package nc.ird.cantharella.data.model;

import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Lob;
import javax.persistence.ManyToOne;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import nc.ird.cantharella.data.model.MethodePurification;
import nc.ird.cantharella.data.model.utils.AbstractModel;
import nc.ird.cantharella.data.validation.CollectionUniqueField;
import org.apache.commons.beanutils.BeanComparator;
import org.hibernate.validator.constraints.Length;
import org.hibernate.validator.constraints.NotEmpty;

@Entity
@CollectionUniqueField(fieldName="nom", pathToCollection="methodePurification.parametres")
public class ParamMethoPuri
extends AbstractModel
implements Cloneable,
Comparable<ParamMethoPuri> {
    @Id
    @GeneratedValue
    private Integer idParamMethoPuri;
    @NotNull
    @Min(value=0L)
    private Integer index;
    @Length(max=60)
    @NotEmpty
    private String nom;
    @NotEmpty
    @Lob
    private String description;
    @NotNull
    @ManyToOne(fetch=FetchType.LAZY, optional=false)
    private MethodePurification methodePurification;

    public ParamMethoPuri clone() throws CloneNotSupportedException {
        ParamMethoPuri paramMethoPuri = (ParamMethoPuri)super.clone();
        paramMethoPuri.idParamMethoPuri = this.idParamMethoPuri;
        paramMethoPuri.nom = this.nom;
        paramMethoPuri.description = this.description;
        return paramMethoPuri;
    }

    public String toString() {
        return this.nom;
    }

    @Override
    public int compareTo(ParamMethoPuri paramMethoPuri) {
        return new BeanComparator("index").compare((Object)this, (Object)paramMethoPuri);
    }

    public Integer getIdParamMethoPuri() {
        return this.idParamMethoPuri;
    }

    public void setIdParamMethoPuri(Integer n) {
        this.idParamMethoPuri = n;
    }

    public Integer getIndex() {
        return this.index;
    }

    public void setIndex(Integer n) {
        this.index = n;
    }

    public String getNom() {
        return this.nom;
    }

    public void setNom(String string) {
        this.nom = string;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String string) {
        this.description = string;
    }

    public MethodePurification getMethodePurification() {
        return this.methodePurification;
    }

    public void setMethodePurification(MethodePurification methodePurification) {
        this.methodePurification = methodePurification;
    }
}

