/*
 * Decompiled with CFR 0.152.
 */
package nc.ird.cantharella.data.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Lob;
import javax.persistence.OneToMany;
import javax.persistence.OrderBy;
import nc.ird.cantharella.data.model.ParamMethoPuri;
import nc.ird.cantharella.data.model.utils.AbstractModel;
import org.apache.commons.beanutils.BeanComparator;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.CascadeType;
import org.hibernate.validator.constraints.Length;
import org.hibernate.validator.constraints.NotEmpty;

@Entity
public class MethodePurification
extends AbstractModel
implements Comparable<MethodePurification> {
    @Id
    @GeneratedValue
    private Integer idMethodePurification;
    @Length(max=60)
    @Column(unique=true)
    @NotEmpty
    private String nom;
    @NotEmpty
    @Lob
    private String description;
    @OneToMany(mappedBy="methodePurification", fetch=FetchType.LAZY, orphanRemoval=true)
    @Cascade(value={CascadeType.SAVE_UPDATE})
    @OrderBy(value="index")
    private List<ParamMethoPuri> parametres = new ArrayList<ParamMethoPuri>();

    public String toString() {
        return this.nom;
    }

    @Override
    public int compareTo(MethodePurification methodePurification) {
        return new BeanComparator("nom").compare((Object)this, (Object)methodePurification);
    }

    public List<ParamMethoPuri> getSortedParametres() {
        Collections.sort(this.parametres);
        return this.parametres;
    }

    public Integer getIdMethodePurification() {
        return this.idMethodePurification;
    }

    public void setIdMethodePurification(Integer n) {
        this.idMethodePurification = n;
    }

    public String getNom() {
        return this.nom;
    }

    public void setNom(String string) {
        this.nom = string;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String string) {
        this.description = string;
    }

    public List<ParamMethoPuri> getParametres() {
        return this.parametres;
    }

    public void setParametres(List<ParamMethoPuri> list) {
        this.parametres = list;
    }
}

