/*
 * Decompiled with CFR 0.152.
 */
package nc.ird.cantharella.data.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Lob;
import javax.persistence.OneToMany;
import nc.ird.cantharella.data.model.TypeExtrait;
import nc.ird.cantharella.data.model.utils.AbstractModel;
import org.apache.commons.beanutils.BeanComparator;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.CascadeType;
import org.hibernate.validator.constraints.Length;
import org.hibernate.validator.constraints.NotEmpty;

@Entity
public class MethodeExtraction
extends AbstractModel
implements Comparable<MethodeExtraction> {
    @Id
    @GeneratedValue
    private Integer idMethodeExtraction;
    @Length(max=60)
    @Column(unique=true)
    @NotEmpty
    private String nom;
    @NotEmpty
    @Lob
    private String description;
    @OneToMany(mappedBy="methodeExtraction", fetch=FetchType.LAZY, orphanRemoval=true)
    @Cascade(value={CascadeType.SAVE_UPDATE})
    private List<TypeExtrait> typesEnSortie = new ArrayList<TypeExtrait>();

    public String toString() {
        return this.nom;
    }

    @Override
    public int compareTo(MethodeExtraction methodeExtraction) {
        return new BeanComparator("nom").compare((Object)this, (Object)methodeExtraction);
    }

    public List<TypeExtrait> getSortedTypesEnSortie() {
        Collections.sort(this.typesEnSortie);
        return this.typesEnSortie;
    }

    public Integer getIdMethodeExtraction() {
        return this.idMethodeExtraction;
    }

    public void setIdMethodeExtraction(Integer n) {
        this.idMethodeExtraction = n;
    }

    public String getNom() {
        return this.nom;
    }

    public void setNom(String string) {
        this.nom = string;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String string) {
        this.description = string;
    }

    public List<TypeExtrait> getTypesEnSortie() {
        return this.typesEnSortie;
    }

    public void setTypesEnSortie(List<TypeExtrait> list) {
        this.typesEnSortie = list;
    }
}

