/*
 * Decompiled with CFR 0.152.
 */
package nc.ird.cantharella.data.model;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Lob;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Past;
import nc.ird.cantharella.data.model.Campagne;
import nc.ird.cantharella.data.model.Extraction;
import nc.ird.cantharella.data.model.LotGroupeDroits;
import nc.ird.cantharella.data.model.LotPersonneDroits;
import nc.ird.cantharella.data.model.Partie;
import nc.ird.cantharella.data.model.Personne;
import nc.ird.cantharella.data.model.Specimen;
import nc.ird.cantharella.data.model.Station;
import nc.ird.cantharella.data.model.utils.AbstractModel;
import org.apache.commons.beanutils.BeanComparator;
import org.hibernate.validator.constraints.Length;
import org.hibernate.validator.constraints.NotEmpty;

@Entity
@Table
public class Lot
extends AbstractModel
implements Comparable<Lot> {
    @Id
    @GeneratedValue
    private Integer idLot;
    @Column(unique=true)
    @NotEmpty
    @Length(max=60)
    private String ref;
    @NotNull
    @ManyToOne(fetch=FetchType.EAGER, optional=false)
    private Campagne campagne;
    @Lob
    private String complement;
    @NotNull
    @ManyToOne(fetch=FetchType.LAZY, optional=false)
    private Personne createur;
    @Past
    @Temporal(value=TemporalType.DATE)
    @NotNull
    private Date dateRecolte;
    @NotNull
    private Boolean echantillonColl;
    @NotNull
    private Boolean echantillonIdent;
    @NotNull
    private Boolean echantillonPhylo;
    @OneToMany(mappedBy="id.pk1", fetch=FetchType.LAZY)
    @NotNull
    private List<LotGroupeDroits> groupesDroits;
    @Min(value=0L)
    @Max(value=99999L)
    @Column(precision=9, scale=4)
    private BigDecimal masseFraiche;
    @Min(value=0L)
    @Max(value=99999L)
    @Column(precision=9, scale=4)
    private BigDecimal masseSeche;
    @ManyToOne(fetch=FetchType.EAGER, optional=true)
    private Partie partie;
    @OneToMany(mappedBy="id.pk1", fetch=FetchType.LAZY)
    @NotNull
    private List<LotPersonneDroits> personnesDroits = new ArrayList<LotPersonneDroits>();
    @NotNull
    @ManyToOne(fetch=FetchType.EAGER, optional=false)
    private Specimen specimenRef;
    @NotNull
    @ManyToOne(fetch=FetchType.EAGER, optional=false)
    private Station station;
    @OneToMany(mappedBy="lot", fetch=FetchType.LAZY)
    @NotNull
    private List<Extraction> extractions;

    public Lot() {
        this.groupesDroits = new ArrayList<LotGroupeDroits>();
        this.extractions = new ArrayList<Extraction>();
    }

    public String toString() {
        return this.ref;
    }

    @Override
    public int compareTo(Lot lot) {
        return new BeanComparator("ref").compare((Object)this, (Object)lot);
    }

    public Campagne getCampagne() {
        return this.campagne;
    }

    public void setCampagne(Campagne campagne) {
        this.campagne = campagne;
    }

    public String getComplement() {
        return this.complement;
    }

    public void setComplement(String string) {
        this.complement = string;
    }

    public Personne getCreateur() {
        return this.createur;
    }

    public void setCreateur(Personne personne) {
        this.createur = personne;
    }

    public Date getDateRecolte() {
        return this.dateRecolte;
    }

    public void setDateRecolte(Date date) {
        this.dateRecolte = date;
    }

    public Boolean getEchantillonColl() {
        return this.echantillonColl;
    }

    public void setEchantillonColl(Boolean bl) {
        this.echantillonColl = bl;
    }

    public Boolean getEchantillonIdent() {
        return this.echantillonIdent;
    }

    public void setEchantillonIdent(Boolean bl) {
        this.echantillonIdent = bl;
    }

    public Boolean getEchantillonPhylo() {
        return this.echantillonPhylo;
    }

    public void setEchantillonPhylo(Boolean bl) {
        this.echantillonPhylo = bl;
    }

    public List<LotGroupeDroits> getGroupesDroits() {
        return this.groupesDroits;
    }

    public void setGroupesDroits(List<LotGroupeDroits> list) {
        this.groupesDroits = list;
    }

    public Integer getIdLot() {
        return this.idLot;
    }

    public void setIdLot(Integer n) {
        this.idLot = n;
    }

    public BigDecimal getMasseFraiche() {
        return this.masseFraiche;
    }

    public void setMasseFraiche(BigDecimal bigDecimal) {
        this.masseFraiche = bigDecimal;
    }

    public BigDecimal getMasseSeche() {
        return this.masseSeche;
    }

    public void setMasseSeche(BigDecimal bigDecimal) {
        this.masseSeche = bigDecimal;
    }

    public Partie getPartie() {
        return this.partie;
    }

    public void setPartie(Partie partie) {
        this.partie = partie;
    }

    public List<LotPersonneDroits> getPersonnesDroits() {
        return this.personnesDroits;
    }

    public void setPersonnesDroits(List<LotPersonneDroits> list) {
        this.personnesDroits = list;
    }

    public String getRef() {
        return this.ref;
    }

    public void setRef(String string) {
        this.ref = string;
    }

    public Specimen getSpecimenRef() {
        return this.specimenRef;
    }

    public void setSpecimenRef(Specimen specimen) {
        this.specimenRef = specimen;
    }

    public Station getStation() {
        return this.station;
    }

    public void setStation(Station station) {
        this.station = station;
    }

    public List<Extraction> getExtractions() {
        return this.extractions;
    }

    public void setExtractions(List<Extraction> list) {
        this.extractions = list;
    }
}

