/*
 * Decompiled with CFR 0.152.
 */
package nc.ird.cantharella.data.model;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Lob;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import nc.ird.cantharella.data.model.Extrait;
import nc.ird.cantharella.data.model.Lot;
import nc.ird.cantharella.data.model.MethodeExtraction;
import nc.ird.cantharella.data.model.Personne;
import nc.ird.cantharella.data.model.comparators.ExtraitsOfExtractionComp;
import nc.ird.cantharella.data.model.utils.AbstractModel;
import org.apache.commons.beanutils.BeanComparator;
import org.apache.commons.collections.comparators.ComparatorChain;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.CascadeType;
import org.hibernate.validator.constraints.Length;
import org.hibernate.validator.constraints.NotEmpty;

@Entity
public class Extraction
extends AbstractModel
implements Comparable<Extraction> {
    @Id
    @GeneratedValue
    private Integer idExtraction;
    @Length(max=60)
    @Column(unique=true)
    @NotEmpty
    private String ref;
    @NotNull
    @ManyToOne(fetch=FetchType.LAZY, optional=false)
    private Personne manipulateur;
    @NotNull
    @ManyToOne(fetch=FetchType.EAGER, optional=false)
    private MethodeExtraction methode;
    @NotNull
    @Temporal(value=TemporalType.DATE)
    private Date date;
    @NotNull
    @ManyToOne(fetch=FetchType.EAGER, optional=false)
    private Lot lot;
    @Min(value=0L)
    @Max(value=99999L)
    @Column(precision=9, scale=4)
    private BigDecimal masseDepart;
    @Lob
    private String complement;
    @NotNull
    @ManyToOne(fetch=FetchType.LAZY, optional=false)
    private Personne createur;
    @NotNull
    @OneToMany(mappedBy="extraction", fetch=FetchType.EAGER, orphanRemoval=true)
    @Cascade(value={CascadeType.SAVE_UPDATE})
    private List<Extrait> extraits = new ArrayList<Extrait>();

    public String toString() {
        return this.ref;
    }

    @Override
    public int compareTo(Extraction extraction) {
        ComparatorChain comparatorChain = new ComparatorChain();
        comparatorChain.addComparator((Comparator)new BeanComparator("lot"));
        comparatorChain.addComparator((Comparator)new BeanComparator("ref"));
        return comparatorChain.compare((Object)this, (Object)extraction);
    }

    public List<Extrait> getSortedExtraits() {
        Collections.sort(this.extraits, new ExtraitsOfExtractionComp());
        return this.extraits;
    }

    public Integer getIdExtraction() {
        return this.idExtraction;
    }

    public void setIdExtraction(Integer n) {
        this.idExtraction = n;
    }

    public String getRef() {
        return this.ref;
    }

    public void setRef(String string) {
        this.ref = string;
    }

    public Personne getManipulateur() {
        return this.manipulateur;
    }

    public void setManipulateur(Personne personne) {
        this.manipulateur = personne;
    }

    public MethodeExtraction getMethode() {
        return this.methode;
    }

    public void setMethode(MethodeExtraction methodeExtraction) {
        this.methode = methodeExtraction;
    }

    public Date getDate() {
        return this.date;
    }

    public void setDate(Date date) {
        this.date = date;
    }

    public Lot getLot() {
        return this.lot;
    }

    public void setLot(Lot lot) {
        this.lot = lot;
    }

    public BigDecimal getMasseDepart() {
        return this.masseDepart;
    }

    public void setMasseDepart(BigDecimal bigDecimal) {
        this.masseDepart = bigDecimal;
    }

    public String getComplement() {
        return this.complement;
    }

    public void setComplement(String string) {
        this.complement = string;
    }

    public Personne getCreateur() {
        return this.createur;
    }

    public void setCreateur(Personne personne) {
        this.createur = personne;
    }

    public List<Extrait> getExtraits() {
        return this.extraits;
    }

    public void setExtraits(List<Extrait> list) {
        this.extraits = list;
    }
}

