/*
 * Decompiled with CFR 0.152.
 */
package nc.ird.cantharella.data.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Lob;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.validation.constraints.NotNull;
import nc.ird.cantharella.data.model.CampagneGroupeDroits;
import nc.ird.cantharella.data.model.CampagnePersonneDroits;
import nc.ird.cantharella.data.model.CampagnePersonneParticipant;
import nc.ird.cantharella.data.model.Lot;
import nc.ird.cantharella.data.model.Personne;
import nc.ird.cantharella.data.model.Station;
import nc.ird.cantharella.data.model.utils.AbstractModel;
import nc.ird.cantharella.data.validation.CountryCode;
import org.apache.commons.beanutils.BeanComparator;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.CascadeType;
import org.hibernate.validator.constraints.Length;
import org.hibernate.validator.constraints.NotEmpty;

@Entity
@Table
public class Campagne
extends AbstractModel
implements Comparable<Campagne> {
    @Id
    @GeneratedValue
    private Integer idCampagne;
    @Column(unique=true)
    @NotNull
    @NotEmpty
    @Length(max=60)
    private String nom;
    @NotNull
    @CountryCode
    @Length(min=2, max=2)
    private String codePays;
    @Length(max=60)
    private String programme;
    @Lob
    private String mentionLegale;
    @Lob
    private String complement;
    @NotNull
    @Temporal(value=TemporalType.DATE)
    private Date dateDeb;
    @NotNull
    @Temporal(value=TemporalType.DATE)
    private Date dateFin;
    @NotNull
    @OneToMany(mappedBy="id.pk1", fetch=FetchType.LAZY)
    private List<CampagneGroupeDroits> groupesDroits;
    @NotNull
    @OneToMany(mappedBy="campagne", fetch=FetchType.LAZY)
    private List<Lot> lots = new ArrayList<Lot>();
    @NotNull
    @ManyToOne(fetch=FetchType.LAZY, optional=false)
    private Personne createur;
    @NotNull
    @OneToMany(mappedBy="id.pk1", fetch=FetchType.LAZY, orphanRemoval=true)
    @Cascade(value={CascadeType.SAVE_UPDATE})
    private List<CampagnePersonneParticipant> participants = new ArrayList<CampagnePersonneParticipant>();
    @NotNull
    @OneToMany(mappedBy="id.pk1", fetch=FetchType.LAZY)
    private List<CampagnePersonneDroits> personnesDroits;
    @NotNull
    @ManyToMany(fetch=FetchType.LAZY)
    @Cascade(value={CascadeType.SAVE_UPDATE})
    private List<Station> stations = new ArrayList<Station>();

    public Campagne() {
        this.personnesDroits = new ArrayList<CampagnePersonneDroits>();
        this.groupesDroits = new ArrayList<CampagneGroupeDroits>();
    }

    public String toString() {
        return this.nom;
    }

    @Override
    public int compareTo(Campagne campagne) {
        return new BeanComparator("nom").compare((Object)this, (Object)campagne);
    }

    public List<Station> getSortedStations() {
        Collections.sort(this.stations);
        return this.stations;
    }

    public Integer getIdCampagne() {
        return this.idCampagne;
    }

    public void setIdCampagne(Integer n) {
        this.idCampagne = n;
    }

    public String getNom() {
        return this.nom;
    }

    public void setNom(String string) {
        this.nom = string;
    }

    public String getCodePays() {
        return this.codePays;
    }

    public void setCodePays(String string) {
        this.codePays = string;
    }

    public String getProgramme() {
        return this.programme;
    }

    public void setProgramme(String string) {
        this.programme = string;
    }

    public String getMentionLegale() {
        return this.mentionLegale;
    }

    public void setMentionLegale(String string) {
        this.mentionLegale = string;
    }

    public String getComplement() {
        return this.complement;
    }

    public void setComplement(String string) {
        this.complement = string;
    }

    public Date getDateDeb() {
        return this.dateDeb;
    }

    public void setDateDeb(Date date) {
        this.dateDeb = date;
    }

    public Date getDateFin() {
        return this.dateFin;
    }

    public void setDateFin(Date date) {
        this.dateFin = date;
    }

    public List<CampagneGroupeDroits> getGroupesDroits() {
        return this.groupesDroits;
    }

    public void setGroupesDroits(List<CampagneGroupeDroits> list) {
        this.groupesDroits = list;
    }

    public List<Lot> getLots() {
        return this.lots;
    }

    public void setLots(List<Lot> list) {
        this.lots = list;
    }

    public Personne getCreateur() {
        return this.createur;
    }

    public void setCreateur(Personne personne) {
        this.createur = personne;
    }

    public List<CampagnePersonneParticipant> getParticipants() {
        return this.participants;
    }

    public void setParticipants(List<CampagnePersonneParticipant> list) {
        this.participants = list;
    }

    public List<CampagnePersonneDroits> getPersonnesDroits() {
        return this.personnesDroits;
    }

    public void setPersonnesDroits(List<CampagnePersonneDroits> list) {
        this.personnesDroits = list;
    }

    public List<Station> getStations() {
        return this.stations;
    }

    public void setStations(List<Station> list) {
        this.stations = list;
    }
}

