/*
 * Decompiled with CFR 0.152.
 */
package nc.ird.cantharella.data.dao.impl;

import java.io.Serializable;
import java.util.List;
import nc.ird.cantharella.data.dao.GenericDao;
import nc.ird.cantharella.data.model.utils.AbstractModel;
import nc.ird.module.utils.AssertTools;
import nc.ird.module.utils.GenericsTools;
import org.hibernate.SQLQuery;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.DetachedCriteria;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.orm.ObjectRetrievalFailureException;
import org.springframework.orm.hibernate3.HibernateCallback;
import org.springframework.orm.hibernate3.support.HibernateDaoSupport;
import org.springframework.stereotype.Repository;

@Repository
public class HibernateTemplateDao
extends HibernateDaoSupport
implements GenericDao {
    public HibernateTemplateDao() {
    }

    private static DetachedCriteria criteriaByProperty(Class<? extends AbstractModel> clazz, String string, Serializable serializable) {
        return DetachedCriteria.forClass(clazz).add((Criterion)Restrictions.eq((String)string, (Object)serializable));
    }

    @Autowired
    public HibernateTemplateDao(SessionFactory sessionFactory) {
        this.setSessionFactory(sessionFactory);
        this.getHibernateTemplate().setAllowCreate(false);
        this.getHibernateTemplate().setCacheQueries(true);
        this.getHibernateTemplate().afterPropertiesSet();
    }

    @Override
    public long count(DetachedCriteria detachedCriteria) {
        AssertTools.assertNotNull((Object)detachedCriteria);
        return (Long)this.list(detachedCriteria.setProjection(Projections.rowCount())).get(0);
    }

    @Override
    public <M extends AbstractModel> long count(Class<M> clazz) {
        AssertTools.assertNotNull(clazz);
        return (Long)this.list(DetachedCriteria.forClass(clazz).setProjection(Projections.rowCount())).get(0);
    }

    @Override
    public long count(String string, Object ... objectArray) {
        AssertTools.assertNotEmpty((String)string);
        return (Long)this.getHibernateTemplate().iterate(string, objectArray).next();
    }

    @Override
    public <M extends AbstractModel> void create(M m) {
        AssertTools.assertNotNull(m);
        this.getHibernateTemplate().save(m);
    }

    @Override
    public <M extends AbstractModel> void createOrUpdate(M m) {
        AssertTools.assertNotNull(m);
        this.getHibernateTemplate().saveOrUpdate(m);
    }

    @Override
    public <M extends AbstractModel> void delete(Class<M> clazz, Serializable serializable) {
        AssertTools.assertNotNull(clazz);
        AssertTools.assertNotNull((Object)serializable);
        this.getHibernateTemplate().delete(this.read(clazz, serializable));
    }

    @Override
    public <M extends AbstractModel> void delete(M m) {
        AssertTools.assertNotNull(m);
        this.getHibernateTemplate().delete(m);
    }

    @Override
    public List<?> list(DetachedCriteria detachedCriteria) {
        AssertTools.assertNotNull((Object)detachedCriteria);
        return this.getHibernateTemplate().findByCriteria(detachedCriteria);
    }

    @Override
    public List<?> list(String string, Object ... objectArray) {
        AssertTools.assertNotEmpty((String)string);
        return this.getHibernateTemplate().find(string, objectArray);
    }

    @Override
    public int execute(final String string, final Object ... objectArray) {
        AssertTools.assertNotEmpty((String)string);
        int n = (Integer)this.getHibernateTemplate().executeWithNativeSession((HibernateCallback)new HibernateCallback<Integer>(){

            public Integer doInHibernate(Session session) {
                SQLQuery sQLQuery = session.createSQLQuery(string);
                if (objectArray != null) {
                    for (int i = 0; i < objectArray.length; ++i) {
                        sQLQuery.setParameter(i, objectArray[i]);
                    }
                }
                return sQLQuery.executeUpdate();
            }
        });
        this.getHibernateTemplate().flush();
        this.getHibernateTemplate().clear();
        return n;
    }

    @Override
    public <M extends AbstractModel> boolean exists(Class<M> clazz, Serializable serializable) {
        return this.count(HibernateTemplateDao.criteriaByProperty(clazz, AbstractModel.getIdField(clazz).getName(), serializable).setProjection(Projections.rowCount())) > 0L;
    }

    @Override
    public <M extends AbstractModel> boolean exists(Class<M> clazz, String string, Serializable serializable) {
        return this.count(HibernateTemplateDao.criteriaByProperty(clazz, string, serializable).setProjection(Projections.rowCount())) > 0L;
    }

    @Override
    public boolean exists(DetachedCriteria detachedCriteria) {
        return this.count(detachedCriteria) > 0L;
    }

    @Override
    public <M extends AbstractModel> List<M> readList(Class<M> clazz) {
        AssertTools.assertNotNull(clazz);
        return (List)GenericsTools.cast((Object)this.getHibernateTemplate().findByCriteria(DetachedCriteria.forClass(clazz).addOrder(Order.asc((String)AbstractModel.getIdField(clazz).getName()))));
    }

    @Override
    public <M extends AbstractModel> List<M> readList(Class<M> clazz, String ... stringArray) {
        AssertTools.assertNotNull(clazz);
        AssertTools.assertNotEmpty((Object[])stringArray);
        DetachedCriteria detachedCriteria = DetachedCriteria.forClass(clazz);
        for (String string : stringArray) {
            detachedCriteria.addOrder(Order.asc((String)string));
        }
        return (List)GenericsTools.cast((Object)this.getHibernateTemplate().findByCriteria(detachedCriteria));
    }

    @Override
    public <M extends AbstractModel> List<M> readList(Class<M> clazz, int n, int n2) {
        AssertTools.assertNotNull(clazz);
        AssertTools.assertPositive((Number)n);
        AssertTools.assertPositive((Number)n2);
        return (List)GenericsTools.cast((Object)this.getHibernateTemplate().findByCriteria(DetachedCriteria.forClass(clazz).addOrder(Order.asc((String)AbstractModel.getIdField(clazz).getName())), n, n2));
    }

    @Override
    public <M extends AbstractModel> List<M> readList(Class<M> clazz, int n, int n2, String ... stringArray) {
        AssertTools.assertNotNull(clazz);
        AssertTools.assertNotEmpty((Object[])stringArray);
        AssertTools.assertPositive((Number)n);
        AssertTools.assertPositive((Number)n2);
        DetachedCriteria detachedCriteria = DetachedCriteria.forClass(clazz);
        for (String string : stringArray) {
            detachedCriteria.addOrder(Order.asc((String)string));
        }
        return (List)GenericsTools.cast((Object)this.getHibernateTemplate().findByCriteria(detachedCriteria, n, n2));
    }

    @Override
    public <M extends AbstractModel> M read(Class<M> clazz, Serializable serializable) {
        AssertTools.assertNotNull(clazz);
        AssertTools.assertNotNull((Object)serializable);
        AbstractModel abstractModel = (AbstractModel)clazz.cast(this.getHibernateTemplate().get(clazz, serializable));
        if (abstractModel == null) {
            throw new ObjectRetrievalFailureException(clazz, (Object)serializable);
        }
        return (M)abstractModel;
    }

    @Override
    public <M extends AbstractModel> M read(Class<M> clazz, String string, Serializable serializable) {
        List<?> list = this.list(HibernateTemplateDao.criteriaByProperty(clazz, string, serializable));
        if (list.size() != 1) {
            throw new ObjectRetrievalFailureException(clazz, (Object)serializable);
        }
        return (M)((AbstractModel)list.get(0));
    }

    @Override
    public <M extends AbstractModel> void refresh(M m) {
        AssertTools.assertNotNull(m);
        this.getHibernateTemplate().refresh(m);
    }

    @Override
    public <M extends AbstractModel> void update(M m) {
        AssertTools.assertNotNull(m);
        this.getHibernateTemplate().update(m);
    }

    @Override
    public <M extends AbstractModel> void evict(M m) {
        AssertTools.assertNotNull(m);
        this.getHibernateTemplate().evict(m);
    }

    @Override
    public <M extends AbstractModel> boolean contains(M m) {
        AssertTools.assertNotNull(m);
        return this.getHibernateTemplate().contains(m);
    }

    @Override
    public <M extends AbstractModel> void merge(M m) {
        AssertTools.assertNotNull(m);
        this.getHibernateTemplate().merge(m);
    }
}

