/*
 * Decompiled with CFR 0.152.
 */
package nc.ird.cantharella.data.config;

import com.mchange.v2.c3p0.ComboPooledDataSource;
import com.mchange.v2.c3p0.impl.DefaultConnectionTester;
import java.beans.PropertyVetoException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import javax.sql.DataSource;
import javax.validation.Validation;
import javax.validation.ValidatorFactory;
import nc.ird.cantharella.data.exceptions.UnexpectedException;
import nc.ird.cantharella.data.validation.utils.ModelValidator;
import nc.ird.cantharella.data.validation.utils.ModelValidatorEventListener;
import nc.ird.cantharella.data.validation.utils.ModelValidatorImpl;
import nc.ird.module.utils.LogTools;
import org.apache.commons.logging.Log;
import org.hibernate.SessionFactory;
import org.hibernate.cache.SingletonEhCacheProvider;
import org.hibernate.connection.C3P0ConnectionProvider;
import org.hibernate.dialect.PostgreSQLDialect;
import org.postgresql.Driver;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.MessageSource;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ImportResource;
import org.springframework.context.support.MessageSourceAccessor;
import org.springframework.context.support.ReloadableResourceBundleMessageSource;
import org.springframework.orm.hibernate3.HibernateTransactionManager;
import org.springframework.orm.hibernate3.SpringTransactionFactory;
import org.springframework.orm.hibernate3.annotation.AnnotationSessionFactoryBean;

@ImportResource(value={"classpath:/dataContext.xml"})
@ComponentScan(basePackages={"nc.ird.cantharella.data.dao", "nc.ird.cantharella.data.validation.utils"})
@Configuration
public abstract class DataContext {
    private static final Log LOG = LogTools.getLog();
    public static final List<String> COUNTRY_CODES = Collections.unmodifiableList(Arrays.asList(Locale.getISOCountries()));
    private static final int DB_CONNECTION_ACQUIRE_RETRY_ATTEMPS = 30;
    private static final int DB_CONNECTION_ACQUIRE_RETRY_DELAY = 1000;
    private static final int DB_POOL_ACQUIRE_INCREMENT = 3;
    private static final int DB_POOL_MAX_SIZE = 15;
    private static final int DB_POOL_MIN_SIZE = 3;
    public static final String ENCODING = Charset.forName("UTF-8").name();
    public static final List<Locale> LOCALES;
    public static final int DECIMAL_PRECISION = 9;
    public static final int DECIMAL_SCALE = 4;
    public static final int DECIMAL_MAX = 99999;
    public static final Map<Integer, String> REFERENTIELS;
    @Value(value="${db.debug}")
    protected boolean dbDebugProperty;
    @Value(value="${db.password}")
    protected String dbPasswordProperty;
    @Value(value="${db.url}")
    protected String dbUrlProperty;
    @Value(value="${db.user}")
    protected String dbUserProperty;

    @Bean
    public MessageSourceAccessor dataMessageSource() {
        ReloadableResourceBundleMessageSource reloadableResourceBundleMessageSource = new ReloadableResourceBundleMessageSource();
        reloadableResourceBundleMessageSource.setBasename("data");
        reloadableResourceBundleMessageSource.setDefaultEncoding(ENCODING);
        reloadableResourceBundleMessageSource.setCacheSeconds(-1);
        return new MessageSourceAccessor((MessageSource)reloadableResourceBundleMessageSource);
    }

    @Bean
    public DataSource dataSource() {
        ComboPooledDataSource comboPooledDataSource = new ComboPooledDataSource();
        try {
            comboPooledDataSource.setDriverClass(Driver.class.getName());
        }
        catch (PropertyVetoException propertyVetoException) {
            LOG.fatal((Object)propertyVetoException.getMessage(), (Throwable)propertyVetoException);
            throw new UnexpectedException(propertyVetoException);
        }
        comboPooledDataSource.setJdbcUrl(this.dbUrlProperty);
        comboPooledDataSource.setPassword(this.dbPasswordProperty);
        comboPooledDataSource.setUser(this.dbUserProperty);
        comboPooledDataSource.setInitialPoolSize(3);
        comboPooledDataSource.setMaxConnectionAge(0);
        comboPooledDataSource.setMaxIdleTimeExcessConnections(0);
        comboPooledDataSource.setAutomaticTestTable(null);
        try {
            comboPooledDataSource.setConnectionTesterClassName(DefaultConnectionTester.class.getName());
        }
        catch (PropertyVetoException propertyVetoException) {
            LOG.fatal((Object)propertyVetoException.getMessage(), (Throwable)propertyVetoException);
            throw new UnexpectedException(propertyVetoException);
        }
        comboPooledDataSource.setPreferredTestQuery(null);
        comboPooledDataSource.setTestConnectionOnCheckin(false);
        comboPooledDataSource.setTestConnectionOnCheckout(false);
        comboPooledDataSource.setMaxStatementsPerConnection(0);
        comboPooledDataSource.setAcquireRetryAttempts(30);
        comboPooledDataSource.setAcquireRetryDelay(1000);
        comboPooledDataSource.setBreakAfterAcquireFailure(false);
        comboPooledDataSource.setConnectionCustomizerClassName(null);
        comboPooledDataSource.setAutoCommitOnClose(false);
        comboPooledDataSource.setForceIgnoreUnresolvedTransactions(false);
        comboPooledDataSource.setDebugUnreturnedConnectionStackTraces(false);
        comboPooledDataSource.setUnreturnedConnectionTimeout(0);
        comboPooledDataSource.setCheckoutTimeout(0);
        comboPooledDataSource.setFactoryClassLocation(null);
        comboPooledDataSource.setMaxAdministrativeTaskTime(0);
        comboPooledDataSource.setUsesTraditionalReflectiveProxies(false);
        return comboPooledDataSource;
    }

    @Bean
    public SessionFactory sessionFactory() {
        AnnotationSessionFactoryBean annotationSessionFactoryBean = new AnnotationSessionFactoryBean();
        annotationSessionFactoryBean.setDataSource(this.dataSource());
        annotationSessionFactoryBean.setPackagesToScan(new String[]{"nc.ird.cantharella.data.model"});
        Properties properties = new Properties();
        properties.setProperty("hibernate.dialect", PostgreSQLDialect.class.getName());
        properties.setProperty("hibernate.hbm2ddl.auto", "validate");
        properties.setProperty("hibernate.generate_statistics", String.valueOf(this.dbDebugProperty));
        properties.setProperty("hibernate.cache.use_structured_entries", String.valueOf(this.dbDebugProperty));
        properties.setProperty("hibernate.show_sql", String.valueOf(false));
        properties.setProperty("hibernate.format_sql", String.valueOf(false));
        properties.setProperty("hibernate.use_sql_comments", String.valueOf(this.dbDebugProperty));
        properties.setProperty("hibernate.cache.provider_class", SingletonEhCacheProvider.class.getName());
        properties.setProperty("hibernate.cache.use_query_cache", String.valueOf(true));
        properties.setProperty("hibernate.cache.use_second_level_cache", String.valueOf(true));
        properties.setProperty("hibernate.cache.use_structured_entries", String.valueOf(this.dbDebugProperty));
        properties.setProperty("hibernate.connection.autocommit", String.valueOf(false));
        properties.setProperty("hibernate.connection.release_mode", "on_close");
        properties.setProperty("hibernate.connection.provider_class", C3P0ConnectionProvider.class.getName());
        properties.setProperty("hibernate.c3p0.acquire_increment", String.valueOf(3));
        properties.setProperty("hibernate.c3p0.idle_test_period", String.valueOf(0));
        properties.setProperty("hibernate.c3p0.timeout", String.valueOf(0));
        properties.setProperty("hibernate.c3p0.max_size", String.valueOf(15));
        properties.setProperty("hibernate.c3p0.max_statements", String.valueOf(0));
        properties.setProperty("hibernate.c3p0.min_size", String.valueOf(3));
        properties.setProperty("hibernate.current_session_context_class", "thread");
        properties.setProperty("hibernate.transaction.factory_class", SpringTransactionFactory.class.getName());
        properties.setProperty("hibernate.default_batch_fetch_size", String.valueOf(20));
        annotationSessionFactoryBean.setHibernateProperties(properties);
        HashMap<String, ModelValidatorEventListener> hashMap = new HashMap<String, ModelValidatorEventListener>();
        ModelValidatorEventListener modelValidatorEventListener = new ModelValidatorEventListener(this.validatorFactory());
        hashMap.put("pre-insert", modelValidatorEventListener);
        hashMap.put("pre-update", modelValidatorEventListener);
        annotationSessionFactoryBean.setEventListeners(hashMap);
        try {
            annotationSessionFactoryBean.afterPropertiesSet();
        }
        catch (Exception exception) {
            throw new RuntimeException("SessionFactory misconfiguration", exception);
        }
        return annotationSessionFactoryBean.getObject();
    }

    @Bean
    public HibernateTransactionManager transactionManager() {
        return new HibernateTransactionManager(this.sessionFactory());
    }

    @Bean
    public ValidatorFactory validatorFactory() {
        return Validation.buildDefaultValidatorFactory();
    }

    @Bean
    public ModelValidator dataModelValidator() {
        return new ModelValidatorImpl(this.validatorFactory(), this.dataMessageSource());
    }

    static {
        ArrayList<Locale> arrayList = new ArrayList<Locale>();
        arrayList.add(Locale.FRENCH);
        arrayList.add(Locale.ENGLISH);
        LOCALES = Collections.unmodifiableList(arrayList);
        Locale.setDefault(LOCALES.get(0));
        HashMap<Integer, String> hashMap = new HashMap<Integer, String>();
        hashMap.put(4326, "WGS84");
        REFERENTIELS = Collections.unmodifiableMap(hashMap);
    }
}

