/*
 * Copyright (C) The MX4J Contributors.
 * All rights reserved.
 *
 * This software is distributed under the terms of the MX4J License version 1.0.
 * See the terms of the MX4J License in the documentation provided with this software.
 */

package mx4j.tools.heartbeat;

/**
 * Interface to be implemented by any mbean that may support
 * heartbeat mechanism.
 * Implementation must return NO_HEARTBEAT if there is no
 * heartbeat capability.
 *
 * @version $Revision: 1.4 $
 */

public interface HeartBeatCapable
{
   public static final String NO_HEARTBEAT = null;

   public String getHeartBeatName();
}