/*
 * Copyright (C) The MX4J Contributors.
 * All rights reserved.
 *
 * This software is distributed under the terms of the MX4J License version 1.0.
 * See the terms of the MX4J License in the documentation provided with this software.
 */

package mx4j.tools.adaptor.rmi;

import java.io.IOException;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.rmi.server.RMIServerSocketFactory;
import javax.management.MBeanServer;
import javax.management.MBeanServerInvocationHandler;
import javax.management.ObjectName;

import mx4j.tools.adaptor.ssl.SSLAdaptorServerSocketFactoryMBean;

/**
 * The SSL RMIServerSocketFactory that uses the SSLAdaptorServerSocketFactory MBean to create instances of
 * secure ServerSockets.
 *
 * @version $Revision: 1.3 $
 */
public class SSLAdaptorRMIServerSocketFactory implements RMIServerSocketFactory, Serializable
{
   private SSLAdaptorServerSocketFactoryMBean m_factory;

   public SSLAdaptorRMIServerSocketFactory(MBeanServer server, ObjectName factory)
   {
      m_factory = (SSLAdaptorServerSocketFactoryMBean)MBeanServerInvocationHandler.newProxyInstance(server, factory, SSLAdaptorServerSocketFactoryMBean.class, false);
   }

   public SSLAdaptorRMIServerSocketFactory(SSLAdaptorServerSocketFactoryMBean factory)
   {
      if (factory == null)
      {
         throw new IllegalArgumentException("SSL ServerSocket factory cannot be null");
      }
      m_factory = factory;
   }

   public ServerSocket createServerSocket(int port) throws IOException
   {
      return m_factory.createServerSocket(port, 50, InetAddress.getLocalHost().getHostName());
   }
}
