/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.tests;

import java.io.Serializable;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.jgroups.JChannel;
import org.jgroups.Message;
import org.jgroups.MessageListener;
import org.jgroups.Transport;
import org.jgroups.View;
import org.jgroups.blocks.PullPushAdapter;
import org.jgroups.tests.stack.Utilities;
import org.jgroups.util.Promise;

public class DisconnectTest
extends TestCase {
    private JChannel channel;
    private int routerPort;

    public DisconnectTest(String name) {
        super(name);
    }

    public void setUp() throws Exception {
        super.setUp();
        this.routerPort = Utilities.startGossipRouter();
    }

    public void tearDown() throws Exception {
        super.tearDown();
        if (this.channel != null) {
            this.channel.close();
            this.channel = null;
        }
        Utilities.stopGossipRouter();
    }

    private String getTUNNELProps(int routerPort, int gossipPort) {
        return "TUNNEL(router_host=localhost;router_port=" + routerPort + "):" + "PING(gossip_host=localhost;gossip_port=" + gossipPort + "):" + "pbcast.FD:" + "VERIFY_SUSPECT(timeout=1500;down_thread=false;up_thread=false):" + "pbcast.NAKACK(gc_lag=100;retransmit_timeout=3000;" + "down_thread=true;up_thread=true):" + "pbcast.STABLE(desired_avg_gossip=20000;down_thread=false;" + "up_thread=false):" + "pbcast.GMS(join_timeout=5000;join_retry_timeout=2000;shun=false;" + "print_local_addr=false;down_thread=true;up_thread=true)";
    }

    public void testDisconnectConnectOne_Default() throws Exception {
        this.channel = new JChannel();
        this.channel.connect("testgroup1");
        this.channel.disconnect();
        this.channel.connect("testgroup2");
        View view = this.channel.getView();
        DisconnectTest.assertEquals((int)1, (int)view.size());
        DisconnectTest.assertTrue((boolean)view.containsMember(this.channel.getLocalAddress()));
    }

    public void testDisconnectConnectTwo_Default() throws Exception {
        JChannel coordinator = new JChannel();
        coordinator.connect("testgroup");
        this.channel = new JChannel();
        this.channel.connect("testgroup1");
        this.channel.disconnect();
        this.channel.connect("testgroup");
        View view = this.channel.getView();
        DisconnectTest.assertEquals((int)2, (int)view.size());
        DisconnectTest.assertTrue((boolean)view.containsMember(this.channel.getLocalAddress()));
        DisconnectTest.assertTrue((boolean)view.containsMember(coordinator.getLocalAddress()));
        coordinator.close();
    }

    public void testDisconnectConnectSendTwo_Default() throws Exception {
        Promise msgPromise = new Promise();
        JChannel coordinator = new JChannel();
        coordinator.connect("testgroup");
        PullPushAdapter ppa = new PullPushAdapter((Transport)coordinator, new PromisedMessageListener(msgPromise));
        ppa.start();
        this.channel = new JChannel();
        this.channel.connect("testgroup1");
        this.channel.disconnect();
        this.channel.connect("testgroup");
        this.channel.send(new Message(null, null, (Serializable)((Object)"payload")));
        Message msg = (Message)msgPromise.getResult(20000L);
        DisconnectTest.assertTrue((msg != null ? 1 : 0) != 0);
        DisconnectTest.assertEquals((Object)"payload", (Object)msg.getObject());
        ppa.stop();
        coordinator.close();
    }

    public void testDisconnectConnectOne_TUNNEL() throws Exception {
        String props = this.getTUNNELProps(this.routerPort, this.routerPort);
        this.channel = new JChannel(props);
        this.channel.connect("testgroup1");
        this.channel.disconnect();
        this.channel.connect("testgroup2");
        View view = this.channel.getView();
        DisconnectTest.assertEquals((int)1, (int)view.size());
        DisconnectTest.assertTrue((boolean)view.containsMember(this.channel.getLocalAddress()));
    }

    public void testDisconnectConnectTwo_TUNNEL() throws Exception {
        String props = this.getTUNNELProps(this.routerPort, this.routerPort);
        JChannel coordinator = new JChannel(props);
        coordinator.connect("testgroup");
        this.channel = new JChannel(props);
        this.channel.connect("testgroup1");
        this.channel.disconnect();
        this.channel.connect("testgroup");
        Thread.sleep(1000L);
        View view = this.channel.getView();
        DisconnectTest.assertEquals((int)2, (int)view.size());
        DisconnectTest.assertTrue((boolean)view.containsMember(this.channel.getLocalAddress()));
        DisconnectTest.assertTrue((boolean)view.containsMember(coordinator.getLocalAddress()));
        coordinator.close();
    }

    public void testDisconnectConnectSendTwo_TUNNEL() throws Exception {
        String props = this.getTUNNELProps(this.routerPort, this.routerPort);
        Promise msgPromise = new Promise();
        JChannel coordinator = new JChannel(props);
        coordinator.connect("testgroup");
        PullPushAdapter ppa = new PullPushAdapter((Transport)coordinator, new PromisedMessageListener(msgPromise));
        ppa.start();
        this.channel = new JChannel(props);
        this.channel.connect("testgroup1");
        this.channel.disconnect();
        this.channel.connect("testgroup");
        this.channel.send(new Message(null, null, (Serializable)((Object)"payload")));
        Message msg = (Message)msgPromise.getResult(20000L);
        DisconnectTest.assertTrue((msg != null ? 1 : 0) != 0);
        DisconnectTest.assertEquals((Object)"payload", (Object)msg.getObject());
        ppa.stop();
        coordinator.close();
    }

    public static Test suite() {
        TestSuite s = new TestSuite(DisconnectTest.class);
        return s;
    }

    public static void main(String[] args) {
        String[] testCaseName = new String[]{DisconnectTest.class.getName()};
        TestRunner.main((String[])testCaseName);
    }

    private class PromisedMessageListener
    implements MessageListener {
        private Promise promise;

        public PromisedMessageListener(Promise promise) {
            this.promise = promise;
        }

        public byte[] getState() {
            return null;
        }

        public void receive(Message msg) {
            this.promise.setResult(msg);
        }

        public void setState(byte[] state) {
        }
    }
}

