/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.srp;

import java.io.Serializable;
import java.util.Arrays;
import org.jboss.security.Util;

public class SRPParameters
implements Cloneable,
Serializable {
    private static final long serialVersionUID = 6438772808805276693L;
    public final byte[] N;
    public final byte[] g;
    public final byte[] s;
    public final String hashAlgorithm;
    public final String cipherAlgorithm;
    public byte[] cipherIV;

    public SRPParameters(byte[] N, byte[] g, byte[] s) {
        this(N, g, s, "SHA_Interleave", null);
    }

    public SRPParameters(byte[] N, byte[] g, byte[] s, String hashAlgorithm) {
        this(N, g, s, hashAlgorithm, null);
    }

    public SRPParameters(byte[] N, byte[] g, byte[] s, String hashAlgorithm, String cipherAlgorithm) {
        this.N = N;
        this.g = g;
        this.s = s;
        if (hashAlgorithm == null) {
            hashAlgorithm = "SHA_Interleave";
        }
        this.hashAlgorithm = hashAlgorithm;
        this.cipherAlgorithm = cipherAlgorithm;
    }

    public Object clone() {
        Object clone = null;
        try {
            clone = super.clone();
        }
        catch (CloneNotSupportedException e) {}
        return clone;
    }

    public int hashCode() {
        int hashCode = this.hashAlgorithm.hashCode();
        int i = 0;
        while (i < this.N.length) {
            hashCode += this.N[i];
            ++i;
        }
        int i2 = 0;
        while (i2 < this.g.length) {
            hashCode += this.g[i2];
            ++i2;
        }
        int i3 = 0;
        while (i3 < this.s.length) {
            hashCode += this.s[i3];
            ++i3;
        }
        return hashCode;
    }

    public boolean equals(Object obj) {
        boolean equals = false;
        if (obj instanceof SRPParameters) {
            SRPParameters p = (SRPParameters)obj;
            equals = this.hashAlgorithm.equals(p.hashAlgorithm);
            if (equals) {
                equals = Arrays.equals(this.N, p.N);
            }
            if (equals) {
                equals = Arrays.equals(this.g, p.g);
            }
            if (equals) {
                equals = Arrays.equals(this.s, p.s);
            }
        }
        return equals;
    }

    public String toString() {
        StringBuffer tmp = new StringBuffer(super.toString());
        tmp.append('{');
        tmp.append("N: ");
        tmp.append(Util.encodeBase64(this.N));
        tmp.append("|g: ");
        tmp.append(Util.encodeBase64(this.g));
        tmp.append("|s: ");
        tmp.append(Util.encodeBase64(this.s));
        tmp.append("|hashAlgorithm: ");
        tmp.append(this.hashAlgorithm);
        tmp.append("|cipherAlgorithm: ");
        tmp.append(this.cipherAlgorithm);
        tmp.append("|cipherIV: ");
        tmp.append(this.cipherIV);
        tmp.append('}');
        return tmp.toString();
    }
}

