/*
 * Decompiled with CFR 0.152.
 */
package javax.xml.soap;

import java.util.AbstractList;
import java.util.Iterator;
import java.util.Vector;
import javax.xml.soap.MimeHeader;

public class MimeHeaders {
    private Vector headers = new Vector();

    public String[] getHeader(String name) {
        Vector<String> values = new Vector<String>();
        for (int i = 0; i < this.headers.size(); ++i) {
            MimeHeader hdr = (MimeHeader)this.headers.elementAt(i);
            if (!hdr.getName().equalsIgnoreCase(name) || hdr.getValue() == null) continue;
            values.addElement(hdr.getValue());
        }
        if (values.size() == 0) {
            return null;
        }
        Object[] r = new String[values.size()];
        values.copyInto(r);
        return r;
    }

    public void setHeader(String name, String value) {
        boolean found = false;
        if (name == null || name.equals("")) {
            throw new IllegalArgumentException("Illegal MimeHeader name");
        }
        for (int i = 0; i < this.headers.size(); ++i) {
            MimeHeader hdr = (MimeHeader)this.headers.elementAt(i);
            if (!hdr.getName().equalsIgnoreCase(name)) continue;
            if (!found) {
                this.headers.setElementAt(new MimeHeader(hdr.getName(), value), i);
                found = true;
                continue;
            }
            this.headers.removeElementAt(i--);
        }
        if (!found) {
            this.addHeader(name, value);
        }
    }

    public void addHeader(String name, String value) {
        if (name == null || name.equals("")) {
            throw new IllegalArgumentException("Illegal MimeHeader name");
        }
        int pos = this.headers.size();
        for (int i = pos - 1; i >= 0; --i) {
            MimeHeader hdr = (MimeHeader)this.headers.elementAt(i);
            if (!hdr.getName().equalsIgnoreCase(name)) continue;
            this.headers.insertElementAt(new MimeHeader(name, value), i + 1);
            return;
        }
        this.headers.addElement(new MimeHeader(name, value));
    }

    public void removeHeader(String name) {
        for (int i = 0; i < this.headers.size(); ++i) {
            MimeHeader hdr = (MimeHeader)this.headers.elementAt(i);
            if (!hdr.getName().equalsIgnoreCase(name)) continue;
            this.headers.removeElementAt(i--);
        }
    }

    public void removeAllHeaders() {
        this.headers.removeAllElements();
    }

    public Iterator getAllHeaders() {
        return ((AbstractList)this.headers).iterator();
    }

    public Iterator getMatchingHeaders(String[] names) {
        return new MatchingIterator(names, true);
    }

    public Iterator getNonMatchingHeaders(String[] names) {
        return new MatchingIterator(names, false);
    }

    class MatchingIterator
    implements Iterator {
        private boolean match;
        private Iterator iterator;
        private String[] names;
        private Object nextHeader;

        MatchingIterator(String[] names, boolean match) {
            this.match = match;
            this.names = names;
            this.iterator = ((AbstractList)MimeHeaders.this.headers).iterator();
        }

        private Object nextMatch() {
            block0: while (this.iterator.hasNext()) {
                MimeHeader hdr = (MimeHeader)this.iterator.next();
                if (this.names == null) {
                    return this.match ? null : hdr;
                }
                for (int i = 0; i < this.names.length; ++i) {
                    if (!hdr.getName().equalsIgnoreCase(this.names[i])) continue;
                    if (!this.match) continue block0;
                    return hdr;
                }
                if (this.match) continue;
                return hdr;
            }
            return null;
        }

        public boolean hasNext() {
            if (this.nextHeader == null) {
                this.nextHeader = this.nextMatch();
            }
            return this.nextHeader != null;
        }

        public Object next() {
            if (this.nextHeader != null) {
                Object ret = this.nextHeader;
                this.nextHeader = null;
                return ret;
            }
            if (this.hasNext()) {
                return this.nextHeader;
            }
            return null;
        }

        public void remove() {
            this.iterator.remove();
        }
    }
}

