/*
 * The contents of this file are subject to the terms
 * of the Common Development and Distribution License
 * (the "License").  You may not use this file except
 * in compliance with the License.
 *
 * You can obtain a copy of the license at
 * glassfish/bootstrap/legal/CDDLv1.0.txt or
 * https://glassfish.dev.java.net/public/CDDLv1.0.html.
 * See the License for the specific language governing
 * permissions and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL
 * HEADER in each file and include the License file at
 * glassfish/bootstrap/legal/CDDLv1.0.txt.  If applicable,
 * add the following below this CDDL HEADER, with the
 * fields enclosed by brackets "[]" replaced with your
 * own identifying information: Portions Copyright [yyyy]
 * [name of copyright owner]
 *
 * Copyright 2005 Sun Microsystems, Inc. All rights reserved.
 *
 * Portions Copyright Apache Software Foundation.
 */

package javax.servlet.jsp.el;

/**
 * <p>This class is used to customize the way an ExpressionEvaluator resolves
 * variable references at evaluation time.  For example, instances of this class can
 * implement their own variable lookup mechanisms, or introduce the
 * notion of "implicit variables" which override any other variables.
 * An instance of this class should be passed when evaluating
 * an expression.</p>
 *
 * <p>An instance of this class includes the context against which resolution
 * will happen</p>
 *
 * @deprecated As of JSP 2.1, replaced by {@link javax.el.ELResolver}
 * @since JSP 2.0
 */
public interface VariableResolver
{
  //-------------------------------------
  /**
   * Resolves the specified variable.
   * Returns null if the variable is not found.
   * 
   * @param pName the name of the variable to resolve
   * @return the result of the variable resolution
   *
   * @throws ELException if a failure occurred while trying to resolve
   *     the given variable
   **/
  public Object resolveVariable (String pName)
    throws ELException;
					
  //-------------------------------------
}
