/**
 *  Copyright (c) 2011-2013 Terracotta, Inc.
 *  Copyright (c) 2011-2013 Oracle and/or its affiliates.
 *
 *  All rights reserved. Use is subject to license terms.
 */

/**
 * The annotations in this package provide method interceptors for user supplied
 * classes.
 * <p>
 * In the case of a the {@link javax.cache.annotation.CacheResult} annotation,
 * if the cache can satisfy the request a result is returned by the method from
 * cache, not from method execution. For the mutative annotations such as
 * {@link javax.cache.annotation.CacheResult} the annotation allows the cached
 * value to be mutated so that it will be correct the next time
 * {@link javax.cache.annotation.CacheResult} is used.
 * <p>
 * Any operations against a cache via an annotation will have the same behaviour
 * as if the {@link javax.cache.annotation.CacheResult} methods were used. So
 * if the same underlying cache is used for an annotation and a direct API call,
 * the same data would be returned. Annotations therefore provide an additional
 * API for interacting with caches.
 * <p>
 * To use these annotations you'll need a library or framework that processes
 * these annotations and intercepts calls to your application objects
 * to provide the caching behaviour. This would commonly be provided by a
 * dependency injection framework such as defined by CDI in Java EE.
 *
 *  @author Eric Dalquist
 *  @author Greg Luck
 *  @since 1.0
 */
package javax.cache.annotation;
