/*
 * Decompiled with CFR 0.152.
 */
package ccl.util;

import ccl.util.ApplicationException;
import ccl.util.Comparable;
import ccl.util.Testable;
import ccl.util.Transformable;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Field;
import java.net.InetAddress;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Enumeration;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.Random;
import java.util.SimpleTimeZone;
import java.util.StringTokenizer;
import java.util.TimeZone;
import java.util.Vector;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class Util {
    private static Random _rnd = new Random();
    private static Object _objSwap = null;
    private static boolean _bNochKeinSwap = true;
    private static int _swap = -1;
    private static boolean _bNochKeinIntSwap = true;
    private static final char[] AC_UMLAUT = new char[]{'\u00e4', '\u00c4', '\u00f6', '\u00d6', '\u00fc', '\u00dc', '\u00df', '\u00e9'};
    private static boolean _bDebug = false;
    public static final Object O_CONSTANT = new Object();
    static /* synthetic */ Class class$ccl$util$Util;

    private Util() {
    }

    public static void setDebug(boolean bDebug_) {
        _bDebug = bDebug_;
    }

    public static boolean isDebug() {
        return _bDebug;
    }

    public static void setDebug(String sDebug_) {
        Util.setDebug(Util.atob(sDebug_));
    }

    public static void debug(Object oMessage_) {
        if (_bDebug) {
            Util.printlnErr(oMessage_.toString());
        }
    }

    public static void debug(int i) {
        Util.debug("int: " + i);
    }

    public static void debug(Object oOriginator_, Object oMessage_) {
        if (_bDebug) {
            Util.printlnErr(oOriginator_, oMessage_);
        }
    }

    public static void debug(Class cOriginator_, Object oMessage_) {
        if (_bDebug) {
            Util.printlnErr(cOriginator_, oMessage_);
        }
    }

    public static void panicIf(boolean bPanic_) {
        if (bPanic_) {
            throw new ApplicationException();
        }
    }

    public static void panicIf(boolean bPanic_, String sMessage_) {
        if (bPanic_) {
            throw new ApplicationException(sMessage_);
        }
    }

    public static void assert(boolean bAssert_) {
        Util.panicIf(!bAssert_);
    }

    public static void assert(Object pObject_) {
        Util.panicIf(pObject_ == null);
    }

    public static void Assert(boolean bAssert_) {
        Util.panicIf(!bAssert_);
    }

    public static void Assert(Object pObject_) {
        Util.panicIf(pObject_ == null);
    }

    public static void print(char c_) {
        System.out.print(c_);
        System.out.flush();
    }

    public static void print(String pString_) {
        System.out.print(pString_);
        System.out.flush();
    }

    public static void print(Object pObject_) {
        if (pObject_ == null) {
            Util.print("null");
        } else {
            Util.print(pObject_.toString());
        }
    }

    public static void println(String pString_) {
        System.out.println(pString_);
        System.out.flush();
    }

    public static void println(Exception e) {
        System.out.println("Exception: " + e.getMessage());
        Thread.dumpStack();
        Util.println(Thread.currentThread().toString());
    }

    public static void println(Object pObject_) {
        Util.print(pObject_);
        Util.print('\n');
    }

    public static void println() {
        Util.print('\n');
    }

    public static void printErr(char c_) {
        System.err.print(c_);
        System.err.flush();
    }

    public static void printErr(String pString_) {
        System.err.print(pString_);
        System.err.flush();
    }

    public static void printErr(Object pObject_) {
        if (pObject_ == null) {
            Util.printErr("null");
        } else {
            Util.printErr(pObject_.toString());
        }
    }

    public static void printlnErr() {
        Util.printErr('\n');
    }

    public static void printlnErr(String sMessage_) {
        Util.printErr(sMessage_);
        Util.printlnErr();
    }

    public static void printlnErr(Object pObject_) {
        if (pObject_ == null) {
            Util.printlnErr("null");
        } else {
            Util.printlnErr(pObject_.toString());
        }
    }

    public static void printlnErr(Exception exception_) {
        Util.printlnErr(exception_.getMessage());
        Util.printlnErr(Util.getStackTrace(exception_));
    }

    public static void printlnErr(Object oClass_, Object oMessage_) {
        Util.panicIf(oClass_ == null);
        Util.printErr(oClass_.getClass().getName() + ".");
        Util.printlnErr(oMessage_);
    }

    public static void printlnErr(Class oClass_, Object oMessage_) {
        Util.panicIf(oClass_ == null);
        Util.printErr(oClass_.getName() + ".");
        Util.printlnErr(oMessage_);
    }

    public static void showLiveSignal() {
        Util.showLiveSignal('.');
    }

    public static void showLiveSignal(char c_) {
        Util.print(c_);
    }

    public static int atoi(String pString_) {
        if (Util.isEmpty(pString_)) {
            return 0;
        }
        int result = 0;
        boolean bNegative = false;
        int index = 0;
        int max = pString_.length();
        int limit = 0;
        int multmin = 0;
        int digit = 0;
        while (index < max - 1 && pString_.charAt(index) == ' ') {
            ++index;
        }
        if (pString_.charAt(index) == '-') {
            bNegative = true;
            limit = Integer.MIN_VALUE;
            ++index;
        } else {
            limit = -2147483647;
        }
        multmin = limit / 10;
        if (index < max) {
            if ((digit = Character.digit(pString_.charAt(index++), 10)) < 0) {
                return 0;
            }
            result = -digit;
        }
        while (index < max) {
            if ((digit = Character.digit(pString_.charAt(index++), 10)) < 0 || result < multmin || (result *= 10) < limit + digit) break;
            result -= digit;
        }
        if (!bNegative) {
            result = -result;
        }
        return result;
    }

    public static long atol(String pString_) {
        return Long.parseLong(pString_, 10);
    }

    public static String itoa(int i_) {
        return String.valueOf(i_);
    }

    public static String ltoa(long l_) {
        return String.valueOf(l_);
    }

    public static String dtoa(double d_) {
        return String.valueOf(d_);
    }

    public static float atof(String pString_) {
        float fRetVal = 0.0f;
        if (Util.isEmpty(pString_)) {
            return fRetVal;
        }
        try {
            fRetVal = Float.valueOf(pString_).floatValue();
        }
        catch (NumberFormatException pNumberFormatException) {
            fRetVal = Float.NaN;
        }
        return fRetVal;
    }

    public static double atod(String pString_) {
        double dRetVal = 0.0;
        String pString = Util.replace(pString_, "'", "");
        if (Util.isEmpty(pString)) {
            return dRetVal;
        }
        try {
            dRetVal = Double.valueOf(pString);
        }
        catch (NumberFormatException pNumberFormatException) {
            dRetVal = Double.NaN;
        }
        return dRetVal;
    }

    public static double ltod(long l_) {
        return l_;
    }

    public static byte[] intToBytes(int i_) {
        byte[] abInt = new byte[4];
        abInt[3] = (byte)(i_ & 0xFF);
        abInt[2] = (byte)(i_ >> 8 & 0xFF);
        abInt[1] = (byte)(i_ >> 16 & 0xFF);
        abInt[0] = (byte)(i_ >> 24);
        return abInt;
    }

    public static int bytesToInt(byte[] abInt) {
        Util.panicIf(abInt.length != 4);
        Util.debug("Util.bytesToInt(): abInt: " + abInt[0] + "," + abInt[1] + "," + abInt[2] + "," + abInt[3]);
        int byteValue3 = 256 + abInt[3] & 0xFF;
        int byteValue2 = (256 + abInt[2] & 0xFF) * 256;
        int byteValue1 = (256 + abInt[1] & 0xFF) * 256 * 256;
        int byteValue0 = (256 + abInt[0] & 0xFF) * 256 * 256 * 256;
        int i = byteValue0 | byteValue1 | byteValue2 | byteValue3;
        return i;
    }

    public static char byteToChar(byte b_) {
        int intValue = 256 + b_ & 0xFF;
        return (char)intValue;
    }

    public static int btoi(byte b_) {
        return Util.byteToInt(b_);
    }

    public static int byteToInt(byte b_) {
        int intValue = 256 + b_ & 0xFF;
        return intValue;
    }

    public static String byteToString(byte b_) {
        return Util.cToS(Util.byteToChar(b_));
    }

    public static String cToS(char c_) {
        return new Character(c_).toString();
    }

    public static int toUpperCase(int character_) {
        String sTemp = "" + (char)character_;
        char retVal = sTemp.toUpperCase().charAt(0);
        return retVal;
    }

    public static int toLowerCase(int character_) {
        String sTemp = "" + (char)character_;
        char retVal = sTemp.toLowerCase().charAt(0);
        return retVal;
    }

    public static boolean atob(String pString_) {
        return Boolean.valueOf(pString_);
    }

    public static boolean isTrue(Boolean pBoolean_) {
        if (pBoolean_ == null) {
            return false;
        }
        return pBoolean_;
    }

    public static boolean isEmpty(String sTest_) {
        return sTest_ == null || sTest_.equals("");
    }

    public static int getOccurances(String source, int zeichen) {
        int anzahl = -1;
        int index = 0;
        do {
            index = source.indexOf(zeichen, index) + 1;
            ++anzahl;
        } while (index != 0);
        return anzahl;
    }

    public static int getOccurances(String source_, String lookFor_) {
        int count = -1;
        int index = 0;
        do {
            index = source_.indexOf(lookFor_, index) + 1;
            ++count;
        } while (index != 0);
        return count;
    }

    public static String multiplyChar(char c, int anzahl) {
        String s = "";
        while (anzahl > 0) {
            s = s + c;
            --anzahl;
        }
        return s;
    }

    public static String multiplyChar(String sFill, int anzahl) {
        String sRet = "";
        while (anzahl > 0) {
            sRet = sRet + sFill;
            --anzahl;
        }
        return sRet;
    }

    public static String getSpaces(int length_) {
        Util.panicIf(length_ < 0);
        if (length_ == 0) {
            return "";
        }
        String sSpaces = "                                             ";
        if (length_ > sSpaces.length()) {
            return Util.multiplyChar(' ', length_);
        }
        return sSpaces.substring(0, length_);
    }

    public static String appendSpaces(String pString_, int length_) {
        if (pString_ == null) {
            return Util.getSpaces(length_);
        }
        String sRetVal = pString_ + Util.getSpaces(length_);
        return sRetVal.substring(0, length_);
    }

    public static String paddWith(int number_, int stellen_, char cPadd_) {
        return Util.paddWith(Util.itoa(number_), stellen_, cPadd_);
    }

    public static String paddWith(String pString_, int stellen_, char cPadd_) {
        String sRetVal = new String(pString_);
        if (sRetVal.length() >= stellen_) {
            return sRetVal;
        }
        String sPadding = Util.multiplyChar(cPadd_, stellen_ - sRetVal.length());
        sRetVal = sPadding + sRetVal;
        return sRetVal;
    }

    public static String paddWithSpace(int number, int stellen) {
        return Util.paddWith(number, stellen, ' ');
    }

    public static String paddWithSpace(long number, int stellen) {
        return Util.paddWith(Util.ltoa(number), stellen, ' ');
    }

    public static String paddWithSpace(double dNumber_, int stellen) {
        return Util.paddWith(new Double(dNumber_).toString(), stellen, ' ');
    }

    public static String paddWithSpace(String pString_, int stellen) {
        return Util.paddWith(pString_, stellen, ' ');
    }

    public static String rightPaddWithSpace(String pString_, int stellen) {
        StringBuffer sbReturn = new StringBuffer(32);
        if (pString_ != null) {
            sbReturn.append(pString_);
        }
        int i = 0;
        while (i <= stellen / 8) {
            sbReturn.append("        ");
            ++i;
        }
        return sbReturn.toString().substring(0, stellen);
    }

    public static String paddWithZero(int number, int stellen) {
        return Util.paddWith(number, stellen, '0');
    }

    public static String paddWithZero(long number, int stellen) {
        return Util.paddWith(Util.ltoa(number), stellen, '0');
    }

    public static String paddWithZero(String sNumber_, int stellen_) {
        return Util.paddWith(sNumber_, stellen_, '0');
    }

    public static String removeMultipleSpaces(String pString_) {
        Util.panicIf(pString_ == null);
        String sRetVal = new String(pString_);
        int doubleSpaceIndex = sRetVal.indexOf("  ");
        while (doubleSpaceIndex != -1) {
            sRetVal = sRetVal.substring(0, doubleSpaceIndex) + sRetVal.substring(doubleSpaceIndex + 1, sRetVal.length());
            doubleSpaceIndex = sRetVal.indexOf("  ", doubleSpaceIndex);
        }
        return sRetVal;
    }

    public static String rtrim(String s) {
        int index = s.length() - 1;
        while (index >= 0 && (s.charAt(index) == ' ' || s.charAt(index) == '\n' || s.charAt(index) == '\r' || s.charAt(index) == '\t')) {
            --index;
        }
        return s.substring(0, index + 1);
    }

    public static String ltrim(String s) {
        int index = 0;
        while (index < s.length() && s.charAt(index) == ' ') {
            ++index;
        }
        return s.substring(index, s.length());
    }

    public static String unifySpaces(String s) {
        String sRetVal = new String();
        String sRest = s.trim();
        int index = 0;
        while (sRest != null && sRest.length() > 0) {
            index = sRest.indexOf(32);
            if (index < 0) {
                sRetVal = sRetVal + sRest;
                sRest = null;
                continue;
            }
            sRetVal = sRetVal + sRest.substring(0, index + 1);
            sRest = sRest.substring(index + 1, sRest.length());
            sRest = Util.ltrim(sRest);
        }
        return sRetVal;
    }

    public static boolean equalsCaseless(String sA_, String sB_) {
        String sFirst = sA_.toUpperCase();
        String sSecond = sB_.toUpperCase();
        return sFirst.equals(sSecond);
    }

    public static String firstCharToUpperCase(String pString_) {
        String sRetVal = new String();
        if (pString_ == null || pString_.length() == 0) {
            return sRetVal;
        }
        sRetVal = pString_.substring(0, 1).toUpperCase() + pString_.substring(1, pString_.length());
        return sRetVal;
    }

    public static String firstCharToLowerCase(String pString_) {
        String sRetVal = new String();
        if (pString_ == null || pString_.length() == 0) {
            return sRetVal;
        }
        sRetVal = pString_.substring(0, 1).toLowerCase() + pString_.substring(1, pString_.length());
        return sRetVal;
    }

    public static boolean endsWith(String sThis_, char cOther_) {
        if (Util.isEmpty(sThis_)) {
            return false;
        }
        return sThis_.charAt(sThis_.length() - 1) == cOther_;
    }

    public static boolean endsWith(String pString_, String sEnd_) {
        if (Util.isEmpty(sEnd_)) {
            return true;
        }
        if (Util.isEmpty(pString_)) {
            return false;
        }
        int stringLen = pString_.length();
        int endLen = sEnd_.length();
        if (endLen > stringLen) {
            return false;
        }
        boolean bRetVal = sEnd_.equals(pString_.substring(stringLen - endLen, stringLen));
        return bRetVal;
    }

    public static String replace(String pString_, char cOld_, char cNew_) {
        return Util.replace(pString_, cOld_, cNew_, 0);
    }

    public static String replace(String pString_, char cOld_, char cNew_, int startIndex_) {
        return Util.replace(pString_, Util.cToS(cOld_), Util.cToS(cNew_), startIndex_);
    }

    public static String replace(String pString_, String sOld_, String sNew_) {
        return Util.replace(pString_, sOld_, sNew_, 0);
    }

    public static String replace(String pString_, String sOld_, String sNew_, int startIndex_) {
        Util.panicIf(sNew_ == null || sOld_ == null);
        if (pString_ == null) {
            return null;
        }
        StringBuffer sbRetVal = new StringBuffer(pString_.length());
        int copyIndex = 0;
        int lengthOld = sOld_.length();
        int index = startIndex_;
        while ((index = pString_.indexOf(sOld_, index)) != -1) {
            sbRetVal.append(pString_.substring(copyIndex, index));
            sbRetVal.append(sNew_);
            copyIndex = index += lengthOld;
        }
        sbRetVal.append(pString_.substring(copyIndex, pString_.length()));
        return sbRetVal.toString();
    }

    public static boolean isSpaceLine(String sLine_) {
        if (sLine_ == null || sLine_.length() == 0) {
            return true;
        }
        int index = 0;
        while (index < sLine_.length()) {
            char c = sLine_.charAt(index);
            if (c != ' ' && c != '\t' && c != '\n') {
                return false;
            }
            ++index;
        }
        return true;
    }

    public static String untabify(String pString) {
        int index = 0;
        while (index < pString.length()) {
            if (pString.charAt(index) == '\t') {
                pString = pString.substring(0, index) + Util.getSpaces(8 - index % 8) + pString.substring(index + 1);
            }
            ++index;
        }
        return pString;
    }

    public static String denullify(String pString_) {
        if (pString_ == null) {
            return "";
        }
        return pString_;
    }

    public static String toString(Object pObject_) {
        if (pObject_ == null) {
            return "null";
        }
        return pObject_.toString();
    }

    public static int contains(String sToLookIn_, String sThis_) {
        if (sToLookIn_ == null) {
            return -1;
        }
        if (sThis_ == null) {
            return -1;
        }
        int index = 0;
        while (index < sToLookIn_.length()) {
            if (sToLookIn_.regionMatches(index, sThis_, 0, sThis_.length())) {
                return index;
            }
            ++index;
        }
        return -1;
    }

    public static int compare(String firstString, String anotherString) {
        int len1 = firstString.length();
        int len2 = anotherString.length();
        int n = Math.min(len1, len2);
        int i = 0;
        int j = 0;
        while (n-- != 0) {
            char c2;
            char c1;
            if ((c1 = firstString.charAt(i++)) == (c2 = anotherString.charAt(j++))) continue;
            return c1 - c2;
        }
        return len1 - len2;
    }

    public static int indexOfNot(String pString_, char cNot_, int startIndex_) {
        Util.panicIf(pString_ == null || startIndex_ < 0);
        while (startIndex_ < pString_.length()) {
            if (pString_.charAt(startIndex_) != cNot_) {
                return startIndex_;
            }
            ++startIndex_;
        }
        return -1;
    }

    public static int indexOfNot(String pString_, char cNot_) {
        return Util.indexOfNot(pString_, cNot_, 0);
    }

    public static int count(String pString_, char c_) {
        int retVal = 0;
        if (Util.isEmpty(pString_)) {
            return retVal;
        }
        int index = pString_.indexOf(c_);
        while (index != -1) {
            ++retVal;
            ++index;
            index = pString_.indexOf(c_, index);
        }
        return retVal;
    }

    public static boolean isDigit(char c_) {
        return '0' <= c_ && c_ <= '9';
    }

    public static boolean isVocal(char c_) {
        String sVocals = "aouie\u00e4\u00f6\u00fc";
        String sChar = Util.cToS(c_).toLowerCase();
        return sVocals.indexOf(sChar) != -1;
    }

    public static String shrinkString(String pString, int maxSize) {
        if (Util.isEmpty(pString)) {
            return "";
        }
        if (pString.length() <= maxSize) {
            return pString;
        }
        String sRetVal = pString.substring(0, maxSize / 2 - 2) + "[...]";
        sRetVal = sRetVal + pString.substring(pString.length() - maxSize + sRetVal.length(), pString.length());
        return sRetVal;
    }

    public static String concat(Vector pVector_) {
        return Util.concat(pVector_, "");
    }

    public static String concat(Vector pVector_, String sWith_) {
        String sRetVal = new String();
        if (pVector_ == null || pVector_.size() < 1) {
            return sRetVal;
        }
        if (sWith_ == null) {
            sWith_ = "";
        }
        Enumeration e = pVector_.elements();
        sRetVal = sRetVal + e.nextElement().toString();
        while (e.hasMoreElements()) {
            sRetVal = sRetVal + sWith_ + e.nextElement().toString();
        }
        return sRetVal;
    }

    public static String concat(Vector pVector_, char cWith_) {
        return Util.concat(pVector_, Util.cToS(cWith_));
    }

    public static String concat(String pString_, char cWidth_) {
        return pString_ + Util.cToS(cWidth_);
    }

    public static Vector stringToLines(int lines_, String pString_, char cCutter_) {
        int maxLines = Integer.MAX_VALUE;
        if (lines_ > 0) {
            maxLines = lines_;
        }
        Vector<String> vRetVal = new Vector<String>();
        if (pString_ == null) {
            return vRetVal;
        }
        int startIndex = 0;
        while (maxLines > 0) {
            int endIndex = pString_.indexOf(cCutter_, startIndex);
            if (endIndex == -1) {
                if (startIndex >= pString_.length()) break;
                endIndex = pString_.length();
            }
            String sLine = pString_.substring(startIndex, endIndex);
            vRetVal.addElement(sLine);
            startIndex = endIndex + 1;
            --maxLines;
        }
        return vRetVal;
    }

    public static Vector stringToLines(String pString_, char cCutter_) {
        return Util.stringToLines(0, pString_, cCutter_);
    }

    public static Vector stringToLines(String pString_) {
        return Util.stringToLines(pString_, '\n');
    }

    public static Vector stringToLines(int lines_, String pString_) {
        return Util.stringToLines(lines_, pString_, '\n');
    }

    public static Vector stringToLines(String sLines_, String sCutter_) {
        Vector<String> vRetVal = new Vector<String>();
        if (sLines_ == null) {
            return vRetVal;
        }
        int startIndex = 0;
        while (startIndex < sLines_.length() && startIndex != -1) {
            int endIndex = sLines_.indexOf(sCutter_, startIndex);
            if (endIndex == -1) {
                endIndex = sLines_.length();
            }
            String sNextLine = sLines_.substring(startIndex, endIndex);
            vRetVal.addElement(sNextLine);
            startIndex = endIndex + sCutter_.length();
        }
        return vRetVal;
    }

    public static Vector stringToLines(String sLines_, String sTokenizerString_, boolean bUseTokenizer_) {
        if (!bUseTokenizer_) {
            return Util.stringToLines(sLines_, sTokenizerString_);
        }
        Vector<String> vRetVal = new Vector<String>();
        if (sLines_ == null) {
            return vRetVal;
        }
        StringTokenizer pStringTokenizer = new StringTokenizer(sLines_, sTokenizerString_, false);
        while (pStringTokenizer.hasMoreTokens()) {
            String sNextToken = pStringTokenizer.nextToken();
            vRetVal.addElement(sNextToken);
        }
        return vRetVal;
    }

    public static String formatBlock(String pString) {
        return Util.formatBlock(pString, 72);
    }

    private static String _formatBlockLine(String sLine, int lineLength, boolean bRight) {
        StringBuffer sbRetVal = new StringBuffer();
        sbRetVal.append(sLine);
        int spacesToAdd = lineLength - sLine.length();
        block0: do {
            Util.debug("ccl.util.Util._formatBlockLine(..).enter while true");
            int nextSpace = 0;
            int direction = 1;
            if (bRight) {
                nextSpace = sbRetVal.length() - 1;
                direction = -direction;
            }
            Util.debug("ccl.util.Util._formatBlockLine(..).direction:   " + direction);
            Util.debug("ccl.util.Util._formatBlockLine(..).spacesToAdd: " + spacesToAdd);
            boolean bRestart = false;
            while (!bRestart && spacesToAdd > 0) {
                Util.debug("ccl.util.Util._formatBlockLine(..).nextSpace: " + nextSpace);
                while (sbRetVal.charAt(nextSpace) != ' ') {
                    if ((nextSpace += direction) >= 0 && sbRetVal.length() > nextSpace) continue;
                    Util.debug("ccl.util.Util._formatBlockLine(..).first break finish");
                    bRestart = true;
                    break;
                }
                if (bRestart) continue block0;
                Util.debug("ccl.util.Util._formatBlockLine(..).insert space at: " + nextSpace);
                sbRetVal.insert(nextSpace, ' ');
                --spacesToAdd;
                while (sbRetVal.charAt(nextSpace) == ' ') {
                    if ((nextSpace += direction) >= 0 && sbRetVal.length() > nextSpace) continue;
                    bRestart = true;
                    break;
                }
                Util.debug("ccl.util.Util._formatBlockLine(..).spacesToAdd: " + spacesToAdd);
            }
        } while (spacesToAdd > 0);
        return sbRetVal.toString();
    }

    private static void _processSpaceBlock(StringBuffer sbRetVal, StringBuffer sbLine, int lineLength) {
        if (sbLine.length() == lineLength) {
            sbRetVal.append(sbLine.toString()).append('\n');
            sbLine.setLength(0);
        } else if (sbLine.length() > lineLength) {
            int lastSpace = sbLine.toString().lastIndexOf(32);
            if (lastSpace == -1) {
                sbRetVal.append(sbLine.toString()).append('\n');
                sbLine.setLength(0);
            } else {
                sbRetVal.append(Util._formatBlockLine(sbLine.substring(0, lastSpace), lineLength, true)).append('\n');
                sbLine.delete(0, lastSpace + 1).append(' ');
            }
        } else {
            sbLine.append(' ');
        }
    }

    public static String formatBlock(String pString, int lineLength) {
        String sWorkString = Util.replace(pString, "\n", " ");
        sWorkString = Util.replace(sWorkString, "\r", " ");
        sWorkString = Util.replace(sWorkString, "\t", " ");
        sWorkString = sWorkString.trim();
        StringBuffer sbRetVal = new StringBuffer();
        StringBuffer sbLine = new StringBuffer();
        boolean bWhiteSpace = false;
        int index = 0;
        while (index <= sWorkString.length()) {
            char nextChar = ' ';
            if (index < sWorkString.length()) {
                nextChar = sWorkString.charAt(index);
            }
            Util.debug("ccl.util.Util.formatLeft(..).nextChar: " + nextChar);
            if (nextChar == ' ' || nextChar == '\t' || nextChar == '\n' || nextChar == '\r') {
                if (!bWhiteSpace) {
                    Util._processSpaceBlock(sbRetVal, sbLine, lineLength);
                    bWhiteSpace = true;
                }
            } else {
                bWhiteSpace = false;
                sbLine.append(nextChar);
            }
            ++index;
            Util.debug("ccl.util.Util.formatLeft(..).sbRetVal: " + sbRetVal);
            Util.debug("ccl.util.Util.formatLeft(..).sbLine:   " + sbLine);
        }
        if (sbLine.length() > 0) {
            sbRetVal.append(Util.rtrim(sbLine.toString())).append('\n');
        }
        return sbRetVal.toString();
    }

    public static String formatBlock(String pString, int lineLength, int indentation) {
        String sRetVal = Util.formatBlock(pString, lineLength - indentation);
        Vector vLines = Util.stringToLines(sRetVal);
        Enumeration eLines = vLines.elements();
        sRetVal = "";
        while (eLines.hasMoreElements()) {
            sRetVal = sRetVal + Util.getSpaces(indentation) + (String)eLines.nextElement() + "\n";
        }
        return sRetVal;
    }

    public static String formatLeft(String pString) {
        return Util.formatLeft(pString, 72);
    }

    private static void _processSpaceLeft(StringBuffer sbRetVal, StringBuffer sbLine, int lineLength) {
        if (sbLine.length() == lineLength) {
            sbRetVal.append(sbLine.toString()).append('\n');
            sbLine.setLength(0);
        } else if (sbLine.length() > lineLength) {
            int lastSpace = sbLine.toString().lastIndexOf(32);
            if (lastSpace == -1) {
                sbRetVal.append(sbLine.toString()).append('\n');
                sbLine.setLength(0);
            } else {
                sbRetVal.append(sbLine.substring(0, lastSpace)).append('\n');
                sbLine.delete(0, lastSpace + 1).append(' ');
            }
        } else {
            sbLine.append(' ');
        }
    }

    public static String formatLeft(String pString, int lineLength) {
        String sWorkString = pString.trim();
        StringBuffer sbRetVal = new StringBuffer();
        StringBuffer sbLine = new StringBuffer();
        boolean bWhiteSpace = false;
        int index = 0;
        while (index <= sWorkString.length()) {
            char nextChar = ' ';
            if (index < sWorkString.length()) {
                nextChar = sWorkString.charAt(index);
            }
            Util.debug("ccl.util.Util.formatLeft(..).nextChar: " + nextChar);
            if (nextChar == ' ' || nextChar == '\t' || nextChar == '\n' || nextChar == '\r') {
                if (!bWhiteSpace) {
                    Util._processSpaceLeft(sbRetVal, sbLine, lineLength);
                    bWhiteSpace = true;
                }
            } else {
                bWhiteSpace = false;
                sbLine.append(nextChar);
            }
            ++index;
            Util.debug("ccl.util.Util.formatLeft(..).sbRetVal: " + sbRetVal);
            Util.debug("ccl.util.Util.formatLeft(..).sbLine:   " + sbLine);
        }
        if (sbLine.length() > 0) {
            sbRetVal.append(Util.rtrim(sbLine.toString())).append('\n');
        }
        return sbRetVal.toString();
    }

    public static String formatLeft(String pString, int lineLength, int indentation) {
        String sRetVal = Util.formatLeft(pString, lineLength - indentation);
        Vector vLines = Util.stringToLines(sRetVal);
        Enumeration eLines = vLines.elements();
        sRetVal = "";
        while (eLines.hasMoreElements()) {
            sRetVal = sRetVal + Util.getSpaces(indentation) + (String)eLines.nextElement() + "\n";
        }
        return sRetVal;
    }

    public static String formatCenter(String pString, int lineLength) {
        StringBuffer sbRetVal = new StringBuffer();
        String sLeft = Util.formatLeft(pString, lineLength);
        Vector vLines = Util.stringToLines(sLeft);
        Enumeration eLines = vLines.elements();
        while (eLines.hasMoreElements()) {
            String sLine = (String)eLines.nextElement();
            sLine = Util.centerLine(sLine, lineLength);
            sbRetVal.append(sLine).append('\n');
        }
        return sbRetVal.toString();
    }

    public static String centerLine(String pString, int lineLength) {
        if (Util.isEmpty(pString)) {
            return "";
        }
        if (pString.length() > lineLength) {
            return pString;
        }
        int add = (lineLength - pString.length()) / 2;
        return Util.getSpaces(add) + pString;
    }

    public static int getDiffPosition(String s1, String s2) {
        if (s1 == null) {
            throw new IllegalArgumentException("First string is null");
        }
        if (s2 == null) {
            throw new IllegalArgumentException("Second string is null");
        }
        int position = -1;
        while (++position < s1.length() && position < s2.length() && s1.charAt(position) == s2.charAt(position)) {
        }
        return position;
    }

    public static boolean isEmpty(Vector vTest_) {
        return vTest_ == null || vTest_.size() == 0;
    }

    /*
     * Unable to fully structure code
     */
    public static Vector toVector(Enumeration pEnumeration_) {
        vRetVal = new Vector<E>();
        if (pEnumeration_ != null) ** GOTO lbl5
        return vRetVal;
lbl-1000:
        // 1 sources

        {
            vRetVal.addElement(pEnumeration_.nextElement());
lbl5:
            // 2 sources

            ** while (pEnumeration_.hasMoreElements())
        }
lbl6:
        // 1 sources

        return vRetVal;
    }

    public static Vector objectsToVector(Object[] apObjects) {
        Vector<Object> vRetVal = new Vector<Object>();
        if (apObjects != null && apObjects.length > 0) {
            int nr = 0;
            while (nr < apObjects.length) {
                vRetVal.addElement(apObjects[nr]);
                ++nr;
            }
        }
        return vRetVal;
    }

    public static Object[] vectorToObjects(Vector pVector_) {
        if (pVector_ == null) {
            return new Object[0];
        }
        Object[] aoRetVal = new Object[pVector_.size()];
        pVector_.copyInto(aoRetVal);
        return aoRetVal;
    }

    public static Vector filter(Vector pVector_, final Object oBadElement_) {
        Util.panicIf(oBadElement_ == null);
        Testable pFilter = new Testable(){

            public boolean test(Object pObject_) {
                return !oBadElement_.equals(pObject_);
            }
        };
        return Util.filter(pVector_, pFilter);
    }

    public static Vector filter(Vector pVector_, Vector vBadElements_) {
        Vector vRetVal = pVector_;
        Util.panicIf(vBadElements_ == null);
        Enumeration e = vBadElements_.elements();
        while (e.hasMoreElements()) {
            Object oBadElement = e.nextElement();
            vRetVal = Util.filter(vRetVal, oBadElement);
        }
        return vRetVal;
    }

    public static Vector filter(Vector pVector_, Testable pFilter_) {
        Vector vRetVal = new Vector();
        Enumeration e = pVector_.elements();
        while (e.hasMoreElements()) {
            Object pObject = e.nextElement();
            if (!pFilter_.test(pObject)) continue;
            vRetVal.addElement(pObject);
        }
        return vRetVal;
    }

    public static Vector map(Vector pVector_, Transformable pTransformable_) {
        Vector<Object> vRetVal = new Vector<Object>();
        Enumeration e = pVector_.elements();
        while (e.hasMoreElements()) {
            Object pObject = e.nextElement();
            vRetVal.addElement(pTransformable_.transform(pObject));
        }
        return vRetVal;
    }

    public static boolean contains(Vector pVector_, final String sFind_) {
        Util.panicIf(sFind_ == null);
        Testable pFilter = new Testable(){

            public boolean test(Object pObject_) {
                return sFind_.equals((String)pObject_);
            }
        };
        return Util.contains(pVector_, pFilter);
    }

    public static boolean contains(Vector pVector_, Testable pFilter_) {
        Vector vRetVal = new Vector();
        Enumeration e = pVector_.elements();
        while (e.hasMoreElements()) {
            Object pObject = e.nextElement();
            if (!pFilter_.test(pObject)) continue;
            return true;
        }
        return false;
    }

    public static Vector enumerationToVector(Enumeration pEnumeration_) {
        Vector vRetVal = new Vector();
        while (pEnumeration_.hasMoreElements()) {
            Object pObject = pEnumeration_.nextElement();
            vRetVal.addElement(pObject);
        }
        return vRetVal;
    }

    public static Vector concat(Vector vFirst_, Vector vSecond_) {
        Vector vRetVal = (Vector)vFirst_.clone();
        Enumeration e = vSecond_.elements();
        while (e.hasMoreElements()) {
            vRetVal.addElement(e.nextElement());
        }
        return vRetVal;
    }

    public static Vector subtract(Vector vSource_, Vector vToDelete_) {
        Vector vRetVal = (Vector)vSource_.clone();
        Enumeration e = vToDelete_.elements();
        while (e.hasMoreElements()) {
            vRetVal.removeElement(e.nextElement());
        }
        return vRetVal;
    }

    public static Vector insert(Vector vDestination_, Vector vOther_, int destination) {
        Util.panicIf(vDestination_ == null || vOther_ == null);
        if (destination > vDestination_.size()) {
            destination = vDestination_.size();
        }
        Vector vRetVal = new Vector();
        int i = 0;
        while (i < destination) {
            vRetVal.addElement(vDestination_.elementAt(i));
            ++i;
        }
        vRetVal = Util.concat(vRetVal, vOther_);
        int i2 = destination;
        while (i2 < vDestination_.size()) {
            vRetVal.addElement(vDestination_.elementAt(i2));
            ++i2;
        }
        return vRetVal;
    }

    public static boolean equals(Vector vFirst_, Vector vSecond_) {
        if (vFirst_ == vSecond_) {
            return true;
        }
        if (vFirst_ == null || vSecond_ == null) {
            return false;
        }
        if (vFirst_.size() != vSecond_.size()) {
            return false;
        }
        int index = 0;
        while (index < vFirst_.size()) {
            Object oFirst = vFirst_.elementAt(index);
            Object oSecond = vSecond_.elementAt(index);
            if (oFirst != null || oSecond != null) {
                if (oFirst == null || oSecond == null) {
                    return false;
                }
                if (!oFirst.equals(oSecond)) {
                    return false;
                }
            }
            ++index;
        }
        return true;
    }

    public static Vector invert(Vector vSource_) {
        if (vSource_ == null || vSource_.size() == 0) {
            return new Vector();
        }
        int vectorSize = vSource_.size();
        Vector vDest = new Vector(vectorSize);
        int index = vectorSize - 1;
        while (index >= 0) {
            Object oNext = vSource_.elementAt(index);
            vDest.addElement(oNext);
            --index;
        }
        return vDest;
    }

    public static void quickSort(Object[] s, int lo, int hi, Comparable cmp) {
        int right;
        int left;
        Object tmp;
        if (lo >= hi) {
            return;
        }
        int mid = (lo + hi) / 2;
        if (cmp.compare(s[lo], s[mid]) > 0) {
            tmp = s[lo];
            s[lo] = s[mid];
            s[mid] = tmp;
        }
        if (cmp.compare(s[mid], s[hi]) > 0) {
            tmp = s[mid];
            s[mid] = s[hi];
            s[hi] = tmp;
            if (cmp.compare(s[lo], s[mid]) > 0) {
                Object tmp2 = s[lo];
                s[lo] = s[mid];
                s[mid] = tmp2;
            }
        }
        if ((left = lo + 1) >= (right = hi - 1)) {
            return;
        }
        Object partition = s[mid];
        while (true) {
            if (cmp.compare(s[right], partition) > 0) {
                --right;
                continue;
            }
            while (left < right && cmp.compare(s[left], partition) <= 0) {
                ++left;
            }
            if (left >= right) break;
            Object tmp2 = s[left];
            s[left] = s[right];
            s[right] = tmp2;
            --right;
        }
        Util.quickSort(s, lo, left, cmp);
        Util.quickSort(s, left + 1, hi, cmp);
    }

    public static void quickSort(Vector v, int lo, int hi, Comparable cmp) {
        int right;
        int left;
        Object tmp;
        Util.panicIf(v == null);
        if (lo >= hi) {
            return;
        }
        int mid = (lo + hi) / 2;
        if (cmp.compare(v.elementAt(lo), v.elementAt(mid)) > 0) {
            tmp = v.elementAt(lo);
            v.setElementAt(v.elementAt(mid), lo);
            v.setElementAt(tmp, mid);
        }
        if (cmp.compare(v.elementAt(mid), v.elementAt(hi)) > 0) {
            tmp = v.elementAt(mid);
            v.setElementAt(v.elementAt(hi), mid);
            v.setElementAt(tmp, hi);
            if (cmp.compare(v.elementAt(lo), v.elementAt(mid)) > 0) {
                Object tmp2 = v.elementAt(lo);
                v.setElementAt(v.elementAt(mid), lo);
                v.setElementAt(tmp2, mid);
            }
        }
        if ((left = lo + 1) >= (right = hi - 1)) {
            return;
        }
        Object partition = v.elementAt(mid);
        while (true) {
            if (cmp.compare(v.elementAt(right), partition) > 0) {
                --right;
                continue;
            }
            while (left < right && cmp.compare(v.elementAt(left), partition) <= 0) {
                ++left;
            }
            if (left >= right) break;
            Object tmp2 = v.elementAt(left);
            v.setElementAt(v.elementAt(right), left);
            v.setElementAt(tmp2, right);
            --right;
        }
        Util.quickSort(v, lo, left, cmp);
        Util.quickSort(v, left + 1, hi, cmp);
    }

    public static Vector sort(Vector vInput_, Comparable pComparable_) {
        Util.panicIf(vInput_ == null);
        Vector vRetVal = (Vector)vInput_.clone();
        if (vInput_.size() > 0) {
            Util.quickSort(vRetVal, 0, vRetVal.size() - 1, pComparable_);
        }
        return vRetVal;
    }

    public static void sortFast(Vector vInput_, Comparable pComparable_) {
        Util.panicIf(vInput_ == null);
        if (vInput_.size() > 0) {
            Util.quickSort(vInput_, 0, vInput_.size() - 1, pComparable_);
        }
    }

    public static Vector sort(Vector pVector_) {
        Comparable pComparable = new Comparable(){

            public int compare(Object oFirst_, Object oSecond_) {
                return oFirst_.toString().toLowerCase().compareTo(oSecond_.toString().toLowerCase());
            }
        };
        return Util.sort(pVector_, pComparable);
    }

    public static void sortFast(Vector pVector_) {
        Comparable pComparable = new Comparable(){

            public int compare(Object oFirst_, Object oSecond_) {
                return oFirst_.toString().toLowerCase().compareTo(oSecond_.toString().toLowerCase());
            }
        };
        Util.sortFast(pVector_, pComparable);
    }

    public static Vector sort(Enumeration pEnumeration_) {
        return Util.sort(Util.toVector(pEnumeration_));
    }

    public static Vector sort(Enumeration pEnumeration_, Comparable pComparable_) {
        return Util.sort(Util.toVector(pEnumeration_), pComparable_);
    }

    public static Vector sortCaseSensitive(Vector pVector_) {
        Comparable pComparable = new Comparable(){

            public int compare(Object oFirst_, Object oSecond_) {
                return oFirst_.toString().compareTo(oSecond_.toString());
            }
        };
        return Util.sort(pVector_, pComparable);
    }

    public static int insert(Vector pVector_, int lowestOffset_, int highestOffset_, Object pObject_, Comparable pComparable_) {
        if (highestOffset_ < lowestOffset_) {
            pVector_.insertElementAt(pObject_, lowestOffset_);
            return lowestOffset_;
        }
        int midleOffset = (lowestOffset_ + highestOffset_) / 2;
        if (pComparable_.compare(pObject_, pVector_.elementAt(midleOffset)) < 0) {
            return Util.insert(pVector_, lowestOffset_, midleOffset - 1, pObject_, pComparable_);
        }
        return Util.insert(pVector_, midleOffset + 1, highestOffset_, pObject_, pComparable_);
    }

    public static int insert(Vector pVector_, Object pObject_, Comparable pComparable_) {
        Util.panicIf(pVector_ == null);
        return Util.insert(pVector_, 0, pVector_.size() - 1, pObject_, pComparable_);
    }

    public static Process system(String sCommand_) throws IOException {
        Process pProcess = Runtime.getRuntime().exec(sCommand_);
        return pProcess;
    }

    public static Process system(String[] asCommand_) throws IOException {
        Process pProcess = Runtime.getRuntime().exec(asCommand_);
        return pProcess;
    }

    public static Process system(Vector vArgs_) throws IOException {
        Util.panicIf(vArgs_ == null || vArgs_.size() == 0);
        String[] asArgs = new String[vArgs_.size()];
        int arg = 0;
        Enumeration eArgs = vArgs_.elements();
        while (eArgs.hasMoreElements()) {
            asArgs[arg] = (String)eArgs.nextElement();
            ++arg;
        }
        return Util.system(asArgs);
    }

    public static String systemAndWait(Vector vArgs_) throws IOException {
        Util.panicIf(vArgs_ == null || vArgs_.size() == 0);
        StringBuffer sbRetVal = new StringBuffer(1024);
        String sLine = null;
        Process pProcess = Util.system(vArgs_);
        BufferedReader reader = new BufferedReader(new InputStreamReader(pProcess.getInputStream()));
        while ((sLine = reader.readLine()) != null) {
            Util.debug("ccl.util.Util.systemAndWait(..).line: " + sLine);
            sbRetVal.append(sLine).append("\n");
        }
        reader.close();
        return sbRetVal.toString();
    }

    public static String systemAndWait(String commandline) throws IOException {
        Util.panicIf(Util.isEmpty(commandline));
        String sRetVal = "";
        String sLine = null;
        Process pProcess = Util.system(commandline);
        BufferedReader reader = new BufferedReader(new InputStreamReader(pProcess.getInputStream()));
        while ((sLine = reader.readLine()) != null) {
            sRetVal = sRetVal + sLine + "\n";
        }
        reader.close();
        return sRetVal;
    }

    public static String systemAndGetError(Vector vArgs_) throws IOException {
        Util.panicIf(vArgs_ == null || vArgs_.size() == 0);
        String sRetVal = "";
        String sLine = null;
        Process pProcess = Util.system(vArgs_);
        BufferedReader reader = new BufferedReader(new InputStreamReader(pProcess.getErrorStream()));
        while ((sLine = reader.readLine()) != null) {
            sRetVal = sRetVal + sLine + "\n";
        }
        reader.close();
        return sRetVal;
    }

    public static String systemAndGetError(String commandline) throws IOException {
        Util.panicIf(Util.isEmpty(commandline));
        String sRetVal = "";
        String sLine = null;
        Process pProcess = Util.system(commandline);
        BufferedReader reader = new BufferedReader(new InputStreamReader(pProcess.getErrorStream()));
        while ((sLine = reader.readLine()) != null) {
            Util.debug("ccl.util.Util.systemAndGetError(..).line: " + sLine);
            sRetVal = sRetVal + sLine + "\n";
        }
        reader.close();
        return sRetVal;
    }

    public static boolean isOSWindows() {
        String sOSName = System.getProperty("os.name");
        Util.debug("Util.isOSWindows().sOSName: " + sOSName);
        return sOSName.startsWith("Windows");
    }

    public static boolean isOSLinux() {
        String sOSName = System.getProperty("os.name");
        return sOSName.startsWith("Linux");
    }

    public static boolean isOSSolaris() {
        String sOSName = System.getProperty("os.name");
        return sOSName.startsWith("Solaris") || sOSName.startsWith("SunOS");
    }

    public static boolean isOSUnix() {
        return Util.isOSLinux() || Util.isOSSolaris();
    }

    public static void gc() {
        System.gc();
        Thread.yield();
    }

    public static String getLocalHostName() {
        String sHostName = "";
        try {
            InetAddress iaLocalHost = InetAddress.getLocalHost();
            sHostName = iaLocalHost.getHostName();
        }
        catch (Exception eLocalHost) {
            return null;
        }
        return sHostName;
    }

    public static boolean isSwingPackage(String sFullPackageName_) {
        return !(!sFullPackageName_.startsWith("javax.") && !sFullPackageName_.startsWith("com.sun.java.") || !sFullPackageName_.equals("javax.swing") && !sFullPackageName_.equals("javax.accessibility") && !sFullPackageName_.startsWith("javax.swing.") && !sFullPackageName_.equals("com.sun.java.swing") && !sFullPackageName_.equals("com.sun.java.accessibility") && !sFullPackageName_.startsWith("com.sun.java.swing."));
    }

    public static String getStackTrace(Throwable pThrowable_) {
        StringWriter pStringWriter = new StringWriter();
        PrintWriter pPrintWriter = new PrintWriter(pStringWriter);
        pThrowable_.printStackTrace(pPrintWriter);
        return pStringWriter.toString();
    }

    public static String getStackTrace() {
        try {
            throw new RuntimeException();
        }
        catch (RuntimeException exception) {
            return Util.getStackTrace(exception);
        }
    }

    public static String getDump(Object object_) {
        String dumpString = "null";
        if (object_ != null) {
            Class<?> dumpClass = object_.getClass();
            dumpString = dumpClass.getName() + "@" + Integer.toHexString(object_.hashCode()) + ":";
            do {
                Field[] fieldArray = dumpClass.getDeclaredFields();
                int fieldIndex = 0;
                while (fieldIndex < fieldArray.length) {
                    try {
                        Field nextField = fieldArray[fieldIndex];
                        nextField.setAccessible(true);
                        dumpString = dumpString + "\n        " + nextField + ": " + nextField.get(object_);
                    }
                    catch (IllegalAccessException illegalAccessException) {
                        Util.printlnErr(illegalAccessException);
                    }
                    ++fieldIndex;
                }
            } while ((dumpClass = dumpClass.getSuperclass()) != null);
        }
        return dumpString;
    }

    public static boolean rnd() {
        return Util.rnd(1) == 0;
    }

    public static int rnd(int end_) {
        return Util.rnd(0, end_);
    }

    public static int rnd(int start_, int end_) {
        Util.panicIf(end_ <= start_);
        float fR = _rnd.nextFloat();
        int r = (int)(fR * (float)(end_ - start_ + 1) + (float)start_);
        return r;
    }

    public static float rnd(float f) {
        float fR = _rnd.nextFloat();
        return f * fR;
    }

    public static double rnd(double df) {
        double dR = _rnd.nextDouble();
        return df * dR;
    }

    public static String getStandardDate(Date pDate_) {
        return Util.getDate(pDate_);
    }

    public static String getDate(Date pDate_) {
        SimpleDateFormat pSimpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
        String sRetVal = pSimpleDateFormat.format(pDate_);
        return sRetVal;
    }

    public static String getDate() {
        return Util.getDate(Util.getCalendar());
    }

    public static String getDate(Calendar pCalendar_) {
        SimpleDateFormat pSimpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
        pSimpleDateFormat.setCalendar(pCalendar_);
        String sRetVal = pSimpleDateFormat.format(pCalendar_.getTime());
        return sRetVal;
    }

    public static String getTime(Date pDate_) {
        SimpleDateFormat pSimpleDateFormat = new SimpleDateFormat("HH:mm:ss");
        String sRetVal = pSimpleDateFormat.format(pDate_);
        return sRetVal;
    }

    public static String getTime(Calendar pCalendar_) {
        SimpleDateFormat pSimpleDateFormat = new SimpleDateFormat("HH:mm:ss");
        pSimpleDateFormat.setCalendar(pCalendar_);
        String sRetVal = pSimpleDateFormat.format(pCalendar_.getTime());
        return sRetVal;
    }

    public static String getTimeWithMillis() {
        return Util.getTimeWithMillis(Util.getCalendar());
    }

    public static String getTimeWithMillis(Calendar calendar_) {
        String timeWithMillis = Util.getTime(calendar_) + "." + Util.paddWithZero(calendar_.get(14), 3);
        return timeWithMillis;
    }

    public static String getDateTimeAndMillis() {
        Calendar now = Util.getCalendar();
        String sRetVal = Util.getDate(now);
        sRetVal = Util.replace(sRetVal, "-", "");
        sRetVal = sRetVal + Util.getTimeWithMillis(now);
        sRetVal = Util.replace(sRetVal, ":", "");
        sRetVal = Util.replace(sRetVal, ".", "");
        return sRetVal;
    }

    public static String getDateTime() {
        Calendar now = Util.getCalendar();
        String sRetVal = Util.getDate(now) + " " + Util.getTime(now);
        return sRetVal;
    }

    public static Date stringToDate(String sDate_) {
        if (sDate_ == null) {
            return null;
        }
        int offset = 1;
        if (sDate_.length() == 8) {
            offset = 0;
        }
        Date dtRetVal = new Date();
        try {
            String sYear = sDate_.substring(0, 4);
            String sMonth = sDate_.substring(4 + offset, 6 + offset);
            String sDay = sDate_.substring(6 + 2 * offset, 8 + 2 * offset);
            int year = Util.atoi(sYear);
            int month = Util.atoi(sMonth) - 1;
            int day = Util.atoi(sDay);
            GregorianCalendar pCalendar = new GregorianCalendar();
            pCalendar.setTime(dtRetVal);
            pCalendar.set(1, year);
            pCalendar.set(2, month);
            pCalendar.set(5, day);
            dtRetVal.setTime(pCalendar.getTime().getTime());
        }
        catch (Exception pException) {
            dtRetVal = null;
        }
        return dtRetVal;
    }

    public static Calendar getDate(String sDate_) {
        Calendar clnRetVal = Util.getCalendar();
        try {
            String sYear = sDate_.substring(0, 4);
            String sMonth = sDate_.substring(5, 7);
            String sDay = sDate_.substring(8, 10);
            int year = Util.atoi(sYear);
            int month = Util.atoi(sMonth) - 1;
            int day = Util.atoi(sDay);
            clnRetVal.set(1, year);
            clnRetVal.set(2, month);
            clnRetVal.set(5, day);
        }
        catch (Exception pException) {
            clnRetVal = null;
        }
        return clnRetVal;
    }

    public static Calendar getCalendar(String sTimeZoneID_) {
        if (Util.isEmpty(sTimeZoneID_)) {
            sTimeZoneID_ = "GMT";
        }
        TimeZone pTimeZone = null;
        pTimeZone = sTimeZoneID_.equals("UTC") ? new SimpleTimeZone(0, "UTC") : SimpleTimeZone.getTimeZone(sTimeZoneID_);
        Util.debug("Util.getCalendar(): pTimeZone: " + pTimeZone);
        if (sTimeZoneID_.equals("CET")) {
            pTimeZone = new SimpleTimeZone(3600000, "CET", 2, -1, 1, 0x6DDD00, 9, -1, 1, 0x6DDD00);
        }
        Util.debug("Util.getCalendar(): pTimeZone: " + pTimeZone);
        GregorianCalendar pCalendar = new GregorianCalendar(pTimeZone);
        return pCalendar;
    }

    public static Calendar getCalendar() {
        return Util.getCalendar(Calendar.getInstance().getTimeZone().getID());
    }

    public static void setTime(Calendar pCalendar_, String sTime_) {
        Util.panicIf(sTime_ == null);
        Util.panicIf(sTime_.length() != 8);
        String sDate = Util.getDate(pCalendar_);
        pCalendar_.setTime(new Date(0L));
        pCalendar_.set(Util.atoi(sDate.substring(0, 4)), Util.atoi(sDate.substring(5, 7)) - 1, Util.atoi(sDate.substring(8)), Util.atoi(sTime_.substring(0, 2)), Util.atoi(sTime_.substring(3, 5)), Util.atoi(sTime_.substring(6, 8)));
        pCalendar_.set(14, 0);
        Util.debug("ccl.util.Util.setTime(..).time: " + pCalendar_.getTime().getTime());
        long lTime = pCalendar_.getTime().getTime();
        Util.debug("ccl.util.Util.setTime(..).time%1000: " + lTime % 1000L);
        Util.debug("ccl.util.Util.setTime(..).time: " + pCalendar_.getTime().getTime());
    }

    public static void setDate(Calendar pCalendar_, String sDate_) {
        Util.panicIf(sDate_ == null);
        Util.panicIf(sDate_.length() != 10);
        String sTime = Util.getTime(pCalendar_);
        pCalendar_.setTime(new Date(0L));
        pCalendar_.set(Util.atoi(sDate_.substring(0, 4)), Util.atoi(sDate_.substring(5, 7)) - 1, Util.atoi(sDate_.substring(8)), Util.atoi(sTime.substring(0, 2)), Util.atoi(sTime.substring(3, 5)), Util.atoi(sTime.substring(6, 8)));
    }

    public static boolean isDateValid(String sDate_) {
        if (sDate_ == null || sDate_.length() != 8 && sDate_.length() != 10) {
            return false;
        }
        Date pDate = Util.stringToDate(sDate_);
        Date dtValidation = new Date(pDate.getTime());
        String sValidation = Util.getStandardDate(dtValidation);
        sValidation = Util.replace(sValidation, "-", "");
        return sValidation.equals(Util.replace(sDate_, "-", ""));
    }

    public static int getNumberOfDays(String sFrom_, String sTo_) {
        Calendar calFrom = Util.getDate(sFrom_);
        Calendar calTo = Util.getDate(sTo_);
        long diff = calTo.getTime().getTime() - calFrom.getTime().getTime();
        diff = diff / 86400000L + 1L;
        return (int)diff;
    }

    public static String getNextDay(String sDate_) {
        Calendar calendar = Util.getDate(sDate_);
        calendar.add(5, 1);
        return Util.getDate(calendar);
    }

    public static String getPreviousDay(String sDate_) {
        Calendar calendar = Util.getDate(sDate_);
        calendar.add(5, -1);
        return Util.getDate(calendar);
    }

    public static String getLastDayOfMonth(String sDate_) {
        Calendar calendar = Util.getDate(sDate_);
        calendar.set(5, 1);
        calendar.add(2, 1);
        calendar.add(5, -1);
        return Util.getDate(calendar);
    }

    public static String getFirstDayOfMonth(String sDate_) {
        Calendar calendar = Util.getDate(sDate_);
        calendar.set(5, 1);
        return Util.getDate(calendar);
    }

    public static String getMonth(String sDate) {
        if (!Util.isDateValid(sDate)) {
            Util.debug(class$ccl$util$Util == null ? (class$ccl$util$Util = Util.class$("ccl.util.Util")) : class$ccl$util$Util, (Object)("getMonth(..).INVALID_DATE: " + sDate));
            throw new IllegalArgumentException("Date '" + sDate + "' is not a valid ISO date");
        }
        int month = Util.atoi(sDate.substring(5, 7));
        if (month == 1) {
            return "January";
        }
        if (month == 2) {
            return "February";
        }
        if (month == 3) {
            return "March";
        }
        if (month == 4) {
            return "April";
        }
        if (month == 5) {
            return "May";
        }
        if (month == 6) {
            return "June";
        }
        if (month == 7) {
            return "July";
        }
        if (month == 8) {
            return "August";
        }
        if (month == 9) {
            return "September";
        }
        if (month == 10) {
            return "October";
        }
        if (month == 11) {
            return "November";
        }
        if (month == 12) {
            return "December";
        }
        return null;
    }

    public static String getTodaySortable() {
        String sDatum = null;
        Date date = new Date();
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(date);
        sDatum = Util.itoa(calendar.get(1));
        if (calendar.get(2) < 9) {
            sDatum = sDatum + "0";
        }
        sDatum = sDatum + Util.itoa(calendar.get(2) + 1);
        if (calendar.get(5) < 10) {
            sDatum = sDatum + "0";
        }
        sDatum = sDatum + Util.itoa(calendar.get(5));
        return sDatum;
    }

    public static String getHeuteSortable() {
        return Util.getTodaySortable();
    }

    public static Object getConstantObject() {
        return O_CONSTANT;
    }

    public static void sleep(int seconds_) {
        try {
            Thread.sleep(seconds_ * 1000);
        }
        catch (Exception pException) {}
    }

    public static boolean isAlpha(char c_) {
        if ('A' <= c_ && c_ <= 'Z' || 'a' <= c_ && c_ <= 'z') {
            return true;
        }
        int i = 0;
        while (i < AC_UMLAUT.length) {
            if (c_ == AC_UMLAUT[i]) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static long max(long a_, long b_) {
        if (a_ > b_) {
            return a_;
        }
        return b_;
    }

    public static int max(int a_, int b_) {
        if (a_ > b_) {
            return a_;
        }
        return b_;
    }

    public static int min(int a_, int b_) {
        if (a_ < b_) {
            return a_;
        }
        return b_;
    }

    public static Object swap(Object objFirst, Object objSecond) {
        Util.panicIf(!_bNochKeinSwap);
        _bNochKeinSwap = false;
        _objSwap = objFirst;
        return objSecond;
    }

    public static Object swap() {
        Util.panicIf(_bNochKeinSwap);
        _bNochKeinSwap = true;
        return _objSwap;
    }

    public static int swapInt(int first, int second) {
        Util.panicIf(!_bNochKeinIntSwap);
        _bNochKeinIntSwap = false;
        _swap = first;
        return second;
    }

    public static int swapInt() {
        Util.panicIf(_bNochKeinIntSwap);
        _bNochKeinIntSwap = true;
        return _swap;
    }

    public static String getObjectName(Object pObject_) {
        String sRetVal = pObject_.getClass().getName();
        sRetVal = sRetVal.substring(sRetVal.lastIndexOf(46) + 1);
        return sRetVal;
    }

    public static long getUsedMemory() {
        long total = Runtime.getRuntime().totalMemory();
        long free = Runtime.getRuntime().freeMemory();
        return total - free;
    }

    public static String getUsedMemoryPercentage() {
        long total = Runtime.getRuntime().totalMemory();
        long used = Util.getUsedMemory();
        return Util.getUsedMemoryPercentage(total, used);
    }

    public static String getUsedMemoryPercentage(long used, long total) {
        int percentage = (int)(used * 1000L / total);
        String sPercentage = Util.itoa(percentage / 10) + "." + Util.itoa(percentage % 10) + " %";
        return sPercentage;
    }

    public static String formatMemoryInfo() {
        long total = Runtime.getRuntime().totalMemory();
        long free = Runtime.getRuntime().freeMemory();
        long used = total - free;
        NumberFormat pNumberFormat = DecimalFormat.getInstance(Locale.US);
        String sTotal = pNumberFormat.format(total);
        String sUsed = pNumberFormat.format(used);
        sUsed = Util.getSpaces(sTotal.length() - sUsed.length()) + sUsed;
        return "Memory (in use/total):   " + sUsed + " / " + sTotal + "   (" + Util.getUsedMemoryPercentage(used, total) + ")";
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

