/*
 * Decompiled with CFR 0.152.
 */
package ccl.swing.test;

import ccl.swing.DateField;
import ccl.swing.SwingUtil;
import ccl.util.Test;
import ccl.util.Util;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;

public class DateFieldTest
extends Test {
    private void _setFocus(JComponent component_) {
        component_.requestFocus();
        Util.sleep(1);
    }

    private void _testIncDec(DateField pDateField_, String sInputDate_, boolean bUp_, int position_, String sResultDate_) {
        pDateField_.setText(sInputDate_);
        pDateField_.requestFocus();
        Util.sleep(1);
        this._setFocus(pDateField_);
        pDateField_.requestFocus();
        Util.sleep(1);
        pDateField_.setCaretPosition(position_);
        Util.sleep(1);
        int keyEvent = 40;
        if (bUp_) {
            keyEvent = 38;
        }
        SwingUtil.dispatchKeyEvent((Component)pDateField_, keyEvent);
        Util.sleep(1);
        this.bugIf(!pDateField_.getText().equals(sResultDate_), "Increasing (" + bUp_ + ") " + sInputDate_ + " at " + position_ + " did not " + "result in " + sResultDate_ + " but " + pDateField_.getText() + ".");
    }

    public DateFieldTest() {
    }

    public DateFieldTest(Test pTest_) {
        super(pTest_);
    }

    protected void _doIt() {
        DateField dateField = new DateField("CET");
        JFrame frmMain = new JFrame("DateField Test");
        DateField pDateField = new DateField("CET");
        frmMain.getContentPane().setLayout(new BorderLayout());
        frmMain.getContentPane().add((Component)pDateField, "Center");
        JButton btnDummy = new JButton("Dummy");
        frmMain.getContentPane().add((Component)btnDummy, "East");
        frmMain.setSize(200, 60);
        frmMain.pack();
        frmMain.setVisible(true);
        frmMain.setSize(200, 60);
        SwingUtil.centerComponent(frmMain);
        Thread.yield();
        pDateField.setText("1999-01-01");
        pDateField.requestFocus();
        Util.sleep(1);
        this._setFocus(pDateField);
        pDateField.requestFocus();
        Util.sleep(1);
        pDateField.setCaretPosition(6);
        Util.sleep(1);
        SwingUtil.dispatchKeyEvent((Component)pDateField, 40);
        Util.sleep(1);
        this.bugIf(!pDateField.getText().equals("1999-09-01"), "Decrease to 1999-09-01 did not work.");
        pDateField.setToday();
        pDateField.setText("");
        this.bugIf(!pDateField.getText().equals(""), "Date not set to \"\"!");
        this._testIncDec(pDateField, "1999-10-01", false, 5, "1999-10-01");
        this._testIncDec(pDateField, "1999-10-01", true, 5, "1999-10-01");
        this._testIncDec(pDateField, "1999-08-01", false, 9, "1999-08-09");
        this._testIncDec(pDateField, "1999-09-01", true, 6, "1999-01-01");
        this._testIncDec(pDateField, "1999-07-09", true, 9, "1999-07-01");
        this._testIncDec(pDateField, "1999-10-01", false, 6, "1999-12-01");
        this._testIncDec(pDateField, "1999-01-30", false, 9, "1999-01-31");
        this._testIncDec(pDateField, "1999-01-30", true, 8, "1999-01-10");
        this._testIncDec(pDateField, "1999-01-30", true, 8, "1999-01-10");
        this._testIncDec(pDateField, "1999-01-10", false, 8, "1999-01-30");
        this._testIncDec(pDateField, "1999-02-10", false, 8, "1999-02-10");
        pDateField.setText("1999-11-01");
        pDateField.requestFocus();
        Util.sleep(1);
        this._setFocus(pDateField);
        pDateField.requestFocus();
        Util.sleep(1);
        pDateField.setCaretPosition(6);
        Util.sleep(1);
        SwingUtil.dispatchKeyEvent((Component)pDateField, 40);
        Util.sleep(1);
        this.bugIf(!pDateField.getText().equals("1999-10-01"), "Decrease to 1999-10-01 did not work.");
        pDateField.setText("1999-02-21");
        pDateField.requestFocus();
        Util.sleep(1);
        this._setFocus(pDateField);
        pDateField.requestFocus();
        Util.sleep(1);
        pDateField.setCaretPosition(8);
        Util.sleep(1);
        SwingUtil.dispatchKeyEvent((Component)pDateField, 38);
        Util.sleep(1);
        this.bugIf(!pDateField.getText().equals("1999-02-01"), "Increase to 1999-02-01 did not work.");
        pDateField.setText("1999-12-31");
        this.bugIf(!pDateField.getText().equals("1999-12-31"), "Field couldn't be set (1999-12-31)!");
        pDateField.requestFocus();
        Util.sleep(1);
        this._setFocus(pDateField);
        pDateField.requestFocus();
        Util.sleep(1);
        pDateField.setCaretPosition(5);
        Util.sleep(1);
        SwingUtil.dispatchKeyEvent((Component)pDateField, 40);
        Util.sleep(1);
        this.bugIf(!pDateField.getText().equals("1999-12-31"), "Decrease did not work. It should not have changed a single bit.");
        pDateField.setText("1999-12-01");
        this.bugIf(!pDateField.getText().equals("1999-12-01"), "Field couldn't be set (1999-12-01)!");
        pDateField.requestFocus();
        Util.sleep(1);
        this._setFocus(pDateField);
        pDateField.requestFocus();
        Util.sleep(1);
        pDateField.setCaretPosition(5);
        Util.sleep(1);
        SwingUtil.dispatchKeyEvent((Component)pDateField, 40);
        Util.sleep(1);
        this.bugIf(!pDateField.getText().equals("1999-02-01"), "Decrease did not work. It should result in '1999-02-01'.");
        SwingUtil.dispatchKeyEvent((Component)pDateField, 40);
        Util.sleep(1);
        this.bugIf(!pDateField.getText().equals("1999-12-01"), "2. Decrease did not work. It should result in '1999-12-01'.");
        pDateField.setText("1999-12-01");
        this.bugIf(!pDateField.getText().equals("1999-12-01"), "Field couldn't be set (1999-12-01)!");
        pDateField.requestFocus();
        Util.sleep(1);
        this._setFocus(pDateField);
        pDateField.requestFocus();
        Util.sleep(1);
        pDateField.setCaretPosition(5);
        Util.sleep(1);
        SwingUtil.dispatchKeyEvent((Component)pDateField, 38);
        Util.sleep(1);
        this.bugIf(!pDateField.getText().equals("1999-02-01"), "Increase did not work. It should result in '1999-02-01'.");
        pDateField.clear();
        this.bugIf(pDateField.getText().length() != 0, "Text wasn't cleared!");
        Util.sleep(1);
        pDateField.requestFocus();
        Util.sleep(1);
        SwingUtil.dispatchKeyEvent((Component)pDateField, 'e');
        Util.sleep(1);
        this.bugIf(pDateField.getText().length() != 10, "Wrong key didn't set current date!");
        this.bugIf(pDateField.getCaretPosition() != 9, "Wrong caret/cursor position (should be 9): " + pDateField.getCaretPosition());
        pDateField.setText("1999-12-02");
        Util.sleep(1);
        this.bugIf(pDateField.getText().length() != 10, "No init date set in field!");
        pDateField.requestFocus();
        Util.sleep(1);
        pDateField.setCaretPosition(0);
        SwingUtil.dispatchKeyEvent((Component)pDateField, '1');
        Util.sleep(1);
        SwingUtil.dispatchKeyEvent((Component)pDateField, '2');
        Util.sleep(1);
        SwingUtil.dispatchKeyEvent((Component)pDateField, '3');
        Util.sleep(1);
        SwingUtil.dispatchKeyEvent((Component)pDateField, '4');
        Util.sleep(1);
        SwingUtil.dispatchKeyEvent((Component)pDateField, '0');
        Util.sleep(1);
        this.bugIf(!pDateField.getText().startsWith("1234-0"), "Date did not start with '1234-0' but is '" + pDateField.getText() + "'!");
        String sDate = "1998-12-22";
        pDateField.setText(sDate);
        this.bugIf(!pDateField.isDateValid(), "Date " + sDate + " should be valid!");
        sDate = "1999-11-31";
        this.bugIf(Util.isDateValid(sDate), "Date " + sDate + " shouldn't be valid!");
        SwingUtil.dispatchKeyEvent((Component)pDateField, 8);
        Util.sleep(1);
        this.bugIf(!pDateField.getText().equals(""), "Date field wasn't deleted!");
        frmMain.setVisible(false);
        frmMain.dispose();
    }

    public static void main(String[] asArg_) {
        DateFieldTest pTest = new DateFieldTest();
        Test.printResult(pTest);
        System.exit(0);
    }
}

