/*
 * Decompiled with CFR 0.152.
 */
package ccl.swing;

import ccl.util.FileUtil;
import ccl.util.Util;
import com.sun.image.codec.jpeg.JPEGCodec;
import com.sun.image.codec.jpeg.JPEGEncodeParam;
import com.sun.image.codec.jpeg.JPEGImageEncoder;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.DataBuffer;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.swing.ImageIcon;
import javax.swing.SwingUtilities;
import net.jmge.gif.Gif89Encoder;

public class GraphicsUtil {
    static /* synthetic */ Class class$ccl$swing$GraphicsUtil;

    private GraphicsUtil() {
    }

    public static void saveImageAsJpeg(String filename, Image image) throws IOException {
        GraphicsUtil.saveImageAsJPEG(filename, image);
    }

    public static void saveImageAsJPEG(String filename, Image image) throws IOException {
        if (image instanceof BufferedImage) {
            GraphicsUtil.saveImageAsJPEG(filename, (BufferedImage)image);
        } else {
            BufferedImage bufferedImage = new BufferedImage(image.getWidth(null), image.getHeight(null), 1);
            Graphics2D graphics2D = bufferedImage.createGraphics();
            graphics2D.drawImage(image, 0, 0, image.getWidth(null), image.getHeight(null), null);
            GraphicsUtil.saveImageAsJPEG(filename, bufferedImage);
            bufferedImage.flush();
        }
    }

    public static void saveImageAsJpeg(String filename, BufferedImage bufferedImage) throws IOException {
        GraphicsUtil.saveImageAsJPEG(filename, bufferedImage);
    }

    public static void saveImageAsJPEG(String filename, BufferedImage bufferedImage) throws IOException {
        BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(FileUtil.normalizeFileName(filename)));
        JPEGImageEncoder encoder = JPEGCodec.createJPEGEncoder((OutputStream)out);
        JPEGEncodeParam param = encoder.getDefaultJPEGEncodeParam(bufferedImage);
        float quality = 100.0f;
        param.setQuality(quality / 100.0f, false);
        encoder.setJPEGEncodeParam(param);
        encoder.encode(bufferedImage);
        out.close();
    }

    public static void saveComponentAsJpeg(String filename, Component component, Container container) throws IOException {
        GraphicsUtil.saveComponentAsJPEG(filename, component, container);
    }

    public static void saveComponentAsJPEG(String filename, Component component, Container container) throws IOException {
        BufferedImage bufferedImage = GraphicsUtil.componentToImage(component, container);
        GraphicsUtil.saveImageAsJpeg(filename, bufferedImage);
        bufferedImage.flush();
    }

    public static BufferedImage componentToImage(Component component, Container container) throws IOException {
        Rectangle recComponent = component.getBounds();
        BufferedImage bufferedImage = new BufferedImage(recComponent.width, recComponent.height, 1);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        SwingUtilities.paintComponent(graphics2D, component, container, 0, 0, recComponent.width, recComponent.height);
        return bufferedImage;
    }

    public static BufferedImage crop(Image image, int x, int y, int width, int height) {
        BufferedImage bufferedImage = null;
        bufferedImage = !(image instanceof BufferedImage) ? GraphicsUtil.createBufferedImage(image) : (BufferedImage)image;
        return GraphicsUtil.crop(bufferedImage, x, y, width, height);
    }

    public static BufferedImage crop(BufferedImage bufferedImage, int x, int y, int width, int height) {
        BufferedImage retImage = new BufferedImage(width, height, 1);
        Graphics2D g = retImage.createGraphics();
        AffineTransform t = AffineTransform.getTranslateInstance(-x, -y);
        g.transform(t);
        g.drawImage(bufferedImage, null, 0, 0);
        return retImage;
    }

    public static void saveImageAsGIF(String filename, BufferedImage image) throws IOException {
        Gif89Encoder gifenc = new Gif89Encoder((Image)image);
        gifenc.setTransparentIndex(-1);
        gifenc.getFrameAt(0).setInterlaced(false);
        BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(FileUtil.normalizeFileName(filename)));
        gifenc.encode((OutputStream)out);
        out.close();
    }

    public static void saveImageAsGIF(String filename, Image image) throws IOException {
        if (image instanceof BufferedImage) {
            GraphicsUtil.saveImageAsGIF(filename, (BufferedImage)image);
        } else {
            BufferedImage bufferedImage = new BufferedImage(image.getWidth(null), image.getHeight(null), 1);
            Graphics2D graphics2D = bufferedImage.createGraphics();
            graphics2D.drawImage(image, 0, 0, image.getWidth(null), image.getHeight(null), null);
            GraphicsUtil.saveImageAsGIF(filename, bufferedImage);
            bufferedImage.flush();
        }
    }

    public static BufferedImage createBufferedImage(Image image) {
        BufferedImage bufferedImage = new BufferedImage(image.getWidth(null), image.getHeight(null), 1);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.drawImage(image, 0, 0, image.getWidth(null), image.getHeight(null), null);
        return bufferedImage;
    }

    public static boolean equals(ImageIcon iconA, ImageIcon iconB) {
        if (iconA == null && iconB == null) {
            return true;
        }
        if (iconA == null || iconB == null) {
            return false;
        }
        if (iconA.getIconWidth() != iconB.getIconWidth() || iconA.getIconHeight() != iconB.getIconHeight()) {
            return false;
        }
        return GraphicsUtil.equals(iconA.getImage(), iconB.getImage());
    }

    public static boolean equals(Image imageA, Image imageB) {
        if (imageA == null && imageB == null) {
            return true;
        }
        if (imageA == null || imageB == null) {
            return false;
        }
        if (imageA.getWidth(null) != imageB.getWidth(null) || imageA.getHeight(null) != imageB.getHeight(null)) {
            return false;
        }
        BufferedImage bufferedImageA = null;
        BufferedImage bufferedImageB = null;
        bufferedImageA = imageA instanceof BufferedImage ? (BufferedImage)imageA : GraphicsUtil.createBufferedImage(imageA);
        bufferedImageB = imageB instanceof BufferedImage ? (BufferedImage)imageB : GraphicsUtil.createBufferedImage(imageB);
        return GraphicsUtil.equals(bufferedImageA, bufferedImageB);
    }

    public static boolean equals(BufferedImage imageA, BufferedImage imageB) {
        Util.debug(class$ccl$swing$GraphicsUtil == null ? (class$ccl$swing$GraphicsUtil = GraphicsUtil.class$("ccl.swing.GraphicsUtil")) : class$ccl$swing$GraphicsUtil, (Object)"equals(..).ENTER");
        if (imageA == null && imageB == null) {
            return true;
        }
        if (imageA == null || imageB == null) {
            return false;
        }
        if (imageA.getWidth(null) != imageB.getWidth(null) || imageA.getHeight(null) != imageB.getHeight(null)) {
            return false;
        }
        WritableRaster rasterA = imageA.getRaster();
        WritableRaster rasterB = imageB.getRaster();
        SampleModel sampleModelA = rasterA.getSampleModel();
        SampleModel sampleModelB = rasterB.getSampleModel();
        DataBuffer dataBufferA = rasterA.getDataBuffer();
        DataBuffer dataBufferB = rasterB.getDataBuffer();
        int imageWidth = imageA.getWidth(null);
        int imageHeight = imageA.getHeight(null);
        int y = 0;
        while (y < imageHeight) {
            int x = 0;
            while (x < imageWidth) {
                int[] pixelB;
                int[] pix = null;
                int[] pixelA = sampleModelA.getPixel(x, y, pix, dataBufferA);
                if (pixelA.length != (pixelB = sampleModelB.getPixel(x, y, pix, dataBufferB)).length) {
                    return false;
                }
                int pixel = 0;
                while (pixel < pixelA.length) {
                    Util.debug(class$ccl$swing$GraphicsUtil == null ? GraphicsUtil.class$("ccl.swing.GraphicsUtil") : class$ccl$swing$GraphicsUtil, (Object)("equals(..).pixelA[" + x + "," + y + "," + pixel + "]: " + pixelA[pixel]));
                    Util.debug(class$ccl$swing$GraphicsUtil == null ? GraphicsUtil.class$("ccl.swing.GraphicsUtil") : class$ccl$swing$GraphicsUtil, (Object)("equals(..).pixelB[" + x + "," + y + "," + pixel + "]: " + pixelB[pixel]));
                    if (pixelA[pixel] != pixelB[pixel]) {
                        return false;
                    }
                    ++pixel;
                }
                ++x;
            }
            ++y;
        }
        Util.debug(class$ccl$swing$GraphicsUtil == null ? (class$ccl$swing$GraphicsUtil = GraphicsUtil.class$("ccl.swing.GraphicsUtil")) : class$ccl$swing$GraphicsUtil, (Object)"equals(..).EXIT");
        return true;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

