/*
 * Decompiled with CFR 0.152.
 */
package javax.xml.bind.annotation.adapters;

import javax.xml.bind.annotation.adapters.XmlAdapter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class NormalizedStringAdapter
extends XmlAdapter<String, String> {
    @Override
    public String unmarshal(String string) {
        int n;
        if (string == null) {
            return null;
        }
        for (n = string.length() - 1; n >= 0 && !NormalizedStringAdapter.isWhiteSpaceExceptSpace(string.charAt(n)); --n) {
        }
        if (n < 0) {
            return string;
        }
        char[] cArray = string.toCharArray();
        cArray[n--] = 32;
        while (n >= 0) {
            if (NormalizedStringAdapter.isWhiteSpaceExceptSpace(cArray[n])) {
                cArray[n] = 32;
            }
            --n;
        }
        return new String(cArray);
    }

    @Override
    public String marshal(String string) {
        return string;
    }

    protected static boolean isWhiteSpaceExceptSpace(char c) {
        if (c >= ' ') {
            return false;
        }
        return c == '\t' || c == '\n' || c == '\r';
    }
}

