/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import javax.media.j3d.NnuId;
import javax.media.j3d.NnuIdManager;

class CachedTargets {
    static String[] typeString = new String[]{"GEO_TARGETS", "ENV_TARGETS", "BEH_TARGETS", "SND_TARGETS", "VPF_TARGETS", "BLN_TARGETS", "GRP_TARGETS"};
    static int[] updateTargetThreads = new int[]{8384, 4224, 256, 514, 898, 4992, 8256};
    NnuId[][] targetArr = new NnuId[7][];

    CachedTargets() {
    }

    int computeTargetThreads() {
        int n = 0;
        int n2 = 0;
        while (n2 < 7) {
            if (this.targetArr[n2] != null) {
                n |= updateTargetThreads[n2];
            }
            ++n2;
        }
        return n;
    }

    void copy(CachedTargets cachedTargets) {
        int n = 0;
        while (n < 7) {
            this.targetArr[n] = cachedTargets.targetArr[n];
            ++n;
        }
    }

    void replace(NnuId nnuId, NnuId nnuId2, int n) {
        NnuId[] nnuIdArray = new NnuId[this.targetArr[n].length];
        System.arraycopy(this.targetArr[n], 0, nnuIdArray, 0, this.targetArr[n].length);
        this.targetArr[n] = nnuIdArray;
        NnuIdManager.replace(nnuId, nnuId2, this.targetArr[n]);
    }

    void dump() {
        int n = 0;
        while (n < 7) {
            if (this.targetArr[n] != null) {
                System.out.println("  " + typeString[n]);
                int n2 = 0;
                while (n2 < this.targetArr[n].length) {
                    System.out.println("  " + this.targetArr[n][n2]);
                    ++n2;
                }
            }
            ++n;
        }
    }
}

