/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.objects;

import it.unimi.dsi.fastutil.AbstractPriorityQueue;
import it.unimi.dsi.fastutil.objects.ObjectArrays;
import java.util.Comparator;
import java.util.NoSuchElementException;

public class ObjectArrayFIFOQueue<K>
extends AbstractPriorityQueue<K> {
    public static final int INITIAL_CAPACITY = 16;
    protected K[] array = ObjectArrays.EMPTY_ARRAY;
    protected int length;
    protected int start;
    protected int end;

    public ObjectArrayFIFOQueue(int capacity) {
        if (capacity > 0) {
            this.array = new Object[capacity];
        }
        this.length = this.array.length;
    }

    public ObjectArrayFIFOQueue() {
        this(16);
    }

    @Override
    public Comparator<? super K> comparator() {
        return null;
    }

    @Override
    public K dequeue() {
        if (this.start == this.end) {
            throw new NoSuchElementException();
        }
        K t = this.array[this.start];
        this.array[this.start] = null;
        if (++this.start == this.length) {
            this.start = 0;
        }
        return t;
    }

    public K dequeueLast() {
        if (this.start == this.end) {
            throw new NoSuchElementException();
        }
        if (this.end == 0) {
            this.end = this.length;
        }
        K t = this.array[--this.end];
        this.array[this.end] = null;
        return t;
    }

    private final void expand() {
        K[] newArray = ObjectArrays.grow(this.array, this.length + 1, 0);
        System.arraycopy(this.array, this.start, newArray, 0, this.length - this.start);
        System.arraycopy(this.array, 0, newArray, this.length - this.start, this.end);
        this.start = 0;
        this.end = this.length;
        this.array = newArray;
        this.length = newArray.length;
    }

    @Override
    public void enqueue(K x) {
        this.array[this.end++] = x;
        if (this.end == this.length) {
            this.end = 0;
        }
        if (this.end == this.start) {
            this.expand();
        }
    }

    public void enqueueFirst(K x) {
        if (this.start == 0) {
            this.start = this.length;
        }
        this.array[--this.start] = x;
        if (this.end == this.start) {
            this.expand();
        }
    }

    @Override
    public K first() {
        if (this.start == this.end) {
            throw new NoSuchElementException();
        }
        return this.array[this.start];
    }

    @Override
    public K last() {
        if (this.start == this.end) {
            throw new NoSuchElementException();
        }
        return this.array[(this.end == 0 ? this.length : this.end) - 1];
    }

    @Override
    public void clear() {
        if (this.start <= this.end) {
            ObjectArrays.fill(this.array, this.start, this.end, null);
        } else {
            ObjectArrays.fill(this.array, this.start, this.length, null);
            ObjectArrays.fill(this.array, 0, this.end, null);
        }
        this.end = 0;
        this.start = 0;
    }

    public void trim() {
        int size = this.size();
        Object[] newArray = new Object[size + 1];
        if (this.start <= this.end) {
            System.arraycopy(this.array, this.start, newArray, 0, this.end - this.start);
        } else {
            System.arraycopy(this.array, this.start, newArray, 0, this.length - this.start);
            System.arraycopy(this.array, 0, newArray, this.length - this.start, this.end);
        }
        this.start = 0;
        this.end = size;
        this.length = this.end + 1;
        this.array = newArray;
    }

    @Override
    public int size() {
        int apparentLength = this.end - this.start;
        return apparentLength >= 0 ? apparentLength : this.length + apparentLength;
    }
}

