/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.floats;

import it.unimi.dsi.fastutil.Hash;
import it.unimi.dsi.fastutil.HashCommon;
import it.unimi.dsi.fastutil.booleans.BooleanArrays;
import it.unimi.dsi.fastutil.floats.AbstractFloat2LongMap;
import it.unimi.dsi.fastutil.floats.AbstractFloatSet;
import it.unimi.dsi.fastutil.floats.Float2LongMap;
import it.unimi.dsi.fastutil.floats.FloatIterator;
import it.unimi.dsi.fastutil.floats.FloatSet;
import it.unimi.dsi.fastutil.longs.AbstractLongCollection;
import it.unimi.dsi.fastutil.longs.LongCollection;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.objects.AbstractObjectSet;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Map;
import java.util.NoSuchElementException;

public class Float2LongOpenHashMap
extends AbstractFloat2LongMap
implements Serializable,
Cloneable,
Hash {
    public static final long serialVersionUID = 0L;
    private static final boolean ASSERTS = false;
    protected transient float[] key;
    protected transient long[] value;
    protected transient boolean[] used;
    protected final float f;
    protected transient int n;
    protected transient int maxFill;
    protected transient int mask;
    protected int size;
    protected volatile transient Float2LongMap.FastEntrySet entries;
    protected volatile transient FloatSet keys;
    protected volatile transient LongCollection values;

    public Float2LongOpenHashMap(int expected, float f) {
        if (f <= 0.0f || f > 1.0f) {
            throw new IllegalArgumentException("Load factor must be greater than 0 and smaller than or equal to 1");
        }
        if (expected < 0) {
            throw new IllegalArgumentException("The expected number of elements must be nonnegative");
        }
        this.f = f;
        this.n = HashCommon.arraySize(expected, f);
        this.mask = this.n - 1;
        this.maxFill = HashCommon.maxFill(this.n, f);
        this.key = new float[this.n];
        this.value = new long[this.n];
        this.used = new boolean[this.n];
    }

    public Float2LongOpenHashMap(int expected) {
        this(expected, 0.75f);
    }

    public Float2LongOpenHashMap() {
        this(16, 0.75f);
    }

    public Float2LongOpenHashMap(Map<? extends Float, ? extends Long> m, float f) {
        this(m.size(), f);
        this.putAll(m);
    }

    public Float2LongOpenHashMap(Map<? extends Float, ? extends Long> m) {
        this(m, 0.75f);
    }

    public Float2LongOpenHashMap(Float2LongMap m, float f) {
        this(m.size(), f);
        this.putAll(m);
    }

    public Float2LongOpenHashMap(Float2LongMap m) {
        this(m, 0.75f);
    }

    public Float2LongOpenHashMap(float[] k, long[] v, float f) {
        this(k.length, f);
        if (k.length != v.length) {
            throw new IllegalArgumentException("The key array and the value array have different lengths (" + k.length + " and " + v.length + ")");
        }
        for (int i = 0; i < k.length; ++i) {
            this.put(k[i], v[i]);
        }
    }

    public Float2LongOpenHashMap(float[] k, long[] v) {
        this(k, v, 0.75f);
    }

    @Override
    public long put(float k, long v) {
        int pos = HashCommon.murmurHash3(HashCommon.float2int(k)) & this.mask;
        while (this.used[pos]) {
            if (this.key[pos] == k) {
                long oldValue = this.value[pos];
                this.value[pos] = v;
                return oldValue;
            }
            pos = pos + 1 & this.mask;
        }
        this.used[pos] = true;
        this.key[pos] = k;
        this.value[pos] = v;
        if (++this.size >= this.maxFill) {
            this.rehash(HashCommon.arraySize(this.size + 1, this.f));
        }
        return this.defRetValue;
    }

    @Override
    public Long put(Float ok, Long ov) {
        long v = ov;
        float k = ok.floatValue();
        int pos = HashCommon.murmurHash3(HashCommon.float2int(k)) & this.mask;
        while (this.used[pos]) {
            if (this.key[pos] == k) {
                Long oldValue = this.value[pos];
                this.value[pos] = v;
                return oldValue;
            }
            pos = pos + 1 & this.mask;
        }
        this.used[pos] = true;
        this.key[pos] = k;
        this.value[pos] = v;
        if (++this.size >= this.maxFill) {
            this.rehash(HashCommon.arraySize(this.size + 1, this.f));
        }
        return null;
    }

    public long add(float k, long incr) {
        int pos = HashCommon.murmurHash3(HashCommon.float2int(k)) & this.mask;
        while (this.used[pos]) {
            if (this.key[pos] == k) {
                long oldValue = this.value[pos];
                int n = pos;
                this.value[n] = this.value[n] + incr;
                return oldValue;
            }
            pos = pos + 1 & this.mask;
        }
        this.used[pos] = true;
        this.key[pos] = k;
        this.value[pos] = this.defRetValue + incr;
        if (++this.size >= this.maxFill) {
            this.rehash(HashCommon.arraySize(this.size + 1, this.f));
        }
        return this.defRetValue;
    }

    protected final int shiftKeys(int pos) {
        int last;
        while (true) {
            last = pos;
            pos = last + 1 & this.mask;
            while (this.used[pos]) {
                int slot = HashCommon.murmurHash3(HashCommon.float2int(this.key[pos])) & this.mask;
                if (last <= pos ? last >= slot || slot > pos : last >= slot && slot > pos) break;
                pos = pos + 1 & this.mask;
            }
            if (!this.used[pos]) break;
            this.key[last] = this.key[pos];
            this.value[last] = this.value[pos];
        }
        this.used[last] = false;
        return last;
    }

    @Override
    public long remove(float k) {
        int pos = HashCommon.murmurHash3(HashCommon.float2int(k)) & this.mask;
        while (this.used[pos]) {
            if (this.key[pos] == k) {
                --this.size;
                long v = this.value[pos];
                this.shiftKeys(pos);
                return v;
            }
            pos = pos + 1 & this.mask;
        }
        return this.defRetValue;
    }

    @Override
    public Long remove(Object ok) {
        float k = ((Float)ok).floatValue();
        int pos = HashCommon.murmurHash3(HashCommon.float2int(k)) & this.mask;
        while (this.used[pos]) {
            if (this.key[pos] == k) {
                --this.size;
                long v = this.value[pos];
                this.shiftKeys(pos);
                return v;
            }
            pos = pos + 1 & this.mask;
        }
        return null;
    }

    public Long get(Float ok) {
        float k = ok.floatValue();
        int pos = HashCommon.murmurHash3(HashCommon.float2int(k)) & this.mask;
        while (this.used[pos]) {
            if (this.key[pos] == k) {
                return this.value[pos];
            }
            pos = pos + 1 & this.mask;
        }
        return null;
    }

    @Override
    public long get(float k) {
        int pos = HashCommon.murmurHash3(HashCommon.float2int(k)) & this.mask;
        while (this.used[pos]) {
            if (this.key[pos] == k) {
                return this.value[pos];
            }
            pos = pos + 1 & this.mask;
        }
        return this.defRetValue;
    }

    @Override
    public boolean containsKey(float k) {
        int pos = HashCommon.murmurHash3(HashCommon.float2int(k)) & this.mask;
        while (this.used[pos]) {
            if (this.key[pos] == k) {
                return true;
            }
            pos = pos + 1 & this.mask;
        }
        return false;
    }

    @Override
    public boolean containsValue(long v) {
        long[] value = this.value;
        boolean[] used = this.used;
        int i = this.n;
        while (i-- != 0) {
            if (!used[i] || value[i] != v) continue;
            return true;
        }
        return false;
    }

    @Override
    public void clear() {
        if (this.size == 0) {
            return;
        }
        this.size = 0;
        BooleanArrays.fill(this.used, false);
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Deprecated
    public void growthFactor(int growthFactor) {
    }

    @Deprecated
    public int growthFactor() {
        return 16;
    }

    public Float2LongMap.FastEntrySet float2LongEntrySet() {
        if (this.entries == null) {
            this.entries = new MapEntrySet();
        }
        return this.entries;
    }

    @Override
    public FloatSet keySet() {
        if (this.keys == null) {
            this.keys = new KeySet();
        }
        return this.keys;
    }

    @Override
    public LongCollection values() {
        if (this.values == null) {
            this.values = new AbstractLongCollection(){

                @Override
                public LongIterator iterator() {
                    return new ValueIterator();
                }

                @Override
                public int size() {
                    return Float2LongOpenHashMap.this.size;
                }

                @Override
                public boolean contains(long v) {
                    return Float2LongOpenHashMap.this.containsValue(v);
                }

                @Override
                public void clear() {
                    Float2LongOpenHashMap.this.clear();
                }
            };
        }
        return this.values;
    }

    @Deprecated
    public boolean rehash() {
        return true;
    }

    public boolean trim() {
        int l = HashCommon.arraySize(this.size, this.f);
        if (l >= this.n) {
            return true;
        }
        try {
            this.rehash(l);
        }
        catch (OutOfMemoryError cantDoIt) {
            return false;
        }
        return true;
    }

    public boolean trim(int n) {
        int l = HashCommon.nextPowerOfTwo((int)Math.ceil((float)n / this.f));
        if (this.n <= l) {
            return true;
        }
        try {
            this.rehash(l);
        }
        catch (OutOfMemoryError cantDoIt) {
            return false;
        }
        return true;
    }

    protected void rehash(int newN) {
        int i = 0;
        boolean[] used = this.used;
        float[] key = this.key;
        long[] value = this.value;
        int newMask = newN - 1;
        float[] newKey = new float[newN];
        long[] newValue = new long[newN];
        boolean[] newUsed = new boolean[newN];
        int j = this.size;
        while (j-- != 0) {
            while (!used[i]) {
                ++i;
            }
            float k = key[i];
            int pos = HashCommon.murmurHash3(HashCommon.float2int(k)) & newMask;
            while (newUsed[pos]) {
                pos = pos + 1 & newMask;
            }
            newUsed[pos] = true;
            newKey[pos] = k;
            newValue[pos] = value[i];
            ++i;
        }
        this.n = newN;
        this.mask = newMask;
        this.maxFill = HashCommon.maxFill(this.n, this.f);
        this.key = newKey;
        this.value = newValue;
        this.used = newUsed;
    }

    public Float2LongOpenHashMap clone() {
        Float2LongOpenHashMap c;
        try {
            c = (Float2LongOpenHashMap)super.clone();
        }
        catch (CloneNotSupportedException cantHappen) {
            throw new InternalError();
        }
        c.keys = null;
        c.values = null;
        c.entries = null;
        c.key = (float[])this.key.clone();
        c.value = (long[])this.value.clone();
        c.used = (boolean[])this.used.clone();
        return c;
    }

    @Override
    public int hashCode() {
        int h = 0;
        int j = this.size;
        int i = 0;
        int t = 0;
        while (j-- != 0) {
            while (!this.used[i]) {
                ++i;
            }
            t = HashCommon.float2int(this.key[i]);
            h += (t ^= HashCommon.long2int(this.value[i]));
            ++i;
        }
        return h;
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        float[] key = this.key;
        long[] value = this.value;
        MapIterator i = new MapIterator();
        s.defaultWriteObject();
        int j = this.size;
        while (j-- != 0) {
            int e = i.nextEntry();
            s.writeFloat(key[e]);
            s.writeLong(value[e]);
        }
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        this.n = HashCommon.arraySize(this.size, this.f);
        this.maxFill = HashCommon.maxFill(this.n, this.f);
        this.mask = this.n - 1;
        this.key = new float[this.n];
        float[] key = this.key;
        this.value = new long[this.n];
        long[] value = this.value;
        this.used = new boolean[this.n];
        boolean[] used = this.used;
        int i = this.size;
        int pos = 0;
        while (i-- != 0) {
            float k = s.readFloat();
            long v = s.readLong();
            pos = HashCommon.murmurHash3(HashCommon.float2int(k)) & this.mask;
            while (used[pos]) {
                pos = pos + 1 & this.mask;
            }
            used[pos] = true;
            key[pos] = k;
            value[pos] = v;
        }
    }

    private void checkTable() {
    }

    private final class ValueIterator
    extends MapIterator
    implements LongIterator {
        @Override
        public long nextLong() {
            return Float2LongOpenHashMap.this.value[this.nextEntry()];
        }

        @Override
        public Long next() {
            return Float2LongOpenHashMap.this.value[this.nextEntry()];
        }
    }

    private final class KeySet
    extends AbstractFloatSet {
        private KeySet() {
        }

        @Override
        public FloatIterator iterator() {
            return new KeyIterator();
        }

        @Override
        public int size() {
            return Float2LongOpenHashMap.this.size;
        }

        @Override
        public boolean contains(float k) {
            return Float2LongOpenHashMap.this.containsKey(k);
        }

        @Override
        public boolean remove(float k) {
            int oldSize = Float2LongOpenHashMap.this.size;
            Float2LongOpenHashMap.this.remove(k);
            return Float2LongOpenHashMap.this.size != oldSize;
        }

        @Override
        public void clear() {
            Float2LongOpenHashMap.this.clear();
        }
    }

    private final class KeyIterator
    extends MapIterator
    implements FloatIterator {
        @Override
        public float nextFloat() {
            return Float2LongOpenHashMap.this.key[this.nextEntry()];
        }

        @Override
        public Float next() {
            return Float.valueOf(Float2LongOpenHashMap.this.key[this.nextEntry()]);
        }
    }

    private final class MapEntrySet
    extends AbstractObjectSet<Float2LongMap.Entry>
    implements Float2LongMap.FastEntrySet {
        private MapEntrySet() {
        }

        @Override
        public ObjectIterator<Float2LongMap.Entry> iterator() {
            return new EntryIterator();
        }

        @Override
        public ObjectIterator<Float2LongMap.Entry> fastIterator() {
            return new FastEntryIterator();
        }

        @Override
        public boolean contains(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            float k = ((Float)e.getKey()).floatValue();
            int pos = HashCommon.murmurHash3(HashCommon.float2int(k)) & Float2LongOpenHashMap.this.mask;
            while (Float2LongOpenHashMap.this.used[pos]) {
                if (Float2LongOpenHashMap.this.key[pos] == k) {
                    return Float2LongOpenHashMap.this.value[pos] == (Long)e.getValue();
                }
                pos = pos + 1 & Float2LongOpenHashMap.this.mask;
            }
            return false;
        }

        @Override
        public boolean remove(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            float k = ((Float)e.getKey()).floatValue();
            int pos = HashCommon.murmurHash3(HashCommon.float2int(k)) & Float2LongOpenHashMap.this.mask;
            while (Float2LongOpenHashMap.this.used[pos]) {
                if (Float2LongOpenHashMap.this.key[pos] == k) {
                    Float2LongOpenHashMap.this.remove(e.getKey());
                    return true;
                }
                pos = pos + 1 & Float2LongOpenHashMap.this.mask;
            }
            return false;
        }

        @Override
        public int size() {
            return Float2LongOpenHashMap.this.size;
        }

        @Override
        public void clear() {
            Float2LongOpenHashMap.this.clear();
        }
    }

    private class FastEntryIterator
    extends MapIterator
    implements ObjectIterator<Float2LongMap.Entry> {
        final AbstractFloat2LongMap.BasicEntry entry;

        private FastEntryIterator() {
            this.entry = new AbstractFloat2LongMap.BasicEntry(0.0f, 0L);
        }

        @Override
        public AbstractFloat2LongMap.BasicEntry next() {
            int e = this.nextEntry();
            this.entry.key = Float2LongOpenHashMap.this.key[e];
            this.entry.value = Float2LongOpenHashMap.this.value[e];
            return this.entry;
        }
    }

    private class EntryIterator
    extends MapIterator
    implements ObjectIterator<Float2LongMap.Entry> {
        private MapEntry entry;

        private EntryIterator() {
        }

        @Override
        public Float2LongMap.Entry next() {
            this.entry = new MapEntry(this.nextEntry());
            return this.entry;
        }

        @Override
        public void remove() {
            super.remove();
            this.entry.index = -1;
        }
    }

    private class MapIterator {
        int pos;
        int last;
        int c;

        private MapIterator() {
            this.pos = Float2LongOpenHashMap.this.n;
            this.last = -1;
            this.c = Float2LongOpenHashMap.this.size;
            boolean[] used = Float2LongOpenHashMap.this.used;
            if (this.c != 0) {
                while (!used[--this.pos]) {
                }
            }
        }

        public boolean hasNext() {
            return this.c != 0;
        }

        public int nextEntry() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.last = this.pos;
            if (--this.c != 0) {
                boolean[] used = Float2LongOpenHashMap.this.used;
                while (!used[this.pos = this.pos - 1 & Float2LongOpenHashMap.this.mask]) {
                }
            }
            return this.last;
        }

        public void remove() {
            if (this.last == -1) {
                throw new IllegalStateException();
            }
            --Float2LongOpenHashMap.this.size;
            if (Float2LongOpenHashMap.this.shiftKeys(this.last) == this.pos && this.c > 0) {
                ++this.c;
                this.nextEntry();
            }
            this.last = -1;
        }

        public int skip(int n) {
            int i = n;
            while (i-- != 0 && this.hasNext()) {
                this.nextEntry();
            }
            return n - i - 1;
        }
    }

    private final class MapEntry
    implements Float2LongMap.Entry,
    Map.Entry<Float, Long> {
        private int index;

        MapEntry(int index) {
            this.index = index;
        }

        @Override
        public Float getKey() {
            return Float.valueOf(Float2LongOpenHashMap.this.key[this.index]);
        }

        @Override
        public float getFloatKey() {
            return Float2LongOpenHashMap.this.key[this.index];
        }

        @Override
        public Long getValue() {
            return Float2LongOpenHashMap.this.value[this.index];
        }

        @Override
        public long getLongValue() {
            return Float2LongOpenHashMap.this.value[this.index];
        }

        @Override
        public long setValue(long v) {
            long oldValue = Float2LongOpenHashMap.this.value[this.index];
            Float2LongOpenHashMap.this.value[this.index] = v;
            return oldValue;
        }

        @Override
        public Long setValue(Long v) {
            return this.setValue((long)v);
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            return Float2LongOpenHashMap.this.key[this.index] == ((Float)e.getKey()).floatValue() && Float2LongOpenHashMap.this.value[this.index] == (Long)e.getValue();
        }

        @Override
        public int hashCode() {
            return HashCommon.float2int(Float2LongOpenHashMap.this.key[this.index]) ^ HashCommon.long2int(Float2LongOpenHashMap.this.value[this.index]);
        }

        public String toString() {
            return Float2LongOpenHashMap.this.key[this.index] + "=>" + Float2LongOpenHashMap.this.value[this.index];
        }
    }
}

