/*
 * Decompiled with CFR 0.152.
 */
package it.tidalwave.util.spi;

import it.tidalwave.util.Finder;
import it.tidalwave.util.NotFoundException;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class FinderSupport<Type, ExtendedFinder extends Finder<Type>>
implements Finder<Type>,
Cloneable {
    @Nonnull
    private String name;
    @Nonnegative
    protected int firstResult = 0;
    @Nonnegative
    protected int maxResults = 9999999;
    @Nonnull
    protected List<Sorter<Type>> sorters = new ArrayList<Sorter<Type>>();

    protected FinderSupport(@Nonnull String name) {
        this.name = name;
    }

    protected FinderSupport() {
        this.name = this.getClass().getName();
    }

    @Nonnull
    public FinderSupport<Type, ExtendedFinder> clone() {
        try {
            FinderSupport clone = (FinderSupport)super.clone();
            clone.name = this.name;
            clone.firstResult = this.firstResult;
            clone.maxResults = this.maxResults;
            clone.sorters = new ArrayList<Sorter<Type>>(this.sorters);
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    @Nonnull
    public ExtendedFinder from(@Nonnegative int firstResult) {
        Object clone = this.clone();
        ((FinderSupport)clone).firstResult = firstResult;
        return (ExtendedFinder)clone;
    }

    @Nonnull
    public ExtendedFinder max(@Nonnegative int maxResults) {
        Object clone = this.clone();
        ((FinderSupport)clone).maxResults = maxResults;
        return (ExtendedFinder)clone;
    }

    @Override
    @Nonnull
    public <AnotherType> Finder<AnotherType> ofType(@Nonnull Class<AnotherType> type) {
        throw new UnsupportedOperationException("Must be eventually implemented by subclasses.");
    }

    @Nonnull
    public ExtendedFinder sort(@Nonnull Finder.SortCriterion criterion, @Nonnull Finder.SortDirection direction) {
        if (criterion instanceof Finder.FilterSortCriterion) {
            Object clone = this.clone();
            ((FinderSupport)clone).sorters.add(new Sorter((Finder.FilterSortCriterion)criterion, direction));
            return (ExtendedFinder)clone;
        }
        String message = String.format("%s does not implement %s - you need to subclass Finder and override sort()", criterion, Finder.FilterSortCriterion.class);
        throw new UnsupportedOperationException(message);
    }

    @Nonnull
    public final ExtendedFinder sort(@Nonnull Finder.SortCriterion criterion) {
        return this.sort(criterion, Finder.SortDirection.ASCENDING);
    }

    @Override
    @Nonnull
    public Type result() throws NotFoundException {
        List<Type> result = this.computeAndPostProcessResults();
        switch (result.size()) {
            case 0: {
                throw new NotFoundException(this.name);
            }
            case 1: {
                return result.get(0);
            }
        }
        throw new RuntimeException("More than one result, " + this.name + ": " + result);
    }

    @Override
    @Nonnull
    public Type firstResult() throws NotFoundException {
        return NotFoundException.throwWhenEmpty(this.computeAndPostProcessResults(), "Empty result").get(0);
    }

    @Override
    @Nonnull
    public List<? extends Type> results() {
        return this.computeAndPostProcessResults();
    }

    @Override
    @Nonnegative
    public int count() {
        return this.computeAndPostProcessResults().size();
    }

    @Nonnull
    public String toString() {
        return String.format("%s@%x[from: %d max: %d sorters: %s]", this.name, System.identityHashCode(this), this.firstResult, this.maxResults, this.sorters);
    }

    @Nonnull
    protected abstract List<? extends Type> computeResults();

    @Nonnull
    private List<? extends Type> computeAndPostProcessResults() {
        List<Type> results = this.computeResults();
        results = results.subList(this.firstResult, Math.min(results.size(), this.firstResult + this.maxResults));
        for (Sorter<Type> sorter : this.sorters) {
            sorter.sort(results);
        }
        return results;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class Sorter<Type> {
        private final Finder.FilterSortCriterion<Type> sortCriterion;
        private final Finder.SortDirection sortDirection;

        public Sorter(@Nonnull Finder.FilterSortCriterion<Type> sortCriterion, @Nonnull Finder.SortDirection sortDirection) {
            this.sortCriterion = sortCriterion;
            this.sortDirection = sortDirection;
        }

        public void sort(@Nonnull List<? extends Type> results) {
            this.sortCriterion.sort(results, this.sortDirection);
        }
    }
}

