/*
 * Decompiled with CFR 0.152.
 */
package it.tidalwave.role.spi;

import it.tidalwave.role.LocalizedDisplayable;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.annotation.Nonnull;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultDisplayable
implements LocalizedDisplayable,
Serializable {
    private static final long serialVersionUID = 45345436345634734L;
    @Nonnull
    private final String displayName;
    @Nonnull
    private final String toStringName;
    @Nonnull
    private final Map<Locale, String> displayNameMap = new HashMap<Locale, String>();
    private final Locale defaultLocale = Locale.ENGLISH;

    public DefaultDisplayable(@Nonnull String displayName) {
        this(displayName, "???");
    }

    public DefaultDisplayable(@Nonnull String displayName, @Nonnull String toStringName) {
        this.displayName = displayName;
        this.toStringName = toStringName;
        this.displayNameMap.put(this.defaultLocale, displayName);
    }

    @Override
    @Nonnull
    public String getDisplayName() {
        return this.displayName;
    }

    @Override
    @Nonnull
    public String getDisplayName(@Nonnull Locale locale) {
        return this.displayNameMap.get(locale);
    }

    @Override
    @Nonnull
    public SortedSet<Locale> getLocales() {
        return new TreeSet<Locale>(this.displayNameMap.keySet());
    }

    @Override
    @Nonnull
    public Map<Locale, String> getDisplayNames() {
        return Collections.unmodifiableMap(this.displayNameMap);
    }

    @Nonnull
    public String toString() {
        return String.format("%s@%x$Displayable[]", this.toStringName, System.identityHashCode(this));
    }
}

