/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.zipkin.gen;

import com.github.kristofa.brave.internal.Util;
import com.twitter.zipkin.gen.AnnotationType;
import com.twitter.zipkin.gen.Endpoint;
import java.io.Serializable;
import java.util.Arrays;

public class BinaryAnnotation
implements Serializable {
    static final long serialVersionUID = 1L;
    public final String key;
    public final byte[] value;
    public final AnnotationType type;
    public final Endpoint host;

    public static BinaryAnnotation address(String key, Endpoint endpoint) {
        return BinaryAnnotation.create(key, new byte[]{1}, AnnotationType.BOOL, Util.checkNotNull(endpoint, "endpoint", new Object[0]));
    }

    public static BinaryAnnotation create(String key, String value, Endpoint endpoint) {
        return BinaryAnnotation.create(key, value.getBytes(Util.UTF_8), AnnotationType.STRING, endpoint);
    }

    public static BinaryAnnotation create(String key, byte[] value, AnnotationType type, Endpoint endpoint) {
        return new BinaryAnnotation(key, value, type, endpoint);
    }

    BinaryAnnotation(String key, byte[] value, AnnotationType type, Endpoint host) {
        this.key = Util.checkNotBlank(key, "Null or blank key", new Object[0]);
        this.value = Util.checkNotNull(value, "Null value", new Object[0]);
        this.type = type;
        this.host = host;
    }

    public String getKey() {
        return this.key;
    }

    public byte[] getValue() {
        return this.value;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof BinaryAnnotation) {
            BinaryAnnotation that = (BinaryAnnotation)o;
            return this.key.equals(that.key) && Arrays.equals(this.value, that.value) && this.type.equals((Object)that.type) && Util.equal(this.host, that.host);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= this.key.hashCode();
        h *= 1000003;
        h ^= Arrays.hashCode(this.value);
        h *= 1000003;
        h ^= this.type.hashCode();
        h *= 1000003;
        return h ^= this.host == null ? 0 : this.host.hashCode();
    }
}

