/*
 * Decompiled with CFR 0.152.
 */
package com.github.kristofa.brave;

import com.github.kristofa.brave.internal.Util;
import java.nio.ByteBuffer;

public final class SpanId {
    public static final int FLAG_DEBUG = 1;
    public static final int FLAG_SAMPLING_SET = 2;
    public static final int FLAG_SAMPLED = 4;
    public static final int FLAG_IS_ROOT = 8;
    public final long traceIdHigh;
    public final long traceId;
    public final long parentId;
    public final long spanId;
    public final long flags;
    public final boolean shared;
    static final char[] HEX_DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    @Deprecated
    public static SpanId create(long traceId, long spanId, Long parentSpanId) {
        return SpanId.builder().traceId(traceId).parentId(parentSpanId).spanId(spanId).build();
    }

    @Deprecated
    public SpanId(long traceId, long parentId, long spanId, long flags) {
        this(new Builder().traceId(parentId == traceId ? parentId : traceId).parentId(parentId == spanId ? null : Long.valueOf(parentId)).spanId(spanId).flags(flags));
    }

    SpanId(Builder builder) {
        Util.checkNotNull(builder.spanId, "spanId", new Object[0]);
        this.traceIdHigh = builder.traceIdHigh;
        this.traceId = builder.traceId != null ? builder.traceId : builder.spanId;
        this.parentId = builder.nullableParentId != null ? builder.nullableParentId : this.traceId;
        this.spanId = builder.spanId;
        this.flags = builder.flags;
        this.shared = builder.shared;
    }

    public static SpanId fromBytes(byte[] bytes) {
        Util.checkNotNull(bytes, "bytes", new Object[0]);
        if (bytes.length != 32 && bytes.length != 40) {
            throw new IllegalArgumentException("bytes.length " + bytes.length + " != 32 or 40");
        }
        ByteBuffer buffer = ByteBuffer.wrap(bytes);
        Builder builder = new Builder();
        builder.spanId(buffer.getLong(0));
        builder.parentId(buffer.getLong(8));
        if (bytes.length == 32) {
            builder.traceId(buffer.getLong(16));
            builder.flags(buffer.getLong(24));
        } else {
            builder.traceIdHigh(buffer.getLong(16));
            builder.traceId(buffer.getLong(24));
            builder.flags(buffer.getLong(32));
        }
        return new SpanId(builder);
    }

    public static Builder builder() {
        return new Builder();
    }

    @Deprecated
    public long getTraceId() {
        return this.traceId;
    }

    @Deprecated
    public long getSpanId() {
        return this.spanId;
    }

    @Deprecated
    public Long getParentSpanId() {
        return this.nullableParentId();
    }

    public Long nullableParentId() {
        return this.root() ? null : Long.valueOf(this.parentId);
    }

    public final boolean root() {
        return (this.flags & 8L) == 8L || this.parentId == this.traceId && this.parentId == this.spanId;
    }

    public final boolean debug() {
        return (this.flags & 1L) == 1L;
    }

    public final Boolean sampled() {
        if (this.debug()) {
            return true;
        }
        return (this.flags & 2L) == 2L ? Boolean.valueOf((this.flags & 4L) == 4L) : null;
    }

    public byte[] bytes() {
        boolean traceHi = this.traceIdHigh != 0L;
        byte[] result = new byte[traceHi ? 40 : 32];
        ByteBuffer buffer = ByteBuffer.wrap(result);
        buffer.putLong(0, this.spanId);
        buffer.putLong(8, this.parentId);
        if (traceHi) {
            buffer.putLong(16, this.traceIdHigh);
            buffer.putLong(24, this.traceId);
            buffer.putLong(32, this.flags);
        } else {
            buffer.putLong(16, this.traceId);
            buffer.putLong(24, this.flags);
        }
        return result;
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public String toString() {
        boolean traceHi = this.traceIdHigh != 0L;
        char[] result = new char[(traceHi ? 4 : 3) * 16 + 3];
        int pos = 0;
        if (traceHi) {
            SpanId.writeHexLong(result, pos, this.traceIdHigh);
            pos += 16;
        }
        SpanId.writeHexLong(result, pos, this.traceId);
        pos += 16;
        result[pos++] = 46;
        SpanId.writeHexLong(result, pos, this.spanId);
        pos += 16;
        result[pos++] = 60;
        result[pos++] = 58;
        SpanId.writeHexLong(result, pos, this.parentId);
        return new String(result);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof SpanId) {
            SpanId that = (SpanId)o;
            return this.traceIdHigh == that.traceIdHigh && this.traceId == that.traceId && this.spanId == that.spanId;
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h = (int)((long)h ^ (this.traceIdHigh >>> 32 ^ this.traceIdHigh));
        h *= 1000003;
        h = (int)((long)h ^ (this.traceId >>> 32 ^ this.traceId));
        h *= 1000003;
        h = (int)((long)h ^ (this.spanId >>> 32 ^ this.spanId));
        return h;
    }

    public String traceIdString() {
        if (this.traceIdHigh != 0L) {
            char[] result = new char[32];
            SpanId.writeHexLong(result, 0, this.traceIdHigh);
            SpanId.writeHexLong(result, 16, this.traceId);
            return new String(result);
        }
        char[] result = new char[16];
        SpanId.writeHexLong(result, 0, this.traceId);
        return new String(result);
    }

    static void writeHexLong(char[] data, int pos, long v) {
        SpanId.writeHexByte(data, pos + 0, (byte)(v >>> 56 & 0xFFL));
        SpanId.writeHexByte(data, pos + 2, (byte)(v >>> 48 & 0xFFL));
        SpanId.writeHexByte(data, pos + 4, (byte)(v >>> 40 & 0xFFL));
        SpanId.writeHexByte(data, pos + 6, (byte)(v >>> 32 & 0xFFL));
        SpanId.writeHexByte(data, pos + 8, (byte)(v >>> 24 & 0xFFL));
        SpanId.writeHexByte(data, pos + 10, (byte)(v >>> 16 & 0xFFL));
        SpanId.writeHexByte(data, pos + 12, (byte)(v >>> 8 & 0xFFL));
        SpanId.writeHexByte(data, pos + 14, (byte)(v & 0xFFL));
    }

    static void writeHexByte(char[] data, int pos, byte b) {
        data[pos + 0] = HEX_DIGITS[b >> 4 & 0xF];
        data[pos + 1] = HEX_DIGITS[b & 0xF];
    }

    public static final class Builder {
        long traceIdHigh = 0L;
        Long traceId;
        Long nullableParentId;
        Long spanId;
        long flags;
        boolean shared;

        Builder(SpanId source) {
            this.traceIdHigh = source.traceIdHigh;
            this.traceId = source.traceId;
            this.nullableParentId = source.nullableParentId();
            this.spanId = source.spanId;
            this.flags = source.flags;
            this.shared = source.shared;
        }

        public Builder traceIdHigh(long traceIdHigh) {
            this.traceIdHigh = traceIdHigh;
            return this;
        }

        public Builder traceId(long traceId) {
            this.traceId = traceId;
            return this;
        }

        public Builder parentId(Long parentId) {
            this.flags = parentId == null ? (this.flags |= 8L) : (this.flags &= 0xFFFFFFFFFFFFFFF7L);
            this.nullableParentId = parentId;
            return this;
        }

        public Builder spanId(long spanId) {
            this.spanId = spanId;
            return this;
        }

        public Builder flags(long flags) {
            this.flags = flags;
            return this;
        }

        public Builder debug(boolean debug) {
            this.flags = debug ? (this.flags |= 1L) : (this.flags &= 0xFFFFFFFFFFFFFFFEL);
            return this;
        }

        public Builder shared(boolean shared) {
            this.shared = shared;
            return this;
        }

        public Builder sampled(Boolean sampled) {
            if (sampled != null) {
                this.flags |= 2L;
                this.flags = sampled.booleanValue() ? (this.flags |= 4L) : (this.flags &= 0xFFFFFFFFFFFFFFFBL);
            } else {
                this.flags &= 0xFFFFFFFFFFFFFFFDL;
            }
            return this;
        }

        public SpanId build() {
            return new SpanId(this);
        }

        Builder() {
        }
    }
}

