/*
 * Decompiled with CFR 0.152.
 */
package com.github.kristofa.brave;

import com.github.kristofa.brave.AutoValue_BraveRunnable;
import com.github.kristofa.brave.Brave;
import com.github.kristofa.brave.LocalSpanThreadBinder;
import com.github.kristofa.brave.ServerSpan;
import com.github.kristofa.brave.ServerSpanThreadBinder;
import com.github.kristofa.brave.internal.Util;
import com.twitter.zipkin.gen.Span;

public abstract class BraveRunnable
implements Runnable {
    public static BraveRunnable wrap(Runnable runnable, Brave brave) {
        Util.checkNotNull(brave, "brave", new Object[0]);
        return new AutoValue_BraveRunnable(runnable, brave.localSpanThreadBinder(), brave.localSpanThreadBinder().getCurrentLocalSpan(), brave.serverSpanThreadBinder(), brave.serverSpanThreadBinder().getCurrentServerSpan());
    }

    static BraveRunnable wrap(Runnable runnable, LocalSpanThreadBinder localSpanThreadBinder, ServerSpanThreadBinder serverSpanThreadBinder) {
        return new AutoValue_BraveRunnable(runnable, localSpanThreadBinder, localSpanThreadBinder.getCurrentLocalSpan(), serverSpanThreadBinder, serverSpanThreadBinder.getCurrentServerSpan());
    }

    @Deprecated
    public static BraveRunnable create(Runnable runnable, ServerSpanThreadBinder serverSpanThreadBinder) {
        Util.checkNotNull(serverSpanThreadBinder, "serverSpanThreadBinder", new Object[0]);
        return new AutoValue_BraveRunnable(runnable, null, null, serverSpanThreadBinder, serverSpanThreadBinder.getCurrentServerSpan());
    }

    abstract Runnable wrappedRunnable();

    abstract LocalSpanThreadBinder localSpanThreadBinder();

    abstract Span currentLocalSpan();

    abstract ServerSpanThreadBinder serverSpanThreadBinder();

    abstract ServerSpan currentServerSpan();

    @Override
    public void run() {
        if (this.localSpanThreadBinder() == null) {
            this.serverSpanThreadBinder().setCurrentSpan(this.currentServerSpan());
            this.wrappedRunnable().run();
            return;
        }
        ServerSpan previousServerSpan = this.serverSpanThreadBinder().getCurrentServerSpan();
        Span previousLocalSpan = this.localSpanThreadBinder().getCurrentLocalSpan();
        try {
            this.serverSpanThreadBinder().setCurrentSpan(this.currentServerSpan());
            this.localSpanThreadBinder().setCurrentSpan(this.currentLocalSpan());
            this.wrappedRunnable().run();
        }
        finally {
            this.serverSpanThreadBinder().setCurrentSpan(previousServerSpan);
            this.localSpanThreadBinder().setCurrentSpan(previousLocalSpan);
        }
    }
}

