/*
 * Decompiled with CFR 0.152.
 */
package com.github.kristofa.brave;

import com.github.kristofa.brave.AnnotationSubmitter;
import com.github.kristofa.brave.AutoValue_LocalTracer;
import com.github.kristofa.brave.Sampler;
import com.github.kristofa.brave.SpanAndEndpoint;
import com.github.kristofa.brave.SpanCollector;
import com.github.kristofa.brave.SpanId;
import com.twitter.zipkin.gen.BinaryAnnotation;
import com.twitter.zipkin.gen.Span;
import java.util.Random;

public abstract class LocalTracer
extends AnnotationSubmitter {
    static Builder builder() {
        return new AutoValue_LocalTracer.Builder();
    }

    static Builder builder(LocalTracer source) {
        return new AutoValue_LocalTracer.Builder(source);
    }

    @Override
    abstract SpanAndEndpoint.LocalSpanAndEndpoint spanAndEndpoint();

    abstract Random randomGenerator();

    abstract SpanCollector spanCollector();

    abstract Sampler traceSampler();

    public SpanId startNewSpan(String component, String operation) {
        SpanId spanId = this.startNewSpan(component, operation, this.currentTimeMicroseconds());
        if (spanId == null) {
            return null;
        }
        this.spanAndEndpoint().span().startTick = System.nanoTime();
        return spanId;
    }

    private SpanId getNewSpanId() {
        Span parentSpan = this.spanAndEndpoint().state().getCurrentServerSpan().getSpan();
        long newSpanId = this.randomGenerator().nextLong();
        SpanId.Builder builder = SpanId.builder().spanId(newSpanId);
        if (parentSpan == null) {
            return builder.build();
        }
        return builder.traceId(parentSpan.getTrace_id()).parentId(parentSpan.getId()).build();
    }

    public SpanId startNewSpan(String component, String operation, long timestamp) {
        Boolean sample = this.spanAndEndpoint().state().sample();
        if (Boolean.FALSE.equals(sample)) {
            this.spanAndEndpoint().state().setCurrentLocalSpan(null);
            return null;
        }
        SpanId newSpanId = this.getNewSpanId();
        if (sample == null && !this.traceSampler().isSampled(newSpanId.traceId)) {
            this.spanAndEndpoint().state().setCurrentLocalSpan(null);
            return null;
        }
        Span newSpan = newSpanId.toSpan();
        newSpan.setName(operation);
        newSpan.setTimestamp(timestamp);
        newSpan.addToBinary_annotations(BinaryAnnotation.create("lc", component, this.spanAndEndpoint().endpoint()));
        this.spanAndEndpoint().state().setCurrentLocalSpan(newSpan);
        return newSpanId;
    }

    public void finishSpan() {
        long endTick = System.nanoTime();
        Span span = this.spanAndEndpoint().span();
        if (span == null) {
            return;
        }
        Long startTick = span.startTick;
        long duration = startTick != null ? Math.max(1L, (endTick - startTick) / 1000L) : this.currentTimeMicroseconds() - span.getTimestamp();
        this.finishSpan(duration);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finishSpan(long duration) {
        Span span = this.spanAndEndpoint().span();
        if (span == null) {
            return;
        }
        Span span2 = span;
        synchronized (span2) {
            span.setDuration(duration);
            this.spanCollector().collect(span);
        }
        this.spanAndEndpoint().state().setCurrentLocalSpan(null);
    }

    LocalTracer() {
    }

    static abstract class Builder {
        Builder() {
        }

        abstract Builder spanAndEndpoint(SpanAndEndpoint.LocalSpanAndEndpoint var1);

        abstract Builder randomGenerator(Random var1);

        abstract Builder spanCollector(SpanCollector var1);

        abstract Builder traceSampler(Sampler var1);

        abstract LocalTracer build();
    }
}

