/*
 * Decompiled with CFR 0.152.
 */
package com.github.kristofa.brave;

import com.github.kristofa.brave.BraveCallable;
import com.github.kristofa.brave.BraveRunnable;
import com.github.kristofa.brave.ServerSpanThreadBinder;
import com.github.kristofa.brave.internal.Util;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class BraveExecutorService
implements ExecutorService,
Closeable {
    private final ExecutorService wrappedExecutor;
    private final ServerSpanThreadBinder threadBinder;

    public BraveExecutorService(ExecutorService wrappedExecutor, ServerSpanThreadBinder threadBinder) {
        this.wrappedExecutor = Util.checkNotNull(wrappedExecutor, "Null wrappedExecutor", new Object[0]);
        this.threadBinder = Util.checkNotNull(threadBinder, "Null threadBinder", new Object[0]);
    }

    @Override
    public void execute(Runnable arg0) {
        BraveRunnable braveRunnable = BraveRunnable.create(arg0, this.threadBinder);
        this.wrappedExecutor.execute(braveRunnable);
    }

    @Override
    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        return this.wrappedExecutor.awaitTermination(timeout, unit);
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> arg0) throws InterruptedException {
        return this.wrappedExecutor.invokeAll(this.buildBraveCollection(arg0));
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> arg0, long arg1, TimeUnit arg2) throws InterruptedException {
        return this.wrappedExecutor.invokeAll(this.buildBraveCollection(arg0), arg1, arg2);
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> arg0) throws InterruptedException, ExecutionException {
        return this.wrappedExecutor.invokeAny(this.buildBraveCollection(arg0));
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> arg0, long arg1, TimeUnit arg2) throws InterruptedException, ExecutionException, TimeoutException {
        return this.wrappedExecutor.invokeAny(this.buildBraveCollection(arg0), arg1, arg2);
    }

    @Override
    public boolean isShutdown() {
        return this.wrappedExecutor.isShutdown();
    }

    @Override
    public boolean isTerminated() {
        return this.wrappedExecutor.isTerminated();
    }

    @Override
    public void shutdown() {
        this.wrappedExecutor.shutdown();
    }

    @Override
    public List<Runnable> shutdownNow() {
        return this.wrappedExecutor.shutdownNow();
    }

    @Override
    public <T> Future<T> submit(Callable<T> arg0) {
        BraveCallable<T> braveCallable = BraveCallable.create(arg0, this.threadBinder);
        return this.wrappedExecutor.submit(braveCallable);
    }

    @Override
    public Future<?> submit(Runnable arg0) {
        BraveRunnable braveRunnable = BraveRunnable.create(arg0, this.threadBinder);
        return this.wrappedExecutor.submit(braveRunnable);
    }

    @Override
    public <T> Future<T> submit(Runnable arg0, T arg1) {
        BraveRunnable braveRunnable = BraveRunnable.create(arg0, this.threadBinder);
        return this.wrappedExecutor.submit(braveRunnable, arg1);
    }

    private <T> Collection<? extends Callable<T>> buildBraveCollection(Collection<? extends Callable<T>> originalCollection) {
        ArrayList<BraveCallable<T>> collection = new ArrayList<BraveCallable<T>>();
        for (Callable<T> t : originalCollection) {
            collection.add(BraveCallable.create(t, this.threadBinder));
        }
        return collection;
    }

    @Override
    public void close() {
        this.shutdown();
    }
}

