/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.handler.impl;

import io.vertx.core.MultiMap;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.file.FileSystem;
import io.vertx.core.http.HttpHeaders;
import io.vertx.core.http.HttpServerResponse;
import io.vertx.core.impl.logging.Logger;
import io.vertx.core.impl.logging.LoggerFactory;
import io.vertx.ext.web.RoutingContext;
import io.vertx.ext.web.handler.FaviconHandler;

public class FaviconHandlerImpl
implements FaviconHandler {
    private static final Logger LOG = LoggerFactory.getLogger(FaviconHandler.class);
    private static final String DEFAULT_VERTX_ICON = "META-INF/vertx/web/favicon.ico";
    private final Icon NULL_ICON = new Icon();
    private final Icon icon;
    private final long maxAgeSeconds;

    public FaviconHandlerImpl(Vertx vertx, String path, long maxAgeSeconds) {
        this.maxAgeSeconds = maxAgeSeconds;
        if (maxAgeSeconds < 0L) {
            throw new IllegalArgumentException("maxAgeSeconds must be > 0");
        }
        FileSystem fs = vertx.fileSystem();
        Buffer buffer = null;
        if (path == null) {
            try {
                buffer = this.readFile(fs, "favicon.ico");
            }
            catch (RuntimeException e) {
                try {
                    buffer = fs.readFileBlocking(DEFAULT_VERTX_ICON);
                }
                catch (RuntimeException runtimeException) {}
            }
        } else {
            try {
                buffer = this.readFile(fs, path);
            }
            catch (RuntimeException e) {
                LOG.error((Object)("Could not load favicon " + path));
            }
        }
        this.icon = buffer != null ? new Icon(buffer) : this.NULL_ICON;
    }

    public FaviconHandlerImpl(Vertx vertx, long maxAgeSeconds) {
        this(vertx, null, maxAgeSeconds);
    }

    public FaviconHandlerImpl(Vertx vertx, String path) {
        this(vertx, path, 86400L);
    }

    public FaviconHandlerImpl(Vertx vertx) {
        this(vertx, null);
    }

    private Buffer readFile(FileSystem fs, String path) {
        if (fs.existsBlocking(path)) {
            return fs.readFileBlocking(path);
        }
        throw new RuntimeException(path + " not found!");
    }

    public void handle(RoutingContext ctx) {
        if ("/favicon.ico".equals(ctx.request().path())) {
            HttpServerResponse resp = ctx.response();
            if (this.icon == this.NULL_ICON) {
                resp.setStatusCode(404).end();
            } else {
                resp.headers().addAll(this.icon.headers);
                resp.end(this.icon.body);
            }
        } else {
            ctx.next();
        }
    }

    private class Icon {
        private final MultiMap headers;
        private final Buffer body;

        private Icon(Buffer buffer) {
            this.headers = HttpHeaders.headers();
            this.body = buffer;
            this.headers.add(HttpHeaders.CONTENT_TYPE, (CharSequence)"image/x-icon");
            this.headers.add(HttpHeaders.CONTENT_LENGTH, (CharSequence)Integer.toString(buffer.length()));
            this.headers.add(HttpHeaders.CACHE_CONTROL, (CharSequence)("public, max-age=" + FaviconHandlerImpl.this.maxAgeSeconds));
        }

        private Icon() {
            this.headers = null;
            this.body = null;
        }
    }
}

